/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.bcb;

import java.io.File;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.jvnet.flamingo.bcb.BreadcrumbBar;
import org.jvnet.flamingo.bcb.BreadcrumbBarCallBack;
import org.jvnet.flamingo.bcb.BreadcrumbItem;
import org.jvnet.flamingo.bcb.BreadcrumbItemChoices;

public class BreadcrumbFileSelector
extends BreadcrumbBar {
    protected FileSystemView fsv = FileSystemView.getFileSystemView();
    protected boolean useNativeIcons;

    public BreadcrumbFileSelector() {
        this(true);
    }

    public BreadcrumbFileSelector(boolean useNativeIcons) {
        super(null, ":", null);
        this.useNativeIcons = useNativeIcons;
        this.callback = new DirCallback();
        File[] roots = File.listRoots();
        BreadcrumbItem[] bRoots = new BreadcrumbItem[roots.length];
        int count = 0;
        for (File root : roots) {
            String systemName = this.fsv.getSystemDisplayName(root);
            if (systemName.length() == 0) {
                systemName = root.getAbsolutePath();
            }
            BreadcrumbItem rootItem = new BreadcrumbItem(new String[]{systemName, root.getAbsolutePath()});
            Icon icon = this.fsv.getSystemIcon(root);
            if (useNativeIcons) {
                rootItem.setIcon(icon);
            }
            bRoots[count++] = rootItem;
        }
        this.pushChoices(new BreadcrumbItemChoices(bRoots));
    }

    public void setUseNativeIcons(boolean useNativeIcons) {
        this.useNativeIcons = useNativeIcons;
    }

    public FileSystemView getFileSystemView() {
        return this.fsv;
    }

    public class DirCallback
    implements BreadcrumbBarCallBack {
        protected BreadcrumbItemChoices getChoices(File directory) {
            if (!directory.exists()) {
                return new BreadcrumbItemChoices(new BreadcrumbItem[0]);
            }
            if (!directory.isDirectory()) {
                return null;
            }
            LinkedList<BreadcrumbItem> lResult = new LinkedList<BreadcrumbItem>();
            for (File child : directory.listFiles()) {
                if (!child.isDirectory() || child.isHidden()) continue;
                BreadcrumbItem currDirItem = new BreadcrumbItem(new String[]{child.getName(), child.getAbsolutePath()});
                if (BreadcrumbFileSelector.this.useNativeIcons) {
                    currDirItem.setIcon(BreadcrumbFileSelector.this.fsv.getSystemIcon(child));
                }
                lResult.addLast(currDirItem);
            }
            BreadcrumbItem[] aResult = new BreadcrumbItem[lResult.size()];
            int count = 0;
            for (BreadcrumbItem item : lResult) {
                aResult[count++] = item;
            }
            return new BreadcrumbItemChoices(aResult);
        }

        public BreadcrumbItemChoices getChoices(BreadcrumbItem[] path) {
            if (path == null) {
                File[] roots = File.listRoots();
                BreadcrumbItem[] bRoots = new BreadcrumbItem[roots.length];
                int count = 0;
                for (File root : roots) {
                    String systemName = BreadcrumbFileSelector.this.fsv.getSystemDisplayName(root);
                    if (systemName.length() == 0) {
                        systemName = root.getAbsolutePath();
                    }
                    BreadcrumbItem rootItem = new BreadcrumbItem(new String[]{systemName, root.getAbsolutePath()});
                    if (BreadcrumbFileSelector.this.useNativeIcons) {
                        rootItem.setIcon(BreadcrumbFileSelector.this.fsv.getSystemIcon(root));
                    }
                    bRoots[count++] = rootItem;
                }
                return new BreadcrumbItemChoices(bRoots);
            }
            if (path.length == 0) {
                return null;
            }
            String dirName = path[path.length - 1].getValue()[1];
            File file = new File(dirName);
            return this.getChoices(file);
        }
    }
}

