/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.bcb;

import java.awt.Color;
import java.awt.event.MouseListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jvnet.flamingo.bcb.BreadcrumbBarCallBack;
import org.jvnet.flamingo.bcb.BreadcrumbBarEvent;
import org.jvnet.flamingo.bcb.BreadcrumbBarListener;
import org.jvnet.flamingo.bcb.BreadcrumbItem;
import org.jvnet.flamingo.bcb.BreadcrumbItemChoices;
import org.jvnet.flamingo.bcb.BreadcrumbStack;
import org.jvnet.flamingo.bcb.ui.BasicBreadcrumbBarUI;
import org.jvnet.flamingo.bcb.ui.BreadcrumbBarUI;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreadcrumbBar
extends JComponent {
    public static final String TAG_BCB = "bcbmemory";
    public static final String TAG_PATH = "bcbpath";
    public static final String TAG_ITEM = "bcbitem";
    public static final String TAG_COMPONENT = "bcbcomponent";
    private static final long serialVersionUID = 3258407339731400502L;
    protected BreadcrumbStack stack;
    protected Icon icon;
    protected String separator;
    protected JButton okButton;
    protected BreadcrumbBarCallBack callback = null;
    protected Color underlineColor = null;
    protected Color boxColor = null;
    private List<BreadcrumbBarListener> listeners = null;
    private boolean noEvent = false;
    private MouseListener popupListener = null;
    private List<BreadcrumbItem[]> memory = null;
    private int currentMemoryIndex = -1;
    private static final String uiClassID = "BreadcrumbBarUI";

    public void setPopupListener(MouseListener pl) {
        this.popupListener = pl;
    }

    public MouseListener getPopupListener() {
        return this.popupListener;
    }

    public void addListener(BreadcrumbBarListener lst) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<BreadcrumbBarListener>();
        }
        if (!this.listeners.contains(lst)) {
            this.listeners.add(lst);
        }
    }

    public void removeListener(BreadcrumbBarListener lst) {
        if (this.listeners != null) {
            this.listeners.remove(lst);
        }
    }

    public void fireBreadcrumbBarEvent(BreadcrumbBarEvent event) {
        if (this.noEvent || this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).breadcrumbBarEvent(event);
        }
    }

    public BreadcrumbBar() {
        this(null, null, null, null);
    }

    public BreadcrumbBar(Icon icon, String separator, JButton okButton, BreadcrumbBarCallBack callback) {
        this.icon = icon;
        this.stack = new BreadcrumbStack();
        this.separator = separator;
        this.okButton = okButton;
        this.callback = callback;
        this.updateUI();
    }

    public BreadcrumbBar(Icon icon, String separator, BreadcrumbBarCallBack callback) {
        this(icon, separator, null, callback);
    }

    public BreadcrumbBar(String separator, JButton okButton, BreadcrumbBarCallBack callback) {
        this(null, separator, okButton, callback);
    }

    public BreadcrumbBar(String separator, BreadcrumbBarCallBack callback) {
        this(null, separator, null, callback);
    }

    public void setUnderlineColor(Color color) {
        this.underlineColor = color;
    }

    public void setBoxColor(Color color) {
        this.boxColor = color;
    }

    public Color getBoxColor() {
        return this.boxColor;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setPath(BreadcrumbItem[] newPath) {
        BreadcrumbItem[] old = this.getPath();
        this.stack.clear();
        this.noEvent = true;
        BreadcrumbItemChoices bic = null;
        bic = this.callback.getChoices(null);
        this.pushChoices(bic, false);
        for (int i = 0; newPath != null && i < newPath.length; ++i) {
            BreadcrumbItem bi = newPath[i];
            this.pushChoice(bi, false);
            BreadcrumbItem[] subPath = new BreadcrumbItem[i + 1];
            System.arraycopy(newPath, 0, subPath, 0, i + 1);
            bic = this.callback.getChoices(subPath);
            if (bic == null && i + 1 < newPath.length) {
                bic = new BreadcrumbItemChoices(new BreadcrumbItem[]{bi});
            }
            if (bic == null) continue;
            this.pushChoices(bic, false);
        }
        this.getUI().updateComponents();
        this.noEvent = false;
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 0, old, newPath));
    }

    public BreadcrumbItem[] getPath() {
        return this.getPath(-1);
    }

    public BreadcrumbItem[] getPath(int beginIndex) {
        assert (beginIndex <= this.stack.size());
        Vector<BreadcrumbItem> path = new Vector<BreadcrumbItem>();
        ListIterator it = this.stack.listIterator(0);
        while (it.hasNext()) {
            Object elem = it.next();
            if (elem instanceof BreadcrumbItem) {
                path.add((BreadcrumbItem)elem);
            }
            if (this.stack.indexOf(elem) != beginIndex) continue;
            break;
        }
        BreadcrumbItem[] array = new BreadcrumbItem[path.size()];
        int i = 0;
        while (!path.isEmpty()) {
            array[i++] = (BreadcrumbItem)path.remove(0);
        }
        return array;
    }

    public BreadcrumbItem getLastItem() {
        if (this.stack.isEmpty()) {
            return null;
        }
        Object last = this.stack.get(this.stack.size() - 1);
        if (last instanceof BreadcrumbItem) {
            return (BreadcrumbItem)last;
        }
        return null;
    }

    public BreadcrumbItem getItem(int index) {
        if (this.stack.isEmpty()) {
            return null;
        }
        if (index < 0 || index >= this.stack.size()) {
            return null;
        }
        Object last = this.stack.get(index);
        if (last instanceof BreadcrumbItem) {
            return (BreadcrumbItem)last;
        }
        return null;
    }

    public String getRootedPath() {
        return this.getRootedPath(-1);
    }

    public String getRootedPath(int beginIndex) {
        assert (beginIndex <= this.stack.size());
        StringBuffer path = new StringBuffer();
        ListIterator it = this.stack.listIterator(0);
        while (it.hasNext()) {
            Object elem = it.next();
            if (elem instanceof BreadcrumbItemChoices) {
                path.append(this.separator);
            } else if (elem instanceof BreadcrumbItem) {
                path.append(((BreadcrumbItem)elem).getName());
            }
            if (this.stack.indexOf(elem) != beginIndex) continue;
            break;
        }
        return path.toString();
    }

    public Object pushChoices(BreadcrumbItemChoices bic) {
        return this.pushChoices(bic, true);
    }

    public Object pushChoices(BreadcrumbItemChoices bic, boolean toUpdateUI) {
        if (bic == null) {
            return null;
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(true);
        }
        if (this.stack.size() % 2 == 1) {
            this.stack.pop();
        }
        bic.setIndex(this.stack.size());
        Object obj = this.stack.push(bic);
        if (toUpdateUI) {
            this.getUI().updateComponents();
        }
        return obj;
    }

    public static BreadcrumbItemChoices makeChoices(String[] choices) {
        if (choices == null) {
            return null;
        }
        BreadcrumbItem[] items = new BreadcrumbItem[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            items[i] = new BreadcrumbItem(new String[]{choices[i]});
        }
        return new BreadcrumbItemChoices(items);
    }

    public static BreadcrumbItemChoices makeChoices(Vector<String> choices) {
        if (choices == null) {
            return null;
        }
        BreadcrumbItem[] items = new BreadcrumbItem[choices.size()];
        for (int i = 0; i < choices.size(); ++i) {
            items[i] = new BreadcrumbItem(new String[]{choices.get(i)});
        }
        return new BreadcrumbItemChoices(items);
    }

    public Object pushChoice(BreadcrumbItem bi) {
        return this.pushChoice(bi, true);
    }

    public Object pushChoice(BreadcrumbItem bi, boolean toUpdateUI) {
        assert (bi != null);
        if (this.okButton != null) {
            this.okButton.setEnabled(true);
        }
        BreadcrumbItem[] old = this.getPath();
        if (!this.stack.isEmpty() && this.stack.size() % 2 == 0) {
            this.stack.pop();
        }
        bi.setIndex(this.stack.size());
        Object obj = this.stack.push(bi);
        if (toUpdateUI) {
            this.getUI().updateComponents();
        }
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 0, old, this.getPath()));
        return obj;
    }

    public Object pop() {
        if (this.stack.size() <= 1 && this.okButton != null) {
            this.okButton.setEnabled(false);
        }
        return this.stack.pop();
    }

    public int getItemCount() {
        return this.stack.size();
    }

    @Override
    public String toString() {
        return Arrays.asList(this.getPath()).toString();
    }

    public void previous() {
        if (!this.hasPrevious()) {
            return;
        }
        this.setPath(this.memory.get(--this.currentMemoryIndex));
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 1, null, null));
    }

    public void next() {
        if (!this.hasNext()) {
            return;
        }
        this.setPath(this.memory.get(++this.currentMemoryIndex));
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 1, null, null));
    }

    public void setMemoryIndex(int memoryIndex) {
        if (this.memory != null && memoryIndex >= 0 && memoryIndex < this.memory.size()) {
            this.currentMemoryIndex = memoryIndex;
            this.setPath(this.memory.get(this.currentMemoryIndex));
        }
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 1, null, null));
    }

    public List<BreadcrumbItem[]> getMemory() {
        return Collections.unmodifiableList(this.memory);
    }

    public int getMemoryIndex() {
        return this.currentMemoryIndex;
    }

    public boolean hasNext() {
        return this.memory != null && this.memory.size() > this.currentMemoryIndex + 1;
    }

    public boolean hasPrevious() {
        return this.memory != null && this.currentMemoryIndex > 0;
    }

    public void addPathToMemory(BreadcrumbItem[] path) {
        if (this.memory == null) {
            this.memory = new ArrayList<BreadcrumbItem[]>();
        }
        if (this.currentMemoryIndex != this.memory.size()) {
            // empty if block
        }
        this.memory.add(path);
        ++this.currentMemoryIndex;
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 1, null, null));
    }

    public void addCurrentPathToMemory() {
        this.addPathToMemory(this.getPath());
    }

    public void clearMemory() {
        if (this.memory != null) {
            this.memory.clear();
        }
        this.currentMemoryIndex = -1;
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 1, null, null));
    }

    private static void putOpenTag(PrintWriter pw, String tag, boolean addNewLine) {
        pw.write("<" + tag + ">");
        if (addNewLine) {
            pw.write(System.getProperty("line.separator"));
        }
    }

    private static void putCloseTag(PrintWriter pw, String tag, boolean addNewLine) {
        pw.write("</" + tag + ">");
        if (addNewLine) {
            pw.write(System.getProperty("line.separator"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMemory(OutputStream out) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(out);
            BreadcrumbBar.putOpenTag(pw, TAG_BCB, true);
            if (this.memory != null) {
                for (BreadcrumbItem[] path : this.memory) {
                    pw.write("\t");
                    BreadcrumbBar.putOpenTag(pw, TAG_PATH, true);
                    for (BreadcrumbItem item : path) {
                        pw.write("\t\t");
                        BreadcrumbBar.putOpenTag(pw, TAG_ITEM, true);
                        for (String comp : item.getValue()) {
                            pw.write("\t\t\t");
                            BreadcrumbBar.putOpenTag(pw, TAG_COMPONENT, false);
                            pw.write(comp);
                            BreadcrumbBar.putCloseTag(pw, TAG_COMPONENT, true);
                        }
                        pw.write("\t\t");
                        BreadcrumbBar.putCloseTag(pw, TAG_ITEM, true);
                    }
                    pw.write("\t");
                    BreadcrumbBar.putCloseTag(pw, TAG_PATH, true);
                }
            }
            BreadcrumbBar.putCloseTag(pw, TAG_BCB, true);
            pw.write(System.getProperty("line.separator"));
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public void loadMemory(InputStream in) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            DefaultHandler handler = new DefaultHandler(){
                List<BreadcrumbItem> currPath;
                List<String> currComponents;
                String currValue;

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    this.currValue = null;
                    if (BreadcrumbBar.TAG_PATH.equals(qName)) {
                        this.currPath = new LinkedList<BreadcrumbItem>();
                        return;
                    }
                    if (BreadcrumbBar.TAG_ITEM.equals(qName)) {
                        this.currComponents = new LinkedList<String>();
                    }
                }

                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (BreadcrumbBar.TAG_PATH.equals(qName)) {
                        BreadcrumbBar.this.memory.add(this.currPath.toArray(new BreadcrumbItem[0]));
                        return;
                    }
                    if (BreadcrumbBar.TAG_ITEM.equals(qName)) {
                        BreadcrumbItem item = new BreadcrumbItem(this.currComponents.toArray(new String[0]));
                        BreadcrumbBar.this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(BreadcrumbBar.this, 2, null, item));
                        this.currPath.add(item);
                        return;
                    }
                    if (BreadcrumbBar.TAG_COMPONENT.equals(qName)) {
                        this.currComponents.add(this.currValue);
                        return;
                    }
                }

                public void characters(char[] ch, int start, int length) throws SAXException {
                    String toAdd = new String(ch, start, length);
                    this.currValue = this.currValue == null ? toAdd : this.currValue + toAdd;
                }
            };
            parser.parse(in, handler);
        }
        catch (Exception exc) {
            throw new IllegalStateException(exc);
        }
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 1, null, null));
    }

    public BreadcrumbBarCallBack getCallback() {
        return this.callback;
    }

    public void setUI(BreadcrumbBarUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((BreadcrumbBarUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicBreadcrumbBarUI());
        }
    }

    @Override
    public BreadcrumbBarUI getUI() {
        return (BreadcrumbBarUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public BreadcrumbStack getStack() {
        return this.stack;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public Color getUnderlineColor() {
        return this.underlineColor;
    }

    public static interface BreadcrumbBarElement {
        public String getText();

        public int getIndex();
    }
}

