/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.filemanager.ver3.search;

import ddb.dsz.core.host.HostInfo;
import ddb.dsz.plugin.filemanager.ver3.search.DateSearchType;
import ddb.dsz.plugin.filemanager.ver3.search.MimeTypeMap;
import ddb.dsz.plugin.filemanager.ver3.search.Searcher;
import ddb.imagemanager.ImageManager;
import ddb.targetmodel.filemodel.FileObject;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.ClosureUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchParameters
extends JPanel {
    DefaultComboBoxModel types = new DefaultComboBoxModel();
    DefaultListCellRenderer typesRenderer = new DefaultListCellRenderer(){

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (component instanceof JLabel && object != null) {
                JLabel jLabel = (JLabel)component;
                if (object.equals(Boolean.TRUE)) {
                    jLabel.setText("(All Files and Folders");
                    jLabel.setIcon(null);
                }
                if (object instanceof MimeTypeMap.MimeType) {
                    jLabel.setText(((MimeTypeMap.MimeType)MimeTypeMap.MimeType.class.cast(object)).getName());
                    jLabel.setIcon(ImageManager.getIcon((String)((MimeTypeMap.MimeType)MimeTypeMap.MimeType.class.cast(object)).getIcon(), (Dimension)ImageManager.SIZE16));
                }
            }
            return component;
        }
    };
    DefaultComboBoxModel sizeTypes = new DefaultComboBoxModel();
    DefaultComboBoxModel sizeChoices = new DefaultComboBoxModel();
    DefaultListCellRenderer sizeRenderer = new DefaultListCellRenderer(){

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (component instanceof JLabel && object != null) {
                JLabel jLabel = (JLabel)component;
                if (object instanceof Boolean) {
                    if (Boolean.TRUE.equals(object)) {
                        jLabel.setText("at least");
                    } else {
                        jLabel.setText("at most");
                    }
                }
                if (object instanceof SizeMultiplier) {
                    jLabel.setText(((SizeMultiplier)((Object)SizeMultiplier.class.cast(object))).getSuffix());
                }
            }
            return component;
        }
    };
    DefaultComboBoxModel fileSearchRoot = new DefaultComboBoxModel();
    DefaultListCellRenderer fileSearchRenderer = new DefaultListCellRenderer(){

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (component instanceof JLabel && object != null) {
                JLabel jLabel = (JLabel)component;
                if (object instanceof Boolean) {
                    jLabel.setText("Target Computer");
                    jLabel.setIcon(null);
                }
                if (object instanceof FileObject) {
                    String string = ((FileObject)object).getPath() + "/" + ((FileObject)object).getName();
                    String string2 = string = string.substring(0, 5).equals("null/") ? string.substring(5) : string;
                    if (string.length() > 34) {
                        String string3 = string.substring(string.length() - 28, string.length());
                        int n2 = string3.indexOf("/") > -1 ? string3.indexOf("/") + 1 : 0;
                        string3 = string3.substring(n2);
                        string = string.substring(0, 3) + ".../" + string3;
                    }
                    jLabel.setText(string);
                    jLabel.setIcon(ImageManager.getIcon((String)((FileObject)FileObject.class.cast(object)).getIcon(), (Dimension)ImageManager.SIZE16));
                }
            }
            return component;
        }
    };
    Closure startSearching = ClosureUtils.nopClosure();
    Closure stopSearching = ClosureUtils.nopClosure();
    private ButtonGroup DateOptions;
    private JCheckBox caseCheckBox;
    private JRadioButton dateBetween;
    private JRadioButton dateLastDays;
    private JRadioButton dateLastMonths;
    private JPanel dateOptions;
    private JComboBox dateType;
    private JComboBox hostListing;
    private JCheckBox isDate;
    private JCheckBox isSize;
    private JCheckBox isType;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JSpinner lastDays;
    private JSpinner lastMonths;
    private JButton searchCancel;
    private JButton searchGo;
    private JComboBox searchMethod;
    private JPanel searchOptions;
    private JTextField searchPattern;
    private JComboBox searchRoot;
    private ButtonGroup searchType;
    private JComboBox sizeMultiplier;
    private JPanel sizeOptions;
    private JComboBox sizeScopeCombo;
    private JSpinner sizeSize;
    private JSpinner startDate;
    private JSpinner stopDate;
    private JComboBox typeCombo;
    private JPanel typeOptions;
    private BindingGroup bindingGroup;

    public SearchParameters(List<HostInfo> list, HostInfo hostInfo) {
        this.initComponents();
        this.isDateStateChanged(null);
        this.isTypeStateChanged(null);
        this.isSizeStateChanged(null);
        this.types.addElement(Boolean.TRUE);
        Vector<MimeTypeMap.MimeType> vector = new Vector<MimeTypeMap.MimeType>();
        vector.addAll(MimeTypeMap.getMimeTypes());
        Collections.sort(vector);
        for (MimeTypeMap.MimeType mimeType : vector) {
            this.types.addElement(mimeType);
        }
        this.hostListing.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.hostListing.setSelectedItem(hostInfo);
        this.hostListing.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (component instanceof JLabel && object instanceof HostInfo) {
                    JLabel jLabel = (JLabel)component;
                    HostInfo hostInfo = (HostInfo)object;
                    jLabel.setText(String.format("%s:  %s/%s/%s", hostInfo.getId(), hostInfo.getArch(), hostInfo.getPlatform(), hostInfo.getVersion()));
                }
                return component;
            }
        });
        this.types.setSelectedItem(Boolean.TRUE);
        this.sizeTypes.addElement(Boolean.TRUE);
        this.sizeTypes.addElement(Boolean.FALSE);
        this.sizeTypes.setSelectedItem(Boolean.TRUE);
        for (SizeMultiplier sizeMultiplier : SizeMultiplier.values()) {
            this.sizeChoices.addElement(sizeMultiplier);
        }
        this.sizeChoices.setSelectedItem((Object)SizeMultiplier.Kilobytes);
        this.fileSearchRoot.addElement(Boolean.TRUE);
        this.fileSearchRoot.setSelectedItem(Boolean.TRUE);
        Calendar calendar = Calendar.getInstance();
        this.stopDate.setValue(calendar.getTime());
        calendar.add(5, -14);
        this.startDate.setValue(calendar.getTime());
    }

    public void setSearchActions(Closure closure, Closure closure2) {
        this.startSearching = closure;
        this.stopSearching = closure2;
    }

    public void searchingStarted() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SearchParameters.this.searchGo.setEnabled(false);
                SearchParameters.this.searchCancel.setEnabled(true);
            }
        });
    }

    public void searchingStopped() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SearchParameters.this.searchGo.setEnabled(true);
                SearchParameters.this.searchCancel.setEnabled(false);
            }
        });
    }

    public HostInfo getHost() {
        return (HostInfo)this.hostListing.getSelectedItem();
    }

    public void addSearchRoot(FileObject fileObject, boolean bl) {
        if (fileObject == null) {
            return;
        }
        boolean bl2 = false;
        for (int i = 0; i < this.fileSearchRoot.getSize() && !bl2; ++i) {
            Object e = this.fileSearchRoot.getElementAt(i);
            if (!(e instanceof FileObject) || ((FileObject)FileObject.class.cast(e)).getId() != fileObject.getId()) continue;
            bl2 = true;
            fileObject = (FileObject)e;
        }
        if (!bl2) {
            this.fileSearchRoot.addElement(fileObject);
        }
        if (bl) {
            this.fileSearchRoot.setSelectedItem(fileObject);
        }
    }

    boolean configure(Searcher searcher) {
        Object object;
        searcher.name = this.searchPattern.getText();
        searcher.searchRoot = this.searchRoot.getSelectedItem() instanceof FileObject ? (FileObject)FileObject.class.cast(this.searchRoot.getSelectedItem()) : null;
        if (this.isDate.isSelected()) {
            searcher.dateType = (DateSearchType)((Object)this.dateType.getSelectedItem());
            if (this.dateLastMonths.isSelected()) {
                searcher.lastDays = (Integer)Integer.class.cast(this.lastMonths.getValue()) * 30;
            } else if (this.dateLastDays.isSelected()) {
                searcher.lastDays = (Integer)Integer.class.cast(this.lastDays.getValue());
            } else if (this.dateBetween.isSelected()) {
                searcher.spanStart = Calendar.getInstance();
                searcher.spanStop = Calendar.getInstance();
                searcher.spanStart.setTime((Date)this.startDate.getValue());
                searcher.spanStop.setTime((Date)this.stopDate.getValue());
            }
        }
        searcher.isCaseSensitive = this.caseCheckBox.isSelected();
        if (this.searchMethod.getSelectedItem() == Searcher.SearchType.GLOB) {
            searcher.searchType = Searcher.SearchType.GLOB;
        } else if (this.searchMethod.getSelectedItem() == Searcher.SearchType.REGEX) {
            try {
                searcher.regexPattern = searcher.isCaseSensitive ? Pattern.compile(this.searchPattern.getText()) : Pattern.compile(this.searchPattern.getText().toLowerCase());
            }
            catch (Exception exception) {
                return false;
            }
            searcher.searchType = Searcher.SearchType.REGEX;
        }
        if (this.isType.isSelected() && (object = this.typeCombo.getSelectedItem()) instanceof MimeTypeMap.MimeType) {
            searcher.mimeType = (MimeTypeMap.MimeType)object;
        }
        if (this.isSize.isSelected()) {
            object = (SizeMultiplier)((Object)this.sizeMultiplier.getSelectedItem());
            if (this.sizeScopeCombo.getSelectedItem().equals(Boolean.TRUE)) {
                searcher.minimumSize = ((SizeMultiplier)((Object)object)).getSize() * (long)((Integer)Integer.class.cast(this.sizeSize.getValue())).intValue();
            } else {
                searcher.maximumSize = ((SizeMultiplier)((Object)object)).getSize() * (long)((Integer)Integer.class.cast(this.sizeSize.getValue())).intValue();
            }
        }
        return true;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.DateOptions = new ButtonGroup();
        this.searchType = new ButtonGroup();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.searchPattern = new JTextField();
        this.jLabel2 = new JLabel();
        this.searchRoot = new JComboBox();
        this.searchGo = new JButton();
        this.searchCancel = new JButton();
        this.searchOptions = new JPanel();
        this.isDate = new JCheckBox();
        this.dateOptions = new JPanel();
        this.dateType = new JComboBox();
        this.dateLastMonths = new JRadioButton();
        this.lastMonths = new JSpinner();
        this.dateLastDays = new JRadioButton();
        this.dateBetween = new JRadioButton();
        this.lastDays = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.startDate = new JSpinner();
        this.jLabel5 = new JLabel();
        this.stopDate = new JSpinner();
        this.isType = new JCheckBox();
        this.typeOptions = new JPanel();
        this.typeCombo = new JComboBox();
        this.isSize = new JCheckBox();
        this.sizeOptions = new JPanel();
        this.sizeScopeCombo = new JComboBox();
        this.sizeSize = new JSpinner();
        this.sizeMultiplier = new JComboBox();
        this.jLabel6 = new JLabel();
        this.hostListing = new JComboBox();
        this.jLabel7 = new JLabel();
        this.searchMethod = new JComboBox();
        this.caseCheckBox = new JCheckBox();
        this.jCheckBox1.setText("jCheckBox1");
        this.jLabel1.setText("Search for files or folders:");
        this.searchPattern.setToolTipText("A string the file name contains (.xml, etc)");
        this.searchPattern.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SearchParameters.this.searchPatternKeyReleased(keyEvent);
            }
        });
        this.jLabel2.setText("Look In:");
        this.searchRoot.setModel(this.fileSearchRoot);
        this.searchRoot.setRenderer(this.fileSearchRenderer);
        this.searchGo.setText("Search Now");
        this.searchGo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchParameters.this.searchGoActionPerformed(actionEvent);
            }
        });
        this.searchCancel.setText("Stop Search");
        this.searchCancel.setEnabled(false);
        this.searchCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchParameters.this.searchCancelActionPerformed(actionEvent);
            }
        });
        this.searchOptions.setBorder(BorderFactory.createTitledBorder("Search Options"));
        this.isDate.setText("Date");
        this.isDate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SearchParameters.this.isDateStateChanged(changeEvent);
            }
        });
        this.dateOptions.setBorder(BorderFactory.createEtchedBorder());
        this.dateType.setModel(DateSearchType.getModel());
        this.dateType.setSelectedItem((Object)DateSearchType.Modified);
        this.DateOptions.add(this.dateLastMonths);
        this.dateLastMonths.setSelected(true);
        this.dateLastMonths.setText("in the last");
        this.lastMonths.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dateLastMonths, (Property)ELProperty.create((String)"${selected}"), (Object)this.lastMonths, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)autoBinding);
        this.DateOptions.add(this.dateLastDays);
        this.dateLastDays.setText("in the last");
        this.DateOptions.add(this.dateBetween);
        this.dateBetween.setText("between");
        this.lastDays.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dateLastDays, (Property)ELProperty.create((String)"${selected}"), (Object)this.lastDays, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)autoBinding);
        this.jLabel3.setText("months");
        this.jLabel4.setText("days");
        this.startDate.setModel(new SpinnerDateModel());
        autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dateBetween, (Property)ELProperty.create((String)"${selected}"), (Object)this.startDate, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)autoBinding);
        this.jLabel5.setText("and");
        this.stopDate.setModel(new SpinnerDateModel());
        autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.dateBetween, (Property)ELProperty.create((String)"${selected}"), (Object)this.stopDate, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)autoBinding);
        GroupLayout groupLayout = new GroupLayout((Container)this.dateOptions);
        this.dateOptions.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.dateType, 0, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.dateLastMonths).addPreferredGap(0).add((Component)this.lastMonths).addPreferredGap(0).add((Component)this.jLabel3).add(11, 11, 11)).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.dateBetween).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.jLabel5))).add(8, 8, 8)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.dateLastDays, -1, -1, Short.MAX_VALUE).addPreferredGap(0))).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lastDays).addPreferredGap(0).add((Component)this.jLabel4).add(25, 25, 25)).add((Component)this.startDate).add((Component)this.stopDate)))).add(13, 13, 13)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.dateType, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.dateLastMonths).add((Component)this.lastMonths, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.dateLastDays).add((Component)this.lastDays, -2, -1, -2).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.dateBetween).add((Component)this.startDate, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.stopDate, -2, -1, -2).add((Component)this.jLabel5)).addContainerGap(-1, Short.MAX_VALUE)));
        this.isType.setText("Type");
        this.isType.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SearchParameters.this.isTypeStateChanged(changeEvent);
            }
        });
        this.typeOptions.setBorder(BorderFactory.createEtchedBorder());
        this.typeCombo.setModel(this.types);
        this.typeCombo.setRenderer(this.typesRenderer);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.typeOptions);
        this.typeOptions.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.typeCombo, 0, -1, Short.MAX_VALUE).add(21, 21, 21)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.typeCombo, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.isSize.setText("Size");
        this.isSize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SearchParameters.this.isSizeStateChanged(changeEvent);
            }
        });
        this.sizeOptions.setBorder(BorderFactory.createEtchedBorder());
        this.sizeScopeCombo.setModel(this.sizeTypes);
        this.sizeScopeCombo.setRenderer(this.sizeRenderer);
        this.sizeSize.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.sizeMultiplier.setModel(this.sizeChoices);
        this.sizeMultiplier.setRenderer(this.sizeRenderer);
        GroupLayout groupLayout3 = new GroupLayout((Container)this.sizeOptions);
        this.sizeOptions.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.sizeScopeCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.sizeSize).addPreferredGap(0).add((Component)this.sizeMultiplier, 0, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.sizeScopeCombo, -2, -1, -2).add((Component)this.sizeSize, -2, -1, -2).add((Component)this.sizeMultiplier, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout4 = new GroupLayout((Container)this.searchOptions);
        this.searchOptions.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.isType)).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.isDate)).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.isSize)).add(2, (GroupLayout.Group)groupLayout4.createSequentialGroup().add(27, 27, 27).add((GroupLayout.Group)groupLayout4.createParallelGroup(2).add(1, (Component)this.dateOptions, -1, -1, Short.MAX_VALUE).add(1, (Component)this.typeOptions, -1, -1, Short.MAX_VALUE).add(1, (Component)this.sizeOptions, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.isDate).addPreferredGap(0).add((Component)this.dateOptions, -2, -1, -2).addPreferredGap(0).add((Component)this.isType).addPreferredGap(0).add((Component)this.typeOptions, -2, -1, -2).addPreferredGap(0).add((Component)this.isSize).addPreferredGap(0).add((Component)this.sizeOptions, -2, -1, -2).addContainerGap()));
        this.jLabel6.setText("Host:");
        this.hostListing.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel7.setText("Search method:");
        this.searchMethod.setModel(new DefaultComboBoxModel<Searcher.SearchType>(Searcher.SearchType.values()));
        this.caseCheckBox.setText("Case Sensitive");
        GroupLayout groupLayout5 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.searchOptions, -1, -1, Short.MAX_VALUE).add((Component)this.jLabel1, -1, -1, Short.MAX_VALUE).add((Component)this.searchRoot, 0, -1, Short.MAX_VALUE).add((Component)this.searchPattern).add((Component)this.hostListing, 0, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel6).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.searchGo).addPreferredGap(0).add((Component)this.searchCancel)).add((Component)this.jLabel7)).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.searchMethod, -2, -1, -2).add(42, 42, 42).add((Component)this.caseCheckBox, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.searchPattern, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel7).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.searchMethod, -2, -1, -2).add((Component)this.caseCheckBox)).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.searchRoot, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel6).add(3, 3, 3).add((Component)this.hostListing, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.searchGo).add((Component)this.searchCancel)).addPreferredGap(0).add((Component)this.searchOptions, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    private void isDateStateChanged(ChangeEvent changeEvent) {
        this.dateOptions.setVisible(this.isDate.isSelected());
    }

    private void isTypeStateChanged(ChangeEvent changeEvent) {
        this.typeOptions.setVisible(this.isType.isSelected());
    }

    private void isSizeStateChanged(ChangeEvent changeEvent) {
        this.sizeOptions.setVisible(this.isSize.isSelected());
    }

    private void searchGoActionPerformed(ActionEvent actionEvent) {
        this.startSearching.execute((Object)this);
    }

    private void searchCancelActionPerformed(ActionEvent actionEvent) {
        this.stopSearching.execute((Object)this);
    }

    private void searchPatternKeyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.startSearching.execute((Object)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SizeMultiplier {
        Bytes(1L, "B"),
        Kilobytes(Bytes, "KB"),
        Megabytes(Kilobytes, "MB"),
        Gigabytes(Megabytes, "GB"),
        Terabytes(Gigabytes, "TB"),
        Petabytes(Terabytes, "PB");

        long size;
        String suffix;

        public long getSize() {
            return this.size;
        }

        public String getSuffix() {
            return this.suffix;
        }

        private SizeMultiplier(long l, String string2) {
            this.size = l;
            this.suffix = string2;
        }

        private SizeMultiplier(SizeMultiplier sizeMultiplier, String string2) {
            this.size = 1024L * sizeMultiplier.size;
            this.suffix = string2;
        }
    }
}

