/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.filemanager.ver3.browser;

import ddb.detach.MutableTabbableStatus;
import ddb.dsz.plugin.filemanager.ver3.browser.DirectoryListingColumns;
import ddb.targetmodel.filemodel.FileObject;
import ddb.targetmodel.filemodel.FileObjectFields;
import ddb.targetmodel.filemodel.FileSystemModel;
import ddb.util.AbstractEnumeratedTableModel;
import ddb.util.InsertionOrderedSet;
import ddb.util.UtilityConstants;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryListingModel2
extends AbstractEnumeratedTableModel<DirectoryListingColumns> {
    static ScheduledExecutorService exec = Executors.newScheduledThreadPool(1, UtilityConstants.createThreadFactory((String)"DirectoryListingModel"));
    static final long DELAY = 50L;
    static final TimeUnit UNIT = TimeUnit.MILLISECONDS;
    public static final Integer IS_DIR = -1;
    FileObject parentFile = null;
    List<FileObject> files = new ArrayList<FileObject>();
    DirectoryListingColumns currentSort = DirectoryListingColumns.Name;
    final MutableTabbableStatus status;
    int size = 0;
    private boolean invert = false;
    final Comparator<FileObject> INVERTABLE_COMPARATOR = new Comparator<FileObject>(){

        @Override
        public int compare(FileObject fileObject, FileObject fileObject2) {
            int n = DirectoryListingModel2.this.COLUMN_COMPARATOR.compare(fileObject, fileObject2);
            if (DirectoryListingModel2.this.invert) {
                return -n;
            }
            return n;
        }
    };
    final Comparator<FileObject> COLUMN_COMPARATOR = new Comparator<FileObject>(){

        @Override
        public int compare(FileObject fileObject, FileObject fileObject2) {
            if (fileObject != null && fileObject2 != null) {
                if (fileObject.isDirectory() && !fileObject2.isDirectory()) {
                    return -1;
                }
                if (!fileObject.isDirectory() && fileObject2.isDirectory()) {
                    return 1;
                }
            }
            return DirectoryListingModel2.this.currentSort.getComparator().compare(fileObject, fileObject2);
        }
    };
    final Comparator<FileObject> PRIME_COMPARATOR = this.INVERTABLE_COMPARATOR;
    private FileSystemModel model;
    private Long parentId = FileSystemModel.ROOT;
    private String path = null;
    private final ReadWriteLock LOCK = new ReentrantReadWriteLock();
    private final Lock READ = this.LOCK.readLock();
    private final Lock WRITE = this.LOCK.writeLock();
    private Collection<Long> updated = new InsertionOrderedSet<Long>(HashSet.class, LinkedList.class);
    private boolean parentChanged = false;
    private int pendingCount = 0;
    private boolean directoryRequested = false;
    private String details = "";
    final Set<FileObject> pendingFiles = new HashSet<FileObject>();
    private Runnable considerChangedParent = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DirectoryListingModel2.this.READ.lock();
            try {
                if (!DirectoryListingModel2.this.parentChanged) {
                    return;
                }
            }
            finally {
                DirectoryListingModel2.this.READ.unlock();
            }
            DirectoryListingModel2.this.WRITE.lock();
            try {
                for (FileObject fileObject : DirectoryListingModel2.this.files) {
                    fileObject.discard();
                }
                for (FileObject fileObject : DirectoryListingModel2.this.pendingFiles) {
                    fileObject.discard();
                }
                DirectoryListingModel2.this.pendingFiles.clear();
                DirectoryListingModel2.this.files.clear();
                DirectoryListingModel2.this.updated.clear();
                DirectoryListingModel2.this.size = 0;
                DirectoryListingModel2.this.parentChanged = false;
                DirectoryListingModel2.this.directoryRequested = true;
            }
            finally {
                DirectoryListingModel2.this.WRITE.unlock();
            }
            DirectoryListingModel2.this.setBusyMode();
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableDataChanged((AbstractEnumeratedTableModel)DirectoryListingModel2.this));
            DirectoryListingModel2.this.model.getChildren(DirectoryListingModel2.this.parentId, DirectoryListingModel2.this.path, (Closure)new GotChildren(DirectoryListingModel2.this.parentId));
        }
    };
    private Runnable considerUpdatedFiles = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DirectoryListingModel2.this.considerChangedParent.run();
            boolean bl = false;
            DirectoryListingModel2.this.READ.lock();
            try {
                if (!DirectoryListingModel2.this.updated.isEmpty()) {
                    bl = true;
                }
            }
            finally {
                DirectoryListingModel2.this.READ.unlock();
            }
            DirectoryListingModel2.this.setBusyMode();
            if (!bl) {
                return;
            }
            DirectoryListingModel2.this.WRITE.lock();
            try {
                Collection collection = DirectoryListingModel2.this.updated;
                DirectoryListingModel2.this.updated = new Vector();
                for (Long l : collection) {
                    final FileObject fileObject = new FileObject(DirectoryListingModel2.this.model, l.longValue());
                    DirectoryListingModel2.this.pendingFiles.add(fileObject);
                    DirectoryListingModel2.this.model.retrieveFileInformation(fileObject, new Runnable(){

                        public void run() {
                            DirectoryListingModel2.this.addFile(fileObject);
                        }
                    });
                }
            }
            finally {
                DirectoryListingModel2.this.WRITE.unlock();
            }
            DirectoryListingModel2.this.setBusyMode();
        }
    };

    public DirectoryListingModel2(FileSystemModel fileSystemModel, MutableTabbableStatus mutableTabbableStatus) {
        super(DirectoryListingColumns.class);
        this.model = fileSystemModel;
        this.status = mutableTabbableStatus;
        this.parentChanged = true;
        exec.scheduleWithFixedDelay(this.considerChangedParent, 1000L, 50L, TimeUnit.MILLISECONDS);
        exec.scheduleWithFixedDelay(this.considerUpdatedFiles, 1L, 1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSorting(DirectoryListingColumns directoryListingColumns, boolean bl) {
        this.WRITE.lock();
        try {
            this.currentSort = directoryListingColumns;
            this.invert = bl;
            Collections.sort(this.files, this.PRIME_COMPARATOR);
        }
        finally {
            this.WRITE.unlock();
        }
        EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableDataChanged((AbstractEnumeratedTableModel)this));
    }

    public int getRowCount() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFileObjectAt(int n) {
        this.READ.lock();
        try {
            if (n < 0 || n > this.files.size()) {
                Object var2_2 = null;
                return var2_2;
            }
            FileObject fileObject = this.files.get(n);
            return fileObject;
        }
        finally {
            this.READ.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, DirectoryListingColumns directoryListingColumns) {
        if (n < 0 || n > this.size) {
            return null;
        }
        FileObject fileObject = null;
        this.READ.lock();
        try {
            List<FileObject> list = this.files;
            if (n >= list.size()) {
                Object var5_5 = null;
                return var5_5;
            }
            fileObject = list.get(n);
        }
        finally {
            this.READ.unlock();
        }
        try {
            switch (directoryListingColumns) {
                case Name: {
                    return fileObject;
                }
                case Size: {
                    if (fileObject.isDrive()) {
                        return "<DRIVE>";
                    }
                    if (!fileObject.isDirectory()) break;
                    return "<DIR>";
                }
            }
            return fileObject.getDataElement(directoryListingColumns.getField()).getValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(FileSystemModel fileSystemModel) {
        this.WRITE.lock();
        try {
            if (this.model == fileSystemModel) {
                return;
            }
            this.model = fileSystemModel;
            this.parentChanged = true;
            this.parentId = FileSystemModel.ROOT;
            this.path = null;
            this.details = "";
        }
        finally {
            this.WRITE.unlock();
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(FileObject fileObject) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        this.WRITE.lock();
        try {
            int n4;
            this.pendingFiles.remove(fileObject);
            if (fileObject.getParent().intValue() != this.parentId.intValue()) {
                return;
            }
            fileObject.setPath(this.path);
            for (n4 = 0; n4 < this.files.size(); ++n4) {
                if (!this.files.get(n4).getId().equals(fileObject.getId())) continue;
                this.files.remove(n4);
                n3 = n4;
                --this.size;
                break;
            }
            if (n2 == -1) {
                n4 = Collections.binarySearch(this.files, fileObject, this.PRIME_COMPARATOR);
                if (n4 >= 0) {
                    n2 = n4;
                    this.files.set(n4, fileObject);
                } else {
                    int n5 = -n4 - 1;
                    this.files.add(n5, fileObject);
                    n = n5;
                    ++this.size;
                }
            }
        }
        finally {
            this.WRITE.unlock();
        }
        if (n3 >= 0) {
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsDeleted((AbstractEnumeratedTableModel)this, n3, n3));
        }
        if (n >= 0) {
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsInserted((AbstractEnumeratedTableModel)this, n, n));
        }
        if (n2 >= 0) {
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsUpdated((AbstractEnumeratedTableModel)this, n2, n2));
        }
    }

    public Class<?> getColumnClass(DirectoryListingColumns directoryListingColumns) {
        switch (directoryListingColumns) {
            case Accessed: 
            case Modified: 
            case Created: {
                return Calendar.class;
            }
            case Name: {
                return FileObject.class;
            }
            case Size: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    public void setParent(FileObject fileObject) {
        this.setParent(fileObject.getId(), fileObject.getPath(), fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParent(long l, String string, FileObject fileObject) {
        this.WRITE.lock();
        try {
            if (this.parentId.equals(l)) {
                return;
            }
            this.parentId = l;
            this.parentFile = fileObject;
            if (this.parentFile == null) {
                this.parentFile = new FileObject(this.model, l);
                if (string != null) {
                    int n = string.lastIndexOf(47);
                    if (n == string.length() - 1) {
                        string = string.substring(0, string.length() - 1);
                        n = string.lastIndexOf(47);
                    }
                    string = string + "/";
                    if (n != -1) {
                        this.parentFile.setPath(string.substring(0, n));
                        this.parentFile.setDataElement(FileObjectFields.File_Name, (Object)string.substring(n + 1));
                        this.parentFile.forceDirectory();
                    } else {
                        this.parentFile.setDataElement(FileObjectFields.File_Name, (Object)string.substring(n + 1));
                        this.parentFile.forceDirectory();
                    }
                    this.model.retrieveFileInformation(this.parentFile, null);
                }
            }
            this.path = string;
            this.parentChanged = true;
            this.details = "";
        }
        finally {
            this.WRITE.unlock();
        }
        this.setBusyMode();
    }

    public FileObject getParentFile() {
        return this.parentFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileChanged(FileObject fileObject) {
        long l = fileObject.getParent();
        this.READ.lock();
        try {
            if (l != this.parentId) {
                return;
            }
        }
        finally {
            this.READ.unlock();
        }
        this.WRITE.lock();
        try {
            long l2 = fileObject.getId();
            this.updated.add(l2);
        }
        finally {
            this.WRITE.unlock();
        }
        this.setBusyMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBusyMode() {
        boolean bl = false;
        this.READ.lock();
        try {
            if (this.pendingCount > 0 || this.updated.size() > 0 || this.directoryRequested) {
                bl = true;
            }
            if (this.status.isIndeterminate() == bl) {
                return;
            }
        }
        finally {
            this.READ.unlock();
        }
        this.status.setIndeterminate(bl);
        this.status.notifyObservers();
    }

    public String getDetails() {
        return this.details;
    }

    private class GotChildren
    implements Closure {
        Long parent;

        public GotChildren(Long l) {
            this.parent = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Object object) {
            Collection collection = (Collection)object;
            DirectoryListingModel2.this.WRITE.lock();
            try {
                if (DirectoryListingModel2.this.parentId != this.parent) {
                    return;
                }
                DirectoryListingModel2.this.updated.addAll(collection);
                DirectoryListingModel2.this.directoryRequested = false;
            }
            finally {
                DirectoryListingModel2.this.WRITE.unlock();
                DirectoryListingModel2.this.setBusyMode();
            }
        }
    }
}

