/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.filemanager.ver3.browser;

import ddb.bcb.BreadcrumbBar;
import ddb.bcb.BreadcrumbBarCallBack;
import ddb.bcb.BreadcrumbBarEvent;
import ddb.bcb.BreadcrumbBarListener;
import ddb.bcb.BreadcrumbItem;
import ddb.bcb.BreadcrumbItemChoices;
import ddb.detach.TabbableStatus;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.plugin.filemanager.ver3.FileManager;
import ddb.dsz.plugin.filemanager.ver3.FileManagerHost;
import ddb.dsz.plugin.filemanager.ver3.browser.DirectoryListingColumns;
import ddb.dsz.plugin.filemanager.ver3.browser.DirectoryListingModel2;
import ddb.dsz.plugin.filemanager.ver3.browser.SortingTableHeader;
import ddb.gui.swing.DszTableCellRenderer;
import ddb.targetmodel.TargetModel;
import ddb.targetmodel.TargetModelFactory;
import ddb.targetmodel.filemodel.DriveType;
import ddb.targetmodel.filemodel.FileObject;
import ddb.targetmodel.filemodel.FileSystemModel;
import ddb.util.tablefilter.sample.ColumnHidingModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Browser
extends FileManagerHost
implements BreadcrumbBarCallBack,
BreadcrumbBarListener {
    public static final int MAX_LENGTH = 100;
    BreadcrumbBar navigator = new BreadcrumbBar(">", (BreadcrumbBarCallBack)this);
    JTable files = new JTable();
    DirectoryListingModel2 directoryModel = null;
    ColumnHidingModel columnModel = new ColumnHidingModel(DirectoryListingColumns.class);
    SortingTableHeader sorter;
    FileObject root = null;
    JPanel browseDisplay;
    JButton rootButton = new JButton("");
    final Object LOCK = new Object();

    public Browser(HostInfo hostInfo, CoreController coreController, FileManager fileManager, long l) {
        super(hostInfo, coreController, fileManager);
        super.setName(hostInfo.getId());
        super.setShowButtons(false);
        this.files.setColumnModel((TableColumnModel)this.columnModel);
        this.columnModel.applyToTable(this.files);
        this.browseDisplay = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.add(this.rootButton);
        jToolBar.add((Component)this.navigator);
        jToolBar.setFloatable(false);
        this.rootButton.setIcon(Browser.getIcon(DriveType.FILEMANAGER.getIcon()));
        this.rootButton.setToolTipText("File System Root");
        this.rootButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Browser.this.setNavigation(FileSystemModel.ROOT);
                if (Browser.this.directoryModel != null) {
                    Browser.this.directoryModel.setParent(FileSystemModel.ROOT, null, null);
                }
            }
        });
        this.browseDisplay.add((Component)jToolBar, "North");
        JScrollPane jScrollPane = new JScrollPane(this.files);
        this.browseDisplay.add(jScrollPane);
        super.setDisplay((JComponent)this.browseDisplay);
        this.files.setDefaultRenderer(Calendar.class, (TableCellRenderer)new DszTableCellRenderer(){
            SimpleDateFormat FullFormat = new SimpleDateFormat("M/d/yyyy h:mm:ss a");
            SimpleDateFormat ShortFormat = new SimpleDateFormat("h:mm:ss a");

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JLabel && object instanceof Calendar) {
                    Calendar calendar = (Calendar)object;
                    JLabel jLabel = (JLabel)component;
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.add(5, -1);
                    if (calendar.compareTo(calendar2) < 0) {
                        jLabel.setText(this.FullFormat.format(calendar.getTime()));
                    } else {
                        jLabel.setText(this.ShortFormat.format(calendar.getTime()));
                    }
                }
                return component;
            }
        });
        this.files.setDefaultRenderer(Integer.class, (TableCellRenderer)new DszTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JLabel && object instanceof Number) {
                    Number number = (Number)object;
                    JLabel jLabel = (JLabel)component;
                    if (number.equals(DirectoryListingModel2.IS_DIR)) {
                        jLabel.setText("<DIR>");
                    }
                }
                return component;
            }
        });
        this.files.setDefaultRenderer(FileObject.class, (TableCellRenderer)new DszTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JLabel && object instanceof FileObject) {
                    JLabel jLabel = (JLabel)component;
                    FileObject fileObject = (FileObject)object;
                    jLabel.setIcon(FileManagerHost.getIcon(fileObject.getIcon()));
                    jLabel.setText(fileObject.getName());
                }
                return component;
            }
        });
        this.files.setSelectionMode(2);
        this.files.addMouseListener(new MouseAdapter(){

            private boolean maybePopup(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    return false;
                }
                mouseEvent.consume();
                int n = mouseEvent.getY() / Browser.this.files.getRowHeight();
                if (!Browser.this.files.getSelectionModel().isSelectedIndex(n)) {
                    if (n < Browser.this.files.getRowCount()) {
                        Browser.this.files.getSelectionModel().setSelectionInterval(n, n);
                    } else {
                        return false;
                    }
                }
                ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                for (int n2 : Browser.this.files.getSelectedRows()) {
                    Object object = Browser.this.directoryModel.getFileObjectAt(n2);
                    if (object instanceof FileObject) {
                        arrayList.add((FileObject)FileObject.class.cast(object));
                        continue;
                    }
                    if (!(object instanceof Integer)) continue;
                    arrayList2.add((Integer)Integer.class.cast(object));
                }
                Browser.this.showPopup(mouseEvent, arrayList, arrayList2);
                return true;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                FileObject fileObject;
                int n;
                if (this.maybePopup(mouseEvent)) {
                    return;
                }
                if (mouseEvent.getClickCount() == 2 && (n = mouseEvent.getY() / Browser.this.files.getRowHeight()) < Browser.this.files.getRowCount() && (fileObject = (FileObject)Browser.this.directoryModel.getValueAt(n, DirectoryListingColumns.Name)) != null && fileObject.isDirectory()) {
                    BreadcrumbItem breadcrumbItem = Browser.this.makeBreadcrumb(fileObject);
                    Browser.this.navigator.pushChoice(breadcrumbItem);
                    BreadcrumbItemChoices breadcrumbItemChoices = new BreadcrumbItemChoices(new BreadcrumbItem[0]);
                    Browser.this.navigator.pushChoices(breadcrumbItemChoices, true);
                    exec.execute(new AdjustChoices(breadcrumbItemChoices, fileObject.getId(), FileManagerHost.makePath(fileObject)));
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }
        });
        jScrollPane.addMouseListener(new MouseAdapter(){

            private boolean maybePopup(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    return false;
                }
                mouseEvent.consume();
                FileObject fileObject = Browser.this.directoryModel.getParentFile();
                Browser.this.showPopup(mouseEvent, fileObject);
                return true;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (this.maybePopup(mouseEvent)) {
                    return;
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }
        });
        this.sorter = new SortingTableHeader(new SortingTableHeader.SortingTableHeaderCallback(){

            public void setSorting(TableColumn tableColumn, boolean bl) {
                if (tableColumn == null) {
                    Browser.this.directoryModel.setSorting(DirectoryListingColumns.Name, true);
                }
                if (Browser.this.directoryModel != null) {
                    DirectoryListingColumns directoryListingColumns = null;
                    for (DirectoryListingColumns directoryListingColumns2 : DirectoryListingColumns.values()) {
                        if (!directoryListingColumns2.text.equals(tableColumn.getHeaderValue().toString())) continue;
                        directoryListingColumns = directoryListingColumns2;
                        break;
                    }
                    Browser.this.directoryModel.setSorting(directoryListingColumns, bl);
                }
            }
        });
        this.sorter.addMouseListenerToHeaderInTable(this.files);
        TargetModel targetModel = TargetModelFactory.getTargetModel((CoreController)coreController, (HostInfo)hostInfo);
        if (targetModel == null) {
            coreController.logEvent(Level.SEVERE, "Unable to get TargetModel");
            return;
        }
        FileSystemModel fileSystemModel = targetModel.getFileSystemModel();
        if (fileSystemModel == null) {
            coreController.logEvent(Level.SEVERE, "Unable to get FileSystemModel");
            return;
        }
        this.setFileSystemModel(fileSystemModel);
        this.navigator.addListener((BreadcrumbBarListener)this);
        this.setNavigation(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String setNavigation(long l) {
        String string = null;
        BreadcrumbItemChoices breadcrumbItemChoices = new BreadcrumbItemChoices(new BreadcrumbItem[0]);
        try {
            FileObject fileObject;
            if (l == FileSystemModel.ROOT) {
                this.navigator.getStack().clear();
                this.navigator.pushChoices(breadcrumbItemChoices);
            } else {
                fileObject = this.model.getFile(l, null);
                if (fileObject == null) {
                    String string2 = null;
                    exec.execute(new AdjustChoices(breadcrumbItemChoices, l, string));
                    return string2;
                }
                string = this.setNavigation(Long.valueOf(fileObject.getParent()).intValue());
                fileObject.setPath(string);
                string = Browser.makePath(fileObject);
                BreadcrumbItem breadcrumbItem = this.makeBreadcrumb(fileObject);
                this.navigator.pushChoice(breadcrumbItem);
                this.navigator.pushChoices(breadcrumbItemChoices);
            }
            fileObject = string;
            exec.execute(new AdjustChoices(breadcrumbItemChoices, l, string));
            return fileObject;
        }
        catch (Throwable throwable) {
            exec.execute(new AdjustChoices(breadcrumbItemChoices, l, string));
            throw throwable;
        }
    }

    protected BreadcrumbItem makeBreadcrumb(FileObject fileObject) {
        BreadcrumbItem breadcrumbItem = new BreadcrumbItem(new String[]{fileObject.getName(), fileObject.getId().toString(), fileObject.getPath()});
        breadcrumbItem.setIcon(Browser.getIcon(fileObject.getIcon()));
        return breadcrumbItem;
    }

    @Override
    protected void setFileSystemModel(FileSystemModel fileSystemModel) {
        super.setFileSystemModel(fileSystemModel);
        this.directoryModel.setModel(fileSystemModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void modelChanged() {
        if (this.model == null) {
            return;
        }
        BreadcrumbItemChoices breadcrumbItemChoices = new BreadcrumbItemChoices(new BreadcrumbItem[0]);
        Object object = this.LOCK;
        synchronized (object) {
            this.navigator.getStack().clear();
            this.directoryModel = new DirectoryListingModel2(this.model, this.status);
            this.sorter.setNoSort();
            this.files.setModel((TableModel)((Object)this.directoryModel));
            for (DirectoryListingColumns directoryListingColumns : DirectoryListingColumns.values()) {
                if (!directoryListingColumns.isShow()) {
                    this.columnModel.hide((Enum)directoryListingColumns);
                    continue;
                }
                this.columnModel.show((Enum)directoryListingColumns);
            }
            this.root = this.model.getFile(FileSystemModel.ROOT.longValue(), null);
            if (this.root == null) {
                return;
            }
            this.navigator.getStack().clear();
            this.navigator.pushChoices(breadcrumbItemChoices);
        }
        exec.execute(new AdjustChoices(breadcrumbItemChoices, FileSystemModel.ROOT, null));
    }

    public BreadcrumbItemChoices getChoices(BreadcrumbItem[] breadcrumbItemArray) {
        BreadcrumbItemChoices breadcrumbItemChoices = new BreadcrumbItemChoices(new BreadcrumbItem[0]);
        try {
            exec.execute(new AdjustChoices(breadcrumbItemChoices, Integer.parseInt(breadcrumbItemArray[breadcrumbItemArray.length - 1].getValue()[1]), Browser.makePath(breadcrumbItemArray[breadcrumbItemArray.length - 1].getValue()[2], breadcrumbItemArray[breadcrumbItemArray.length - 1].getValue()[0])));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return breadcrumbItemChoices;
    }

    @Override
    public void fileChanged(FileObject fileObject) {
        if (fileObject == null) {
            return;
        }
        this.directoryModel.fileChanged(fileObject);
        if (!fileObject.isDirectory()) {
            return;
        }
        long l = fileObject.getParent();
        if (l == -1L) {
            return;
        }
        if (l == Long.valueOf(FileSystemModel.ROOT)) {
            BreadcrumbItemChoices breadcrumbItemChoices = new BreadcrumbItemChoices(new BreadcrumbItem[0]);
            EventQueue.invokeLater(new SetNavigatorChoices(0, breadcrumbItemChoices, true));
            exec.execute(new AdjustChoices(breadcrumbItemChoices, FileSystemModel.ROOT, null));
        }
        for (int i = 1; i < this.navigator.getStack().size() - 1; i += 2) {
            try {
                Object object = this.navigator.getStack().get(i);
                Object object2 = this.navigator.getStack().get(i + 1);
                String string = ((BreadcrumbItem)BreadcrumbItem.class.cast(object)).getValue()[1];
                Long l2 = Long.parseLong(string);
                if (!l2.equals(l)) continue;
                if (!(object2 instanceof BreadcrumbItemChoices)) break;
                exec.execute(new AddChoice((BreadcrumbItemChoices)object2, fileObject));
                break;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void breadcrumbBarEvent(BreadcrumbBarEvent breadcrumbBarEvent) {
        BreadcrumbItem[] breadcrumbItemArray = (BreadcrumbItem[])breadcrumbBarEvent.getNewValue();
        if (breadcrumbItemArray.length == 0) {
            return;
        }
        BreadcrumbItem breadcrumbItem = breadcrumbItemArray[breadcrumbItemArray.length - 1];
        Integer n = Integer.parseInt(breadcrumbItem.getValue()[1]);
        if (this.directoryModel != null) {
            this.directoryModel.setParent(n.intValue(), Browser.makePath(breadcrumbItem.getValue()[2], breadcrumbItem.getValue()[0]), null);
        }
    }

    @Override
    public List<String> getAdditionalOptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/FileBrowser/BrowseContextMenu.xml");
        return arrayList;
    }

    public TabbableStatus getStatus() {
        return this.model.getTabbableStatus();
    }

    private class AddChoice
    implements Runnable {
        BreadcrumbItemChoices choices;
        FileObject fo;

        public AddChoice(BreadcrumbItemChoices breadcrumbItemChoices, FileObject fileObject) {
            this.choices = breadcrumbItemChoices;
            this.fo = fileObject;
        }

        public void run() {
            if (this.choices.getChoices().length > 100) {
                return;
            }
            for (BreadcrumbItem breadcrumbItem : this.choices.getChoices()) {
                if (!breadcrumbItem.getValue()[1].equals(this.fo.getId().toString())) continue;
                breadcrumbItem.setIcon(FileManagerHost.getIcon(this.fo.getIcon()));
                breadcrumbItem.setName(this.fo.getName());
                return;
            }
            BreadcrumbItem breadcrumbItem = Browser.this.makeBreadcrumb(this.fo);
            this.choices.addItem(breadcrumbItem);
        }
    }

    private class AdjustChoices
    implements Runnable {
        BreadcrumbItemChoices choices;
        long parent;
        String path;

        public AdjustChoices(BreadcrumbItemChoices breadcrumbItemChoices, long l, String string) {
            this.choices = breadcrumbItemChoices;
            this.parent = l;
            this.path = string;
        }

        public void run() {
            if (this.choices.getChoices().length > 100) {
                return;
            }
            List list = Browser.this.model.getSubdirectories(Long.valueOf(this.parent), this.path);
            for (FileObject fileObject : list) {
                if (this.choices.getChoices().length > 100) {
                    return;
                }
                if (!fileObject.isDirectory()) continue;
                BreadcrumbItem breadcrumbItem = Browser.this.makeBreadcrumb(fileObject);
                this.choices.addItem(breadcrumbItem);
            }
        }
    }

    private class SetNavigatorChoices
    implements Runnable {
        int index;
        BreadcrumbItemChoices choices;
        boolean updateUI;

        public SetNavigatorChoices(int n, BreadcrumbItemChoices breadcrumbItemChoices, boolean bl) {
            this.index = n;
            this.choices = breadcrumbItemChoices;
            this.updateUI = bl;
        }

        public void run() {
            Browser.this.navigator.setChoices(this.index, this.choices, this.updateUI);
        }
    }
}

