/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.multitarget;

import ddb.detach.AbstractTabbable;
import ddb.detach.Tabbable;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.multitarget.SingleTargetInterface;
import java.util.Comparator;
import javax.swing.JComponent;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleTargetImpl
extends AbstractTabbable
implements SingleTargetInterface {
    protected HostInfo target;
    protected CoreController core;
    protected JComponent display = null;

    public SingleTargetImpl(HostInfo hostInfo, CoreController coreController) {
        this.target = hostInfo;
        this.core = coreController;
        if (hostInfo != null) {
            this.setName(hostInfo.getId());
        }
    }

    protected JComponent getTabbableSpecificRenderComponent() {
        return null;
    }

    @Override
    public void setDisplay(JComponent jComponent) {
        this.display = jComponent;
    }

    public final JComponent getDisplay() {
        return this.display;
    }

    @Override
    public HostInfo getTarget() {
        return this.target;
    }

    public int compareTo(Tabbable tabbable) {
        if (tabbable instanceof SingleTargetInterface) {
            return this.compareTo((SingleTargetInterface)SingleTargetInterface.class.cast(tabbable));
        }
        return super.compareTo(tabbable);
    }

    @Override
    public int compareTo(SingleTargetInterface singleTargetInterface) {
        if (singleTargetInterface == null) {
            return -1;
        }
        return HostInfo.COMPARE.compare(this.target, singleTargetInterface.getTarget());
    }

    @Override
    public final void fini() {
        this.fini2();
    }

    public void fini2() {
    }

    public boolean allowNewInstance(Class<?> clazz) {
        return false;
    }

    public boolean isHideable() {
        return true;
    }

    public boolean isClosable() {
        return false;
    }

    public boolean isUnhideable() {
        return true;
    }

    public boolean isDetachable() {
        return true;
    }

    public JComponent getDefaultElement() {
        return null;
    }

    @Override
    public void commandEventReceived(CommandEvent commandEvent) {
    }

    @Override
    public boolean handlesPromptsForTask(Task task, int n) {
        return false;
    }

    @Override
    public boolean caresAboutLocalEvents() {
        return this.target != null && this.target.isLocal();
    }

    @Override
    public boolean caresAboutRepeatedEvents() {
        return false;
    }

    @Override
    public Comparator<CommandEvent> getComparator() {
        return null;
    }

    public String getDetachedTitle() {
        String string = super.getDetachedTitle();
        String string2 = this.core.getTitle();
        if (this.target != null) {
            string = String.format("%s - %s", string, this.target.getId());
        }
        if (string2 != null) {
            string = String.format("%s [%s]", string, string2);
        }
        return string;
    }

    protected Predicate getDataPredicate() {
        return new Predicate(){

            public boolean evaluate(Object object) {
                if (!(object instanceof DataEvent)) {
                    return false;
                }
                DataEvent dataEvent = (DataEvent)object;
                if (!DataEvent.DataEventType.DATA.equals((Object)dataEvent.getDataType())) {
                    return false;
                }
                TaskId taskId = dataEvent.getTaskId();
                if (taskId == null) {
                    return false;
                }
                Task task = SingleTargetImpl.this.core.getTaskById(taskId);
                if (task == null) {
                    return false;
                }
                return task.getHost().sameHost(SingleTargetImpl.this.target);
            }
        };
    }
}

