/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.core.task;

import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.Task;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskId
implements Comparable<TaskId> {
    public static final Comparator<TaskId> TaskIdComparator = new Comparator<TaskId>(){

        @Override
        public int compare(TaskId taskId, TaskId taskId2) {
            if (taskId == taskId2) {
                return 0;
            }
            if (taskId == null && taskId2 != null) {
                return -1;
            }
            if (taskId2 == null && taskId != null) {
                return 1;
            }
            if (taskId.getOperation() == null && taskId2.getOperation() != null) {
                return -1;
            }
            if (taskId.getOperation() != null && taskId2.getOperation() == null) {
                return 1;
            }
            int n = taskId.getOperation().compareTo(taskId2.getOperation());
            if (n != 0) {
                return n;
            }
            return taskId.getId() - taskId2.getId();
        }
    };
    private static final List<TaskId> CREATED_IDS = new ArrayList<TaskId>();
    public static final TaskId NULL = new TaskId(0, null);
    public static final TaskId GLOBAL = new TaskId(-1, null);
    public static final TaskId UNINITIALIZED_ID = new TaskId(-2, null);
    private static final TaskId[] ListOfKnownIds = new TaskId[]{NULL, GLOBAL, UNINITIALIZED_ID};
    private final int id;
    private final Operation operation;
    private Task task = null;

    public static final synchronized TaskId GenerateTaskId(int n, Operation operation) {
        for (TaskId taskId : ListOfKnownIds) {
            if (n != taskId.id) continue;
            return taskId;
        }
        TaskId taskId = new TaskId(n, operation);
        int n2 = Collections.binarySearch(CREATED_IDS, taskId, TaskIdComparator);
        if (n2 >= 0) {
            return CREATED_IDS.get(n2);
        }
        ++n2;
        if ((n2 = -n2) >= CREATED_IDS.size()) {
            CREATED_IDS.add(taskId);
        } else {
            CREATED_IDS.add(n2, taskId);
        }
        return taskId;
    }

    private TaskId(int n, Operation operation) {
        this.id = n;
        this.operation = operation;
    }

    public final void setTask(Task task) {
        this.task = task;
    }

    public final Task getTask() {
        return this.task;
    }

    public final int getId() {
        return this.id;
    }

    @Override
    public int compareTo(TaskId taskId) {
        return TaskIdComparator.compare(this, taskId);
    }

    public String toString() {
        return String.format("%d", this.id);
    }

    public final boolean isValid() {
        return this.id > 0;
    }

    public final boolean idMatch(int n) {
        return this.id == n;
    }

    public final Operation getOperation() {
        return this.operation;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.id;
        n = 31 * n + (this.operation == null ? 0 : this.operation.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TaskId taskId = (TaskId)object;
        if (this.id != taskId.id) {
            return false;
        }
        return !(this.operation == null ? taskId.operation != null : !this.operation.equals(taskId.operation));
    }
}

