/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.core.host;

import ddb.dsz.core.task.TaskId;
import java.util.Calendar;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface HostInfo
extends Comparable<HostInfo> {
    public static final Comparator<HostInfo> COMPARE = new Comparator<HostInfo>(){
        Pattern CP_ID_PATTERN = Pattern.compile("z(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)");

        @Override
        public int compare(HostInfo hostInfo, HostInfo hostInfo2) {
            if (hostInfo == hostInfo2) {
                return 0;
            }
            if (hostInfo == null) {
                return -1;
            }
            if (hostInfo2 == null) {
                return 1;
            }
            if (hostInfo.isLocal() && !hostInfo2.isLocal()) {
                return -1;
            }
            if (!hostInfo.isLocal() && hostInfo2.isLocal()) {
                return 1;
            }
            Matcher matcher = this.CP_ID_PATTERN.matcher(hostInfo.getId());
            Matcher matcher2 = this.CP_ID_PATTERN.matcher(hostInfo2.getId());
            if (matcher.matches() && matcher2.matches() && matcher.groupCount() == matcher2.groupCount()) {
                for (int i = 1; i < matcher.groupCount() + 1; ++i) {
                    try {
                        int n = Integer.parseInt(matcher.group(i));
                        int n2 = Integer.parseInt(matcher2.group(i));
                        if (n < n2) {
                            return -1;
                        }
                        if (n <= n2) continue;
                        return 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                }
                return 0;
            }
            return 0;
        }
    };
    public static final String LOCAL_HOST = "127.0.0.1";

    public void copyFromHost(HostInfo var1);

    public String getArch();

    public String getId();

    public String getImplantType();

    public Calendar getModifiedTime();

    public String getPlatform();

    public TaskId getTask();

    public String getVersion();

    public boolean isConnected();

    public boolean isLocal();

    public boolean sameHost(HostInfo var1);

    public void setTask(TaskId var1);

    public String getHostname();
}

