/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.core.controller;

import ddb.detach.Alignment;
import ddb.dsz.core.command.CommandEventListener;
import ddb.dsz.core.command.IdCallback;
import ddb.dsz.core.connection.ConnectionChangeListener;
import ddb.dsz.core.controller.CommandSet;
import ddb.dsz.core.controller.DispatcherException;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.internalcommand.InternalCommandCallback;
import ddb.dsz.core.internalcommand.InternalCommandHandler;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.Plugin;
import ddb.dsz.plugin.peer.PeerReceiver;
import ddb.dsz.plugin.peer.PeerTag;
import ddb.dsz.plugin.peer.PeerTransferStatus;
import ddb.util.Guid;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CoreController
extends Executor,
ThreadFactory {
    public void startCommand(String var1, IdCallback var2, Object var3, HostInfo var4) throws DispatcherException;

    public void requestHelpStatement(String var1, HostInfo var2) throws DispatcherException;

    public void killCommand(Task var1) throws DispatcherException;

    public void interruptCommand(Task var1) throws DispatcherException;

    public void stopCommandOutput(Task var1) throws DispatcherException;

    public void restartCommandOutput(Task var1) throws DispatcherException;

    public void addPrefixesToTask(TaskId var1, List<String> var2) throws DispatcherException;

    public void sendPromptReply(int var1, TaskId var2, String var3) throws DispatcherException;

    public Task getRunningTaskById(TaskId var1);

    public Task getTaskById(TaskId var1);

    public Task getTaskByTaskId(Guid var1);

    public String getLogDirectory();

    public String getResourceDirectory();

    public String[] getResourcePackages();

    public String getBuildType();

    public String getUserConfigDirectory();

    public File createLogFile(String var1);

    public boolean isDebugMode();

    public boolean isLiveOperation();

    public CommandSet getCommandSet();

    public Collection<Task> getTaskList();

    public Logger getSystemLogger();

    public void addCommandEventListener(CommandEventListener var1);

    public void removeCommandEventListener(CommandEventListener var1);

    public void unhidePlugin(Plugin var1);

    public void hidePlugin(Plugin var1);

    public boolean allowNewInstance(Class<?> var1);

    public boolean startNewPlugin(Class<?> var1, String var2, List<String> var3, boolean var4, boolean var5);

    public boolean startNewPlugin(Class<?> var1, String var2, List<String> var3, boolean var4, boolean var5, Alignment var6);

    public void closePlugin(Plugin var1);

    public void addInternalCommandHandler(InternalCommandHandler var1);

    public void removeInternalCommandHandler(InternalCommandHandler var1);

    public boolean internalCommand(InternalCommandCallback var1, List<String> var2);

    public boolean internalCommand(InternalCommandCallback var1, String ... var2);

    public void addConnectionChangeListener(ConnectionChangeListener var1);

    public void removeConnectionChangeListener(ConnectionChangeListener var1);

    public void logEvent(Level var1, String var2);

    public void logEvent(Level var1, String var2, String var3);

    public void logEvent(Level var1, String var2, Throwable var3);

    public void logEvent(Level var1, String var2, String var3, Throwable var4);

    public void pluginStarted(Plugin var1);

    public void pluginStopped(Plugin var1);

    public void setOption(Class<? extends Plugin> var1, String var2, Object var3);

    public void setOption(Plugin var1, String var2, Object var3);

    public Object getOption(Class<? extends Plugin> var1, String var2);

    public Object getOption(Plugin var1, String var2);

    public Object getOption(Class<? extends Plugin> var1, String var2, Object var3);

    public Object getOption(Plugin var1, String var2, Object var3);

    public void setObject(Class<? extends Plugin> var1, String var2, Serializable var3);

    public void setObject(Plugin var1, String var2, Serializable var3);

    public <E extends Serializable> E getObject(Class<? extends Plugin> var1, String var2, Class<? extends E> var3);

    public <E extends Serializable> E getObject(Plugin var1, String var2, Class<? extends E> var3);

    public void commitSettings();

    public <V> ScheduledFuture<V> schedule(Callable<V> var1, long var2, TimeUnit var4);

    public ScheduledFuture<?> schedule(Runnable var1, long var2, TimeUnit var4);

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable var1, long var2, long var4, TimeUnit var6);

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable var1, long var2, long var4, TimeUnit var6);

    public <T> Future<T> submit(Callable<T> var1);

    public <T> Future<T> submit(Runnable var1, T var2);

    public Future<?> submit(Runnable var1);

    public boolean remove(Runnable var1);

    public boolean isLocalMode();

    public Operation getOperation();

    public void setupKeyBindings(JComponent var1);

    public Map<KeyStroke, String> getKeyBindings();

    public void showPrompt(Task var1, int var2, String var3);

    public int requestStatistics();

    public String getDefaultPackage();

    public void StealFocus(Plugin var1);

    public boolean hasConnected();

    public void addPeerReceiver(PeerReceiver var1);

    public void removePeerReceiver(PeerReceiver var1);

    public PeerTransferStatus sendMessageToPeer(String var1);

    public PeerTransferStatus sendMessageToPeer(String var1, PeerTag var2);

    public HostInfo getHostById(String var1);

    public List<HostInfo> getHosts();

    public String getOpDir();

    public int getDispatcherPort();

    public String getLocalhostAddress();

    public String claimPrompt(Task var1);

    public OperationState getOperationState();

    public String getTitle();

    public Collection<Operation> getOperationList();

    public Operation getOperationById(Guid var1);

    public Operation getOperationById(BigInteger var1);

    public void detachPlugin(Plugin var1, Dimension var2, Point var3);

    public void sendGuiCommandResponse(int var1, boolean var2);

    public boolean isFullStop();

    public Thread newThread(String var1, Runnable var2);

    public String translate(String var1);

    public List<TaskId> getTaskChildren(TaskId var1);

    public Dimension getLabelImageSize();

    public Dimension getTabImageSize();

    public void setCommandEnvironmentVariable(String var1, String var2);

    public void setCommandEnvironmentVariable(String var1, String var2, HostInfo var3);

    public List<String> getUserAliases(HostInfo var1);

    public void setTitle(String var1);

    public void requestShutdown();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperationState {
        NotConnected,
        Connected,
        Inactive;

    }
}

