/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.core.controller;

import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandInfo
implements Comparable<CommandInfo> {
    protected String name;
    protected CommandInfoEnum type;
    protected String expansion;
    protected List<String> options;
    protected String optionPrefix;

    public CommandInfo(String string, CommandInfoEnum commandInfoEnum) {
        if (commandInfoEnum.equals((Object)CommandInfoEnum.ALIAS)) {
            throw new IllegalArgumentException("Use CommandInfo(String,String) to create aliases");
        }
        this.name = string;
        this.type = commandInfoEnum;
        this.expansion = null;
        this.options = new Vector<String>();
    }

    public CommandInfo(String string, String string2) {
        this.name = string;
        this.type = CommandInfoEnum.ALIAS;
        this.expansion = string2.length() > 0 ? string2 : null;
        this.options = new Vector<String>();
    }

    public CommandInfoEnum getType() {
        return this.type;
    }

    public boolean isCommand() {
        return this.type.equals((Object)CommandInfoEnum.COMMAND);
    }

    public boolean isPrefix() {
        return this.type.equals((Object)CommandInfoEnum.PREFIX) || this.type.equals((Object)CommandInfoEnum.ALIASPREFIX);
    }

    public boolean isAlias() {
        return this.type.equals((Object)CommandInfoEnum.ALIAS);
    }

    public boolean isOrContainsCommand() {
        if (this.isPrefix()) {
            return false;
        }
        if (this.isCommand()) {
            return true;
        }
        return this.isAlias() && this.expansion != null;
    }

    public String getExpansionCommand() {
        return this.expansion;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String getOptionPrefix() {
        return this.optionPrefix;
    }

    public void setOptionPrefix(String string) {
        this.optionPrefix = string;
    }

    public void addOption(String string) {
        this.options.add(string);
    }

    public String debugToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("name: " + this.name + "\n");
        stringBuffer.append("type: " + (Object)((Object)this.type) + "\n");
        stringBuffer.append("expansion: " + this.expansion);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(CommandInfo commandInfo) {
        return this.name.compareTo(commandInfo.getName());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CommandInfo commandInfo = (CommandInfo)object;
        if (this.name == null ? commandInfo.name != null : !this.name.equals(commandInfo.name)) {
            return false;
        }
        return !(this.type == null ? commandInfo.type != null : !this.type.equals((Object)commandInfo.type));
    }

    public void setCommandType(CommandInfoEnum commandInfoEnum) {
        this.type = commandInfoEnum;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommandInfoEnum {
        COMMAND,
        PREFIX,
        ALIAS,
        ALIASPREFIX;

    }
}

