/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.monitor;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.task.Task;
import ddb.dsz.plugin.monitor.MonitorHost;
import ddb.dsz.plugin.monitor.MonitorTarget;
import ddb.dsz.plugin.monitor.MonitorTask;
import java.awt.EventQueue;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class MonitorTree
implements TreeModel {
    EventListenerList listeners = new EventListenerList();
    MonitorHost monitor;
    CoreController core;
    List<MonitorTarget> root = new Vector<MonitorTarget>();
    Method inserted;
    Method changed;
    Method removed;
    Method structureChanged;

    public MonitorTree(MonitorHost monitorHost, CoreController coreController) {
        this.monitor = monitorHost;
        this.core = coreController;
        Class<TreeModelListener> clazz = TreeModelListener.class;
        try {
            this.inserted = clazz.getMethod("treeNodesInserted", TreeModelEvent.class);
            this.changed = clazz.getMethod("treeNodesChanged", TreeModelEvent.class);
            this.removed = clazz.getMethod("treeNodesRemoved", TreeModelEvent.class);
            this.structureChanged = clazz.getMethod("treeStructureChanged", TreeModelEvent.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object object, int n) {
        if (object == this.root) {
            return this.root.get(n);
        }
        if (object instanceof MonitorTarget) {
            return ((MonitorTarget)MonitorTarget.class.cast((Object)object)).tasks.get(n);
        }
        return null;
    }

    public int getChildCount(Object object) {
        if (object == this.root) {
            return this.root.size();
        }
        if (object instanceof MonitorTarget) {
            return ((MonitorTarget)MonitorTarget.class.cast((Object)object)).tasks.size();
        }
        return 0;
    }

    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        System.out.println("Value changed");
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object == this.root) {
            return this.root.indexOf(object2);
        }
        if (object instanceof MonitorTarget) {
            return ((MonitorTarget)MonitorTarget.class.cast((Object)object)).tasks.indexOf(object2);
        }
        return -1;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(TreeModelListener.class, treeModelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTarget(String string) {
        if (string == null) {
            return;
        }
        MonitorTarget monitorTarget = new MonitorTarget();
        monitorTarget.id = string;
        MonitorTree monitorTree = this;
        synchronized (monitorTree) {
            int n = this.root.size();
            this.root.add(monitorTarget);
        }
        this.fireNodeInserted(new TreeModelEvent((Object)this, new Object[]{this.root, monitorTarget}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitoredTask(Task task) {
        if (task == null) {
            return;
        }
        MonitorTask monitorTask = new MonitorTask();
        MonitorTarget monitorTarget = null;
        monitorTask.task = task;
        MonitorTree monitorTree = this;
        synchronized (monitorTree) {
            for (MonitorTarget monitorTarget2 : this.root) {
                if (!monitorTarget2.id.equalsIgnoreCase(task.getHost().getId())) continue;
                monitorTarget = monitorTarget2;
                break;
            }
        }
        if (monitorTarget == null) {
            this.addTarget(task.getHost().getId());
            this.addMonitoredTask(task);
            return;
        }
        int n = monitorTarget.tasks.size();
        monitorTask.parent = monitorTarget;
        monitorTarget.tasks.add(monitorTask);
        this.fireNodeInserted(new TreeModelEvent((Object)this, new Object[]{this.root, monitorTarget, monitorTask}));
    }

    protected void fireNodeInserted(TreeModelEvent treeModelEvent) {
        this.fire(this.inserted, treeModelEvent);
    }

    protected void fireNodeChanged(TreeModelEvent treeModelEvent) {
        this.fire(this.changed, treeModelEvent);
    }

    protected void fireNodeRemoved(TreeModelEvent treeModelEvent) {
        this.fire(this.removed, treeModelEvent);
    }

    protected void fireStructureChanged(TreeModelEvent treeModelEvent) {
        this.fire(this.structureChanged, treeModelEvent);
    }

    protected final void fire(final Method method, final TreeModelEvent treeModelEvent) {
        TreeModelListener[] treeModelListenerArray;
        if (method == null) {
            return;
        }
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MonitorTree.this.fire(method, treeModelEvent);
                }
            });
        }
        for (TreeModelListener treeModelListener : treeModelListenerArray = (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class)) {
            try {
                method.invoke((Object)treeModelListener, treeModelEvent);
            }
            catch (Exception exception) {
                Logger.getLogger("dsz").log(Level.SEVERE, null, exception);
                exception.printStackTrace();
            }
        }
    }
}

