/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.connectioninfo;

import ddb.delegate.UpdateLabel;
import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.annotations.DszUserStartable;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.connection.ConnectionChangeEvent;
import ddb.dsz.core.connection.ConnectionChangeListener;
import ddb.dsz.core.connection.events.DisconnectEvent;
import ddb.dsz.core.connection.events.NewHostEvent;
import ddb.dsz.core.connection.events.StatisticsEvent;
import ddb.dsz.core.connection.events.ThrottleEvent;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.ClosureFactory;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.DataTransformer;
import ddb.dsz.core.task.Task;
import ddb.dsz.plugin.NoHostAbstractPlugin;
import ddb.dsz.plugin.connectioninfo.Connection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.ClosureUtils;

@DszLive(live=true, replay=false)
@DszLogo(value="images/clock.png")
@DszName(value="Connection Info")
@DszDescription(value="A plugin that monitors the connection bandwidth usage")
@DszUserStartable(value=false)
public class ConnectionInfo
extends NoHostAbstractPlugin
implements ConnectionChangeListener {
    private static final Collection<String> INTERESTING_COMMANDS;
    public static DateFormat FORMAT;
    public static final TimeZone GMT;
    public static final int CYCLE = 20;
    private volatile int Timer = 60;
    Calendar LastRun = Calendar.getInstance();
    private static final int MAXIMUM = 90;
    private final Runnable requestStatistics = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                1 var1_1 = this;
                synchronized (var1_1) {
                    block8: {
                        Calendar calendar;
                        if (!ConnectionInfo.this.requestedStatistics || (calendar = Calendar.getInstance()).getTimeInMillis() - ConnectionInfo.this.LastRun.getTimeInMillis() >= 90000L) break block8;
                        return;
                    }
                    ConnectionInfo.this.requestedStatistics = true;
                }
                ConnectionInfo.this.core.requestStatistics();
            }
            finally {
                ConnectionInfo.this.core.schedule((Runnable)this, (long)ConnectionInfo.this.Timer, TimeUnit.SECONDS);
            }
        }
    };
    private final Runnable updateConnectionTime = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl;
            if (DisplayType.Cycle.equals((Object)ConnectionInfo.this.current)) {
                if (ConnectionInfo.this.cycleCount-- == 0) {
                    ConnectionInfo.this.cycleCount = 20;
                    ConnectionInfo.this.cycleLocal = !ConnectionInfo.this.cycleLocal;
                    ConnectionInfo.this.displayTime.repaint();
                }
            } else {
                ConnectionInfo.this.cycleCount = 20;
                ConnectionInfo.this.cycleLocal = DisplayType.Local.equals((Object)ConnectionInfo.this.current);
            }
            Calendar calendar = !(bl = ConnectionInfo.this.cycleLocal) ? Calendar.getInstance(GMT) : Calendar.getInstance();
            DisplayType displayType = ConnectionInfo.this.current;
            if (DisplayType.Cycle.equals((Object)displayType)) {
                displayType = bl ? DisplayType.Local : DisplayType.Gmt;
            }
            Object object = ConnectionInfo.this.CONNECTION_LOCK;
            synchronized (object) {
                for (Connection connection : ConnectionInfo.this.connections) {
                    connection.update(calendar, displayType);
                }
            }
            EventQueue.invokeLater((Runnable)new UpdateLabel(ConnectionInfo.this.lpTime, String.format("%04d/%02d/%02d %02d:%02d:%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13))));
        }
    };
    DefaultComboBoxModel model = new DefaultComboBoxModel<DisplayType>(DisplayType.values());
    int cycleCount = 20;
    boolean cycleLocal = true;
    DisplayType current = DisplayType.Gmt;
    final Object CONNECTION_LOCK = new Object();
    List<Connection> connections = new Vector<Connection>();
    boolean requestedStatistics = false;
    JSlider frequency = new JSlider(1, 60, 30);
    JComboBox displayTime = new JComboBox(this.model);
    JLabel lpTime = new JLabel("");
    JToolBar listOfConnections = new JToolBar(1);
    JLabel freqDisplay = new JLabel("");
    final DataTransformer transformer = DataTransformer.newInstance();
    Calendar lastStats = null;

    public ConnectionInfo() {
        super.setName("Connection Info");
        this.prefferedSize = new Dimension(400, 400);
        super.setCanClose(false);
        this.frameSize = this.getPreferredSize();
        this.frameSite = new Point(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width - this.frameSize.width, 0);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel4, "South");
        JLabel jLabel = new JLabel("Frequency:");
        jPanel4.add((Component)jLabel, "West");
        jPanel4.add((Component)this.frequency, "Center");
        jPanel4.add((Component)this.freqDisplay, "East");
        this.freqDisplay.setText(String.format("%02d seconds", this.frequency.getValue()));
        jPanel2.add((Component)this.displayTime, "North");
        jPanel2.add((Component)this.lpTime, "Center");
        this.lpTime.setFont(this.lpTime.getFont().deriveFont(18.0f));
        this.lpTime.setHorizontalAlignment(0);
        this.listOfConnections.setFloatable(false);
        jPanel3.add(new JScrollPane(this.listOfConnections, 20, 31));
        this.displayTime.setSelectedItem((Object)DisplayType.Cycle);
        this.displayTime.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && itemEvent.getItem() instanceof DisplayType) {
                    ConnectionInfo.this.current = (DisplayType)((Object)itemEvent.getItem());
                }
            }
        });
        this.displayTime.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component;
                if (n == -1 && object.equals((Object)DisplayType.Cycle)) {
                    Object object2 = object = ConnectionInfo.this.cycleLocal ? DisplayType.Local : DisplayType.Gmt;
                }
                if (object instanceof DisplayType) {
                    object = ((DisplayType)((Object)DisplayType.class.cast(object))).getText();
                }
                if ((component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2)) instanceof JLabel && n == -1) {
                    ((JLabel)JLabel.class.cast(component)).setHorizontalAlignment(0);
                }
                return component;
            }
        });
        this.frequency.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ConnectionInfo.this.Timer = ConnectionInfo.this.frequency.getValue();
                ConnectionInfo.this.freqDisplay.setText(String.format("%02d seconds", ConnectionInfo.this.Timer));
            }
        });
        super.setShowStatus(false);
        super.setDisplay((JComponent)jPanel);
        this.Timer = this.frequency.getValue();
    }

    protected int init2() {
        if (this.transformer == null) {
            return -1;
        }
        this.core.schedule(this.requestStatistics, (long)this.frequency.getValue(), TimeUnit.SECONDS);
        this.core.scheduleWithFixedDelay(this.updateConnectionTime, 500L, 250L, TimeUnit.MILLISECONDS);
        this.transformer.addClosure(ClosureFactory.newVariableClosure((CoreController)this.core, (String)"time", (String)"Dsz", (Closure)new Closure(){
            final DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Object object) {
                if (object == null || !(object instanceof DataEvent)) {
                    return;
                }
                DataEvent dataEvent = (DataEvent)object;
                if (DataEvent.DataEventType.DATA.equals((Object)dataEvent.getDataType()) && dataEvent.getData().getObject("timeitem") != null) {
                    Calendar calendar = Calendar.getInstance();
                    try {
                        calendar.setTime(this.format.parse(dataEvent.getData().getString("timeitem::gui_timestamp")));
                    }
                    catch (ParseException parseException) {
                        return;
                    }
                    Calendar calendar2 = Calendar.getInstance();
                    try {
                        calendar2.setTime(this.format.parse(String.format("%sT%s", dataEvent.getData().getString("timeitem::gmttime::date"), dataEvent.getData().getString("timeitem::gmttime::time"))));
                    }
                    catch (ParseException parseException) {
                        return;
                    }
                    Calendar calendar3 = Calendar.getInstance();
                    try {
                        calendar3.setTime(this.format.parse(String.format("%sT%s", dataEvent.getData().getString("timeitem::localtime::date"), dataEvent.getData().getString("timeitem::localtime::time"))));
                    }
                    catch (ParseException parseException) {
                        return;
                    }
                    long l = calendar.getTimeInMillis() - calendar2.getTimeInMillis();
                    long l2 = calendar3.getTimeInMillis() - calendar2.getTimeInMillis();
                    Object object2 = ConnectionInfo.this.CONNECTION_LOCK;
                    synchronized (object2) {
                        for (Connection connection : ConnectionInfo.this.connections) {
                            if (!connection.getHost().sameHost(ConnectionInfo.this.core.getTaskById(dataEvent.getTaskId()).getHost())) continue;
                            connection.setTime(l, l2, calendar3, calendar2);
                        }
                    }
                }
            }
        }, (Closure)ClosureUtils.nopClosure()));
        return 0;
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionChanged(final ConnectionChangeEvent connectionChangeEvent) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ConnectionInfo.this.connectionChanged(connectionChangeEvent);
                }
            });
            return;
        }
        if (connectionChangeEvent instanceof NewHostEvent) {
            NewHostEvent newHostEvent = (NewHostEvent)connectionChangeEvent;
            if (newHostEvent.getHost() == null) {
                return;
            }
            if (newHostEvent.getHost().isLocal()) {
                return;
            }
            Object object = this.CONNECTION_LOCK;
            synchronized (object) {
                Connection connection = new Connection(newHostEvent.getHost());
                this.listOfConnections.add(connection);
                this.connections.add(connection);
            }
            super.contentsChanged();
        } else if (connectionChangeEvent instanceof StatisticsEvent) {
            Object object = this.requestStatistics;
            synchronized (object) {
                this.requestedStatistics = false;
            }
            object = Calendar.getInstance();
            long l = 0L;
            if (this.lastStats != null) {
                l = ((Calendar)object).getTimeInMillis() - this.lastStats.getTimeInMillis();
            }
            StatisticsEvent statisticsEvent = (StatisticsEvent)StatisticsEvent.class.cast(connectionChangeEvent);
            Object object2 = this.CONNECTION_LOCK;
            synchronized (object2) {
                block15: for (Connection connection : this.connections) {
                    for (StatisticsEvent.Host host : statisticsEvent.getHosts()) {
                        if (!host.getId().equalsIgnoreCase(connection.getHost().getId())) continue;
                        connection.updateStatistics(l, host.getSent(), host.getReceived());
                        continue block15;
                    }
                }
            }
            this.lastStats = object;
        } else {
            if (connectionChangeEvent instanceof ThrottleEvent) {
                ThrottleEvent throttleEvent = (ThrottleEvent)connectionChangeEvent;
                Object object = this.CONNECTION_LOCK;
                synchronized (object) {
                    for (Connection connection : this.connections) {
                        if (!connection.getHost().getId().equalsIgnoreCase(throttleEvent.getAddress())) continue;
                        connection.setThrottle(throttleEvent.getBytes());
                    }
                }
            }
            if (connectionChangeEvent instanceof DisconnectEvent) {
                DisconnectEvent disconnectEvent = (DisconnectEvent)connectionChangeEvent;
                Object object = this.CONNECTION_LOCK;
                synchronized (object) {
                    for (Connection connection : this.connections) {
                        if (!connection.getHost().getId().equalsIgnoreCase(disconnectEvent.getHost().getId())) continue;
                        connection.disconnected();
                    }
                }
            }
        }
    }

    protected void commandEnded(CommandEvent commandEvent) {
        Task task = this.core.getTaskById(commandEvent.getId());
        if (task == null) {
            return;
        }
        if (task.getCommandName() == null) {
            return;
        }
        if (INTERESTING_COMMANDS.contains(task.getCommandName().toLowerCase())) {
            this.transformer.addTask(task);
        }
    }

    protected final boolean parseArgument2(String string, String string2) {
        if (!string.equalsIgnoreCase("delay") || string2 != null) {
            // empty if block
        }
        if (!string.equalsIgnoreCase("mirror") || string2 == null) {
            // empty if block
        }
        return false;
    }

    public static void main(String[] stringArray) throws Exception {
        Class<?> clazz = Class.forName("ds.plugin.live.DSClientApp");
        Method method = clazz.getMethod("main", String[].class);
        method.invoke(null, new Object[]{stringArray});
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("time");
        INTERESTING_COMMANDS = Collections.unmodifiableSet(hashSet);
        FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss Z");
        GMT = TimeZone.getTimeZone("GMT");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayType {
        Local("Local Time"),
        Gmt("GMT"),
        Cycle("Cycle Through");

        String text;

        private DisplayType(String string2) {
            this.text = string2;
        }

        public String getText() {
            return this.text;
        }
    }
}

