/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.connectioninfo;

import ddb.dsz.core.host.HostInfo;
import ddb.dsz.plugin.connectioninfo.ConnectionInfo;
import ddb.util.Pair;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.layout.GroupLayout;

public class Connection
extends JPanel {
    static final BigDecimal kilo = BigDecimal.valueOf(1024L);
    static final DecimalFormat decForm = new DecimalFormat();
    static final List<Pair<String, BigDecimal>> magnitude;
    static final int signCharacters = 4;
    static final int DEFAULT_MAXIMUM = 16384;
    static DefaultFormatterFactory total;
    HostInfo hostInfo;
    long delta = 0L;
    Calendar local = null;
    Calendar gmt = null;
    Calendar connected = Calendar.getInstance();
    long timeZoneDelta;
    boolean isConnected = true;
    private final Object CONN_LOCK = new Object();
    BigInteger lastSent = BigInteger.ZERO;
    BigInteger lastReceived = BigInteger.ZERO;
    private JLabel durationLabel;
    private JLabel durationValue;
    private JLabel hostValue;
    private JFormattedTextField receivedField;
    private JLabel receivedLabel;
    private JFormattedTextField sentField;
    private JLabel sentLabel;
    private JLabel timeValue;

    static String simplifyNumber(Long l) {
        return Connection.simplifyNumber(BigInteger.valueOf(l));
    }

    static String simplifyNumber(BigInteger bigInteger) {
        int n = 0;
        BigDecimal bigDecimal = new BigDecimal(bigInteger);
        for (n = 1; n < magnitude.size() && bigDecimal.compareTo((BigDecimal)magnitude.get(n).getSecond()) >= 0; ++n) {
        }
        if (--n == 0) {
            return String.format("%d %s", bigInteger.longValue(), magnitude.get(n).getFirst());
        }
        String string = bigDecimal.divide((BigDecimal)magnitude.get(n).getSecond()).toPlainString();
        if (string.length() > 4) {
            string = string.substring(0, 4);
        }
        return String.format("%s %s", string, magnitude.get(n).getFirst());
    }

    public Connection(HostInfo hostInfo) {
        this.hostInfo = hostInfo;
        this.initComponents();
    }

    public void setTime(long l, long l2, Calendar calendar, Calendar calendar2) {
        this.local = calendar;
        this.gmt = calendar2;
        this.delta = l;
        this.timeZoneDelta = l2;
    }

    public HostInfo getHost() {
        return this.hostInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected() {
        Object object = this.CONN_LOCK;
        synchronized (object) {
            this.isConnected = false;
        }
        object = Calendar.getInstance();
        this.durationValue.setText(String.format("<html><font color=\"red\">%s", this.millisToString(((Calendar)object).getTimeInMillis() - this.connected.getTimeInMillis())));
        this.timeValue.setText(String.format("<html><font color=\"red\">%04d/%02d/%02d<br>%02d:%02d:%02d", ((Calendar)object).get(1), ((Calendar)object).get(2) + 1, ((Calendar)object).get(5), ((Calendar)object).get(11), ((Calendar)object).get(12), ((Calendar)object).get(13)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Calendar calendar, ConnectionInfo.DisplayType displayType) {
        Object object = this.CONN_LOCK;
        synchronized (object) {
            if (!this.isConnected) {
                return;
            }
            long l = this.delta;
            Calendar calendar2 = null;
            switch (displayType) {
                case Local: {
                    calendar2 = this.local;
                    break;
                }
                case Cycle: 
                case Gmt: {
                    calendar2 = this.gmt;
                }
            }
            if (calendar2 == null) {
                return;
            }
            final Calendar calendar3 = Calendar.getInstance();
            calendar3.setTimeInMillis(calendar2.getTimeInMillis());
            final Calendar calendar4 = Calendar.getInstance();
            calendar3.add(14, (int)(calendar4.getTimeInMillis() - this.connected.getTimeInMillis()));
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    Connection.this.timeValue.setText(String.format("<html>%04d/%02d/%02d<br>%02d:%02d:%02d", calendar3.get(1), calendar3.get(2) + 1, calendar3.get(5), calendar3.get(11), calendar3.get(12), calendar3.get(13)));
                    Connection.this.durationValue.setText(Connection.this.millisToString(calendar4.getTimeInMillis() - Connection.this.connected.getTimeInMillis()));
                }
            });
        }
    }

    private String millisToString(long l) {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        l5 = (l /= 1000L) % 60L;
        l4 = (l /= 60L) % 60L;
        l3 = (l /= 60L) % 24L;
        l2 = l /= 24L;
        String string = l2 > 0L ? "%1$dd %2$02d:%3$02d:%4$02d" : (l3 >= 0L ? "%2$02d:%3$02d:%4$02d" : "%3$02d:%4$02d");
        return String.format(string, l2, l3, l4, l5);
    }

    public void updateStatistics(long l, BigInteger bigInteger, BigInteger bigInteger2) {
        EventQueue.invokeLater(new UpdateStatistics(l, bigInteger, bigInteger2));
    }

    private void updateProgress(JProgressBar jProgressBar, BigInteger bigInteger, BigInteger bigInteger2, long l) {
        if (jProgressBar == null || bigInteger == null || bigInteger2 == null || l == 0L) {
            return;
        }
        try {
            BigDecimal bigDecimal = BigDecimal.valueOf(bigInteger.subtract(bigInteger2).longValue());
            bigDecimal = bigDecimal.divide(BigDecimal.valueOf(l), RoundingMode.HALF_UP);
            bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(1000L));
            int n = bigDecimal.intValue();
            if (n > jProgressBar.getMaximum()) {
                jProgressBar.setValue(jProgressBar.getMaximum());
            } else {
                jProgressBar.setValue(n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setThrottle(int n) {
        if (n <= 0) {
            n = 16384;
        }
    }

    private void initComponents() {
        this.timeValue = new JLabel();
        this.durationLabel = new JLabel();
        this.durationValue = new JLabel();
        this.sentLabel = new JLabel();
        this.receivedLabel = new JLabel();
        this.sentField = new JFormattedTextField();
        this.receivedField = new JFormattedTextField();
        this.hostValue = new JLabel();
        this.setBorder(BorderFactory.createTitledBorder(String.format("%s:  [%s]%s %s", this.hostInfo.getId(), this.hostInfo.getArch(), this.hostInfo.getPlatform(), this.hostInfo.getVersion())));
        this.timeValue.setFont(new Font("Tahoma", 0, 18));
        this.timeValue.setHorizontalAlignment(4);
        this.timeValue.setText("<html>&nbsp;<br>&nbsp;</html>");
        this.durationLabel.setText("Duration:");
        this.durationValue.setFont(new Font("Tahoma", 0, 14));
        this.durationValue.setHorizontalAlignment(4);
        this.durationValue.setText("   ");
        this.sentLabel.setHorizontalAlignment(0);
        this.sentLabel.setText("Sent:");
        this.receivedLabel.setHorizontalAlignment(0);
        this.receivedLabel.setText("Received:");
        this.sentField.setEditable(false);
        this.sentField.setFormatterFactory(total);
        this.sentField.setHorizontalAlignment(4);
        this.sentField.setFont(this.sentField.getFont());
        this.receivedField.setEditable(false);
        this.receivedField.setFormatterFactory(total);
        this.receivedField.setHorizontalAlignment(4);
        this.receivedField.setFont(this.receivedField.getFont());
        this.hostValue.setFont(this.hostValue.getFont().deriveFont(this.hostValue.getFont().getStyle() | 1, this.hostValue.getFont().getSize() + 1));
        this.hostValue.setText(this.hostInfo.getHostname());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.timeValue, -1, 85, Short.MAX_VALUE).add(2, (Component)this.hostValue, -1, 85, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.durationLabel).addPreferredGap(0).add((Component)this.durationValue, -1, 83, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.receivedLabel).add((Component)this.sentLabel)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.sentField, -1, 68, Short.MAX_VALUE).add((Component)this.receivedField, -1, 68, Short.MAX_VALUE))))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.sentField, -2, -1, -2).add((Component)this.sentLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.receivedLabel).add((Component)this.receivedField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.durationLabel).add((Component)this.durationValue))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.hostValue).addPreferredGap(0).add((Component)this.timeValue, -2, -1, -2)));
    }

    static {
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        arrayList.add(new Pair((Object)"B", (Object)BigDecimal.valueOf(1L)));
        arrayList.add(new Pair((Object)"KB", (Object)kilo));
        arrayList.add(new Pair((Object)"MB", (Object)kilo.pow(2)));
        arrayList.add(new Pair((Object)"GB", (Object)kilo.pow(3)));
        arrayList.add(new Pair((Object)"TB", (Object)kilo.pow(4)));
        magnitude = Collections.unmodifiableList(arrayList);
        total = new DefaultFormatterFactory(){

            public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
                return new DefaultFormatter(){

                    public String valueToString(Object object) throws ParseException {
                        if (object instanceof BigInteger) {
                            return String.format("%s", Connection.simplifyNumber((BigInteger)BigInteger.class.cast(object)));
                        }
                        return super.valueToString(object);
                    }
                };
            }
        };
    }

    class UpdateStatistics
    implements Runnable {
        long delta;
        BigInteger sent;
        BigInteger received;

        UpdateStatistics(long l, BigInteger bigInteger, BigInteger bigInteger2) {
            this.delta = l;
            this.sent = bigInteger;
            this.received = bigInteger2;
        }

        public void run() {
            Connection.this.sentField.setValue(this.sent);
            Connection.this.receivedField.setValue(this.received);
            if (this.delta > 0L) {
                // empty if block
            }
            Connection.this.lastSent = this.sent;
            Connection.this.lastReceived = this.received;
        }
    }
}

