/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.requesthandler;

import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.ClosureFactory;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.DataTransformer;
import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.internalcommand.InternalCommandCallback;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.peer.PeerTag;
import ddb.dsz.plugin.requesthandler.RequestHandler;
import ddb.dsz.plugin.requesthandler.closures.ExecutionClosure;
import ddb.dsz.plugin.requesthandler.jaxb.requesthandlercomms.AutoApproveType;
import ddb.dsz.plugin.requesthandler.jaxb.requesthandlercomms.BooleanValue;
import ddb.dsz.plugin.requesthandler.jaxb.requesthandlercomms.ExecutedRequestType;
import ddb.dsz.plugin.requesthandler.jaxb.requesthandlercomms.IntegerValue;
import ddb.dsz.plugin.requesthandler.jaxb.requesthandlercomms.ObjectFactory;
import ddb.dsz.plugin.requesthandler.jaxb.requesthandlercomms.ObjectValueType;
import ddb.dsz.plugin.requesthandler.jaxb.requesthandlercomms.ParentType;
import ddb.dsz.plugin.requesthandler.jaxb.requesthandlercomms.RequestCompletedType;
import ddb.dsz.plugin.requesthandler.jaxb.requesthandlercomms.ResponseType;
import ddb.dsz.plugin.requesthandler.jaxb.requesthandlercomms.StringValue;
import ddb.dsz.plugin.requesthandler.jaxb.requesthandlercomms.TaskDataType;
import ddb.dsz.plugin.requesthandler.model.RequestStatus;
import ddb.dsz.plugin.requesthandler.model.RequestTableColumns;
import ddb.dsz.plugin.requesthandler.requests.RequestedOperation;
import ddb.dsz.plugin.requesthandler.tranformers.CancelledRequest;
import ddb.dsz.plugin.requesthandler.tranformers.DeniedRequest;
import ddb.dsz.plugin.requesthandler.tranformers.RequestToResponse;
import ddb.util.Guid;
import ddb.util.JaxbCache;
import ddb.util.checkedtablemodel.CheckableFilterList;
import ddb.util.checkedtablemodel.CheckedTableSelection;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.collections.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DszLive(live=true, replay=false)
@DszLogo(value="images/antivirus.png")
@DszName(value="Request Receiver")
@DszDescription(value="Handles all things request related")
public class RequestReceiver
extends RequestHandler {
    public static final String AUTO_APPROVE = "/RequestHandler/autoApprove.xml";
    public static final String TIME_BETWEEN = "-delay";
    public static final String MAX_RUNNING = "-max";
    int timeBetweenChecks = 2;
    int nextId = 0;
    final Object threadLock = new Object();
    CheckableFilterList<PeerTag> list;
    List<PeerTag> approvedList = new Vector<PeerTag>();
    List<PeerTag> allPeers = new Vector<PeerTag>();
    List<String> autoApprove = new Vector<String>();
    final Set<Task> remotedTasks = new HashSet<Task>();
    private Runnable executeRequest = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = true;
            Set<Task> set = RequestReceiver.this.remotedTasks;
            synchronized (set) {
                HashSet<Task> hashSet = new HashSet<Task>();
                for (Task task : RequestReceiver.this.remotedTasks) {
                    if (task.isAlive()) continue;
                    hashSet.add(task);
                }
                for (Task task : hashSet) {
                    RequestReceiver.this.remotedTasks.remove(task);
                }
                bl = RequestReceiver.this.remotedTasks.isEmpty();
            }
            RequestReceiver.this.requests.startNextCommand(bl);
        }
    };

    public RequestReceiver() {
        super.setName("Request Receiver");
        this.prefferedSize = new Dimension(550, 200);
        super.setCareAboutLocalEvents(true);
    }

    @Override
    protected int init3() {
        this.requests.setStatus(this.getStatus());
        this.list = new CheckableFilterList("Requestors", (CheckedTableSelection)new CheckedTableSelection<PeerTag>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void selected(PeerTag peerTag, boolean bl) {
                Object object = RequestReceiver.this.threadLock;
                synchronized (object) {
                    if (bl) {
                        RequestReceiver.this.approvedList.add(peerTag);
                    } else {
                        while (RequestReceiver.this.approvedList.remove(peerTag)) {
                        }
                    }
                }
            }
        }, (Comparator)new Comparator<PeerTag>(){

            @Override
            public int compare(PeerTag peerTag, PeerTag peerTag2) {
                if (peerTag == peerTag2) {
                    return 0;
                }
                if (peerTag == null) {
                    return 1;
                }
                return peerTag.compareTo((Object)peerTag2);
            }
        });
        JSplitPane jSplitPane = new JSplitPane(1, (Component)this.list, this.mainPanel);
        super.setDisplay((JComponent)jSplitPane);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setOneTouchExpandable(true);
        try {
            JAXBContext jAXBContext = null;
            Unmarshaller unmarshaller = null;
            jAXBContext = JaxbCache.getContext(ObjectFactory.class);
            unmarshaller = jAXBContext.createUnmarshaller();
            Object object = unmarshaller.unmarshal(RequestReceiver.class.getResource(AUTO_APPROVE));
            if (object instanceof JAXBElement) {
                object = ((JAXBElement)JAXBElement.class.cast(object)).getValue();
            }
            if (object instanceof AutoApproveType) {
                this.autoApprove.addAll(((AutoApproveType)AutoApproveType.class.cast(object)).getIdentifier());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.core.scheduleWithFixedDelay(this.executeRequest, 10L, (long)this.timeBetweenChecks, TimeUnit.SECONDS);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRemoteCommand(TaskId taskId) {
        Task task = this.core.getTaskById(taskId);
        if (task == null) {
            return;
        }
        Set<Task> set = this.remotedTasks;
        synchronized (set) {
            this.remotedTasks.add(task);
        }
    }

    @Override
    protected boolean parseArgument3(String string, String string2) {
        int n;
        if (string.equalsIgnoreCase(TIME_BETWEEN)) {
            try {
                n = Integer.parseInt(string2);
                if (n >= 0) {
                    this.timeBetweenChecks = n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string.equalsIgnoreCase(MAX_RUNNING)) {
            try {
                n = Integer.parseInt(string2);
                if (n >= 0) {
                    this.requests.setMaximumRunning(n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(RequestedOperation requestedOperation, PeerTag peerTag) {
        requestedOperation.setId(BigInteger.valueOf(this.nextId++));
        boolean bl = true;
        Object object = this.threadLock;
        synchronized (object) {
            this.requests.addRequest(requestedOperation);
            this.publish(RequestToResponse.getInstance().transform(requestedOperation), null);
            if (this.approvedList.contains(peerTag) || this.approveByName(peerTag.getPeerName())) {
                this.requests.enable(requestedOperation.getId());
                bl = false;
            }
        }
        if (bl) {
            this.fireNewRequest();
        }
    }

    private boolean approveByName(String string) {
        return this.autoApprove.contains(string);
    }

    @Override
    public void executeRequest(RequestedOperation requestedOperation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCancel(BigInteger bigInteger, PeerTag peerTag) {
        Object object = this.threadLock;
        synchronized (object) {
            if (this.requests.cancelledRequest(bigInteger, peerTag)) {
                this.publish(CancelledRequest.getInstance().transform(bigInteger), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void approve(BigInteger bigInteger) {
        Object object = this.threadLock;
        synchronized (object) {
            this.requests.enable(bigInteger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void force(BigInteger bigInteger) {
        Object object = this.threadLock;
        synchronized (object) {
            this.requests.force(bigInteger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runInternalCommand(List<String> list, InternalCommandCallback internalCommandCallback) {
        RequestedOperation requestedOperation = this.generateOperation(list);
        if (requestedOperation != null) {
            requestedOperation.setId(BigInteger.valueOf(this.nextId++));
            requestedOperation.setLocal();
            requestedOperation.setSource("Live Operation");
            if (internalCommandCallback != null) {
                internalCommandCallback.taskingRecieved(list, (Object)requestedOperation.getId());
                requestedOperation.setCallback(internalCommandCallback);
            }
            Object object = this.threadLock;
            synchronized (object) {
                this.requests.addRequest(requestedOperation);
                this.publish(RequestToResponse.getInstance().transform(requestedOperation), null);
                this.requests.enable(requestedOperation.getId());
            }
            return true;
        }
        return false;
    }

    @Override
    protected Closure getExecutor(CoreController coreController) {
        return ExecutionClosure.getInstance(this, coreController);
    }

    public void sendStarted(BigInteger bigInteger, TaskId taskId, PeerTag peerTag) {
        if (bigInteger.equals(RequestedOperation.NO_ID)) {
            return;
        }
        this.requests.addTask(taskId);
        ExecutedRequestType executedRequestType = new ExecutedRequestType();
        executedRequestType.setReqId(bigInteger);
        executedRequestType.setTaskId(BigInteger.valueOf(taskId.getId()));
        executedRequestType.setOperation(taskId.getOperation().getGuid().toString());
        ResponseType responseType = new ResponseType();
        responseType.setExecutedRequest(executedRequestType);
        this.publish(objFact.createResponse(responseType), peerTag);
    }

    @Override
    protected String getCancelName() {
        return "Deny";
    }

    @Override
    protected boolean allowEnabled() {
        return true;
    }

    @Override
    protected boolean forceEnabled() {
        return true;
    }

    @Override
    protected void cancel(BigInteger bigInteger) {
        this.handleCancel(bigInteger, null);
    }

    @Override
    public void fireNewRequest() {
        super.contentsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newConnection(final PeerTag peerTag) {
        Object object = this.threadLock;
        synchronized (object) {
            this.allPeers.add(peerTag);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    RequestReceiver.this.list.addElement((Object)peerTag, false);
                }
            });
            block9: for (int i = 0; i < this.requests.getRowCount(); ++i) {
                RequestedOperation requestedOperation = (RequestedOperation)RequestedOperation.class.cast(this.requests.getValueAt(i, RequestTableColumns.DESCRIPTION));
                this.publish(RequestToResponse.getInstance().transform(requestedOperation), peerTag);
                RequestStatus requestStatus = (RequestStatus)((Object)RequestStatus.class.cast(this.requests.getValueAt(i, RequestTableColumns.STATUS)));
                switch (requestStatus) {
                    case CANCELLED: {
                        this.publish(CancelledRequest.getInstance().transform(requestedOperation.getId()), peerTag);
                        continue block9;
                    }
                    case DENIED: {
                        this.publish(DeniedRequest.getInstance().transform(requestedOperation.getId()), peerTag);
                        continue block9;
                    }
                    case EXECUTED: {
                        this.sendStarted(requestedOperation.getId(), requestedOperation.getTaskId(), peerTag);
                        continue block9;
                    }
                    case PENDING: {
                        this.publish(RequestToResponse.getInstance().transform(requestedOperation), peerTag);
                        continue block9;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closedConnection(final PeerTag peerTag) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                RequestReceiver.this.list.deleteElement((Object)peerTag);
            }
        });
        Object object = this.threadLock;
        synchronized (object) {
            this.allPeers.remove(peerTag);
        }
    }

    @Override
    public void sendData(PeerTag peerTag, Guid guid, BigInteger bigInteger, boolean bl) {
        Operation operation = this.core.getOperation();
        if (guid != null) {
            operation = this.core.getOperationById(guid);
        }
        Collection collection = this.core.getTaskList();
        for (Task task : collection) {
            if (!task.getId().idMatch(bigInteger.intValue()) || operation != null && !task.getId().getOperation().equals(operation)) continue;
            this.sendData(peerTag, task, bl);
        }
    }

    private void sendData(final PeerTag peerTag, final Task task, boolean bl) {
        final DataTransformer dataTransformer = DataTransformer.newInstance();
        if (dataTransformer == null) {
            return;
        }
        dataTransformer.addClosure(ClosureFactory.newVariableClosure((CoreController)this.core, (Task)task, (Closure)new Closure(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Object object) {
                boolean bl;
                Object object2 = RequestReceiver.this.threadLock;
                synchronized (object2) {
                    bl = !RequestReceiver.this.allPeers.contains(peerTag);
                }
                if (bl) {
                    dataTransformer.stop();
                    return;
                }
                if (object instanceof DataEvent) {
                    Object object3;
                    object2 = (DataEvent)object;
                    TaskDataType taskDataType = new TaskDataType();
                    taskDataType.setOperation(task.getId().getOperation().getGuid().toString());
                    taskDataType.setTaskId(BigInteger.valueOf(task.getId().getId()));
                    if (task.getParentId() != null && !task.getParentId().equals((Object)TaskId.NULL) && !task.getParentId().equals((Object)TaskId.UNINITIALIZED_ID)) {
                        object3 = new ParentType();
                        ((ParentType)object3).setOperation(task.getParentId().getOperation().getGuid().toString());
                        ((ParentType)object3).setTaskId(BigInteger.valueOf(task.getParentId().getId()));
                        taskDataType.setParent((ParentType)object3);
                    }
                    object3 = new ObjectValueType();
                    taskDataType.setData((ObjectValueType)object3);
                    this.recursivelyAdd(object2.getData(), (ObjectValueType)object3);
                    ResponseType responseType = new ResponseType();
                    responseType.setTaskData(taskDataType);
                    RequestReceiver.this.publish(RequestHandler.objFact.createResponse(responseType), peerTag);
                }
            }

            private void recursivelyAdd(ObjectValue objectValue, ObjectValueType objectValueType) {
                Object object;
                objectValueType.setName("");
                for (String string : objectValue.getObjectNames()) {
                    for (Object object2 : objectValue.getObjects(string)) {
                        object = new ObjectValueType();
                        this.recursivelyAdd((ObjectValue)object2, (ObjectValueType)object);
                        ((ObjectValueType)object).setName(string);
                        objectValueType.getObjectValue().add((ObjectValueType)object);
                    }
                }
                for (String string : objectValue.getBooleanNames()) {
                    for (Object object2 : objectValue.getBooleans(string)) {
                        object = new BooleanValue();
                        ((BooleanValue)object).setName(string);
                        ((BooleanValue)object).setValue((Boolean)object2);
                        objectValueType.getBooleanValue().add((BooleanValue)object);
                    }
                }
                for (String string : objectValue.getIntegerNames()) {
                    for (Object object2 : objectValue.getIntegers(string)) {
                        object = new IntegerValue();
                        ((IntegerValue)object).setName(string);
                        ((IntegerValue)object).setValue(BigInteger.valueOf((Long)object2));
                        objectValueType.getIntegerValue().add((IntegerValue)object);
                    }
                }
                for (String string : objectValue.getStringNames()) {
                    for (Object object2 : objectValue.getStrings(string)) {
                        object = new StringValue();
                        ((StringValue)object).setName(string);
                        ((StringValue)object).setValue((String)object2);
                        objectValueType.getStringValue().add((StringValue)object);
                    }
                }
            }
        }));
        dataTransformer.addTask(task);
        if (bl) {
            for (Task task2 : this.core.getTaskList()) {
                if (!task2.getParentId().equals((Object)task.getId())) continue;
                this.sendData(peerTag, task2, bl);
            }
        }
    }

    protected void commandEnded(CommandEvent commandEvent) {
        super.commandEnded(commandEvent);
        this.requests.removeTask(commandEvent.getId());
        Task task = this.core.getTaskById(commandEvent.getId());
        if (task == null) {
            return;
        }
        BigInteger bigInteger = this.requests.requestForTask(task);
        if (bigInteger == null || bigInteger == RequestedOperation.NO_ID) {
            return;
        }
        RequestCompletedType requestCompletedType = new RequestCompletedType();
        requestCompletedType.setReqId(bigInteger);
        requestCompletedType.setStatus(task.getStateString());
        requestCompletedType.setTaskId(BigInteger.valueOf(task.getId().getId()));
        requestCompletedType.setOperation(task.getId().getOperation().getGuid().toString());
        requestCompletedType.setValue("");
        ResponseType responseType = new ResponseType();
        responseType.setRequestCompleted(requestCompletedType);
        this.publish(objFact.createResponse(responseType), null);
    }

    public static void main(String[] stringArray) throws Exception {
        Class<?> clazz = Class.forName("ds.plugin.live.DSClientApp");
        Class<?> clazz2 = Class.forName("ds.plugin.replay.OpReplayDriver");
        Method method = clazz.getMethod("main", stringArray.getClass());
        method.invoke(null, new Object[]{stringArray});
    }
}

