/*
 * Decompiled with CFR 0.152.
 */
package ddb.util.tablefilter.sample;

import ddb.util.UtilityConstants;
import ddb.util.checkedtablemodel.FilterWatcher;
import ddb.util.tablefilter.DefaultTableFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import org.apache.commons.collections.Predicate;

public abstract class RowFilter
extends DefaultTableFilter
implements FilterWatcher {
    private static ExecutorService exec = UtilityConstants.createExecutorService("RowFilter");
    List<Integer> rowTranslation = new ArrayList<Integer>();
    Predicate filter;
    private ReadWriteLock access = UtilityConstants.createReadWriteLock();
    protected Runnable Update = new Runnable(){
        boolean bUpdating = false;
        boolean bRunAgain = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Integer[] integerArray = this;
            synchronized (this) {
                if (this.bUpdating) {
                    this.bRunAgain = true;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.bUpdating = true;
                this.bRunAgain = false;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                try {
                    integerArray = null;
                    int n = 0;
                    RowFilter.this.readLock();
                    try {
                        integerArray = new Integer[RowFilter.this.model.getRowCount()];
                        for (int i = 0; i < RowFilter.this.model.getRowCount(); ++i) {
                            if (RowFilter.this.filter != null && !RowFilter.this.show(i)) continue;
                            integerArray[n++] = i;
                        }
                    }
                    finally {
                        RowFilter.this.readUnlock();
                    }
                    RowFilter.this.writeLock();
                    try {
                        RowFilter.this.rowTranslation = Arrays.asList(integerArray).subList(0, n);
                    }
                    finally {
                        RowFilter.this.writeUnlock();
                    }
                    RowFilter.this.fireTableDataChanged();
                }
                finally {
                    integerArray = this;
                    synchronized (this) {
                        this.bUpdating = false;
                        if (this.bRunAgain) {
                            exec.submit((Runnable)this);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
                return;
            }
        }
    };

    protected void readLock() {
        this.access.readLock().lock();
    }

    protected void writeLock() {
        this.access.writeLock().lock();
    }

    protected void readUnlock() {
        this.access.readLock().unlock();
    }

    protected void writeUnlock() {
        this.access.writeLock().unlock();
    }

    public RowFilter() {
    }

    public RowFilter(Predicate predicate) {
        this();
        this.filter = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(Predicate predicate) {
        this.writeLock();
        try {
            this.filter = predicate;
        }
        finally {
            this.writeUnlock();
        }
        exec.submit(this.Update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        this.readLock();
        try {
            int n = this.rowTranslation.size();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(TableModel tableModel) {
        this.writeLock();
        try {
            super.setModel(tableModel);
        }
        finally {
            this.writeUnlock();
        }
        exec.submit(this.Update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getFirstRow() == -1 && tableModelEvent.getLastRow() == -1 && tableModelEvent.getColumn() == -1) {
            this.fireTableStructureChanged();
        } else {
            try {
                if (tableModelEvent.getLastRow() > this.model.getRowCount() || tableModelEvent.getFirstRow() == -1) {
                    exec.submit(this.Update);
                    return;
                }
                switch (tableModelEvent.getType()) {
                    case 0: {
                        for (int i = tableModelEvent.getLastRow(); i <= tableModelEvent.getFirstRow(); ++i) {
                            this.readLock();
                            try {
                                int n = this.translateModelRowToViewRow(i);
                                if (n == -1) continue;
                                this.fireTableRowsUpdated(n, n);
                                continue;
                            }
                            finally {
                                this.readUnlock();
                            }
                        }
                        break;
                    }
                    case -1: {
                        exec.submit(this.Update);
                        break;
                    }
                    case 1: {
                        exec.submit(this.Update);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int translateModelRowToViewRow(int n) {
        this.readLock();
        try {
            int n2;
            for (n2 = 0; n2 < this.rowTranslation.size(); ++n2) {
                if (this.rowTranslation.get(n2) != n) continue;
                int n3 = n2;
                return n3;
            }
            n2 = -1;
            return n2;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int lastRowBefore(int n) {
        this.readLock();
        try {
            int n2;
            for (n2 = 0; n2 < this.rowTranslation.size(); ++n2) {
                if (this.rowTranslation.get(n2) < n) continue;
                int n3 = n2;
                return n3;
            }
            n2 = this.rowTranslation.size();
            return n2;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int translateViewLocationToModelRow(int n, int n2) {
        if (n <= -1) {
            return -1;
        }
        this.readLock();
        try {
            if (this.rowTranslation.size() <= n) {
                int n3 = -1;
                return n3;
            }
            int n4 = this.rowTranslation.get(n);
            return n4;
        }
        finally {
            this.readUnlock();
        }
    }

    public void predicateChanged() {
        exec.submit(this.Update);
    }

    protected abstract boolean show(int var1);
}

