/*
 * Decompiled with CFR 0.152.
 */
package ddb.util.tablefilter.sample;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnHidingModel
extends DefaultTableColumnModel
implements TableColumnModel {
    JPopupMenu menu = new JPopupMenu();
    Map<Enum<?>, TableColumn> enumToColumn = new HashMap();
    Map<Enum<?>, ColumnMenuItem> enumToMenuItem = new HashMap();
    Class<? extends Enum<?>> enumeration;

    public ColumnHidingModel(Class<? extends Enum<?>> clazz) {
        this.enumeration = clazz;
        for (Enum<?> enum_ : clazz.getEnumConstants()) {
            if (enum_.toString().equals("") || !this.canChangeState(enum_)) continue;
            ColumnMenuItem columnMenuItem = new ColumnMenuItem(enum_, enum_.toString());
            this.enumToMenuItem.put(enum_, columnMenuItem);
            this.menu.add(columnMenuItem);
        }
    }

    protected boolean canChangeState(Enum<?> enum_) {
        return true;
    }

    public void hide(int n) {
        this.hide(this.enumeration.getEnumConstants()[n]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide(Enum<?> enum_) {
        ColumnHidingModel columnHidingModel = this;
        synchronized (columnHidingModel) {
            super.removeColumn(this.enumToColumn.get(enum_));
            if (this.enumToMenuItem.get(enum_) != null) {
                this.enumToMenuItem.get(enum_).setSelected(false);
            }
        }
    }

    public boolean show(int n) {
        return this.show(this.enumeration.getEnumConstants()[n]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean show(Enum<?> enum_) {
        ColumnHidingModel columnHidingModel = this;
        synchronized (columnHidingModel) {
            if (this.tableColumns.contains(this.enumToColumn.get(enum_))) {
                return false;
            }
            super.addColumn(this.enumToColumn.get(enum_));
            if (this.enumToMenuItem.get(enum_) != null) {
                this.enumToMenuItem.get(enum_).setSelected(true);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColumn(TableColumn tableColumn) {
        ColumnHidingModel columnHidingModel = this;
        synchronized (columnHidingModel) {
            int n = super.getColumnCount();
            super.addColumn(tableColumn);
            Enum<?> enum_ = this.enumeration.getEnumConstants()[n];
            this.enumToColumn.put(enum_, tableColumn);
        }
    }

    public void applyToTable(JTable jTable) {
        if (jTable == null) {
            return;
        }
        this.applyToTableHeader(jTable.getTableHeader());
    }

    public void applyToTableHeader(final JTableHeader jTableHeader) {
        jTableHeader.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybePopup(mouseEvent);
            }

            private void maybePopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ColumnHidingModel.this.menu.show(jTableHeader, mouseEvent.getX(), mouseEvent.getY());
                    mouseEvent.consume();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveColumnBefore(Enum<?> enum_, Enum<?> enum_2) {
        int n = -1;
        int n2 = -1;
        if (enum_ == enum_2) {
            return;
        }
        ColumnHidingModel columnHidingModel = this;
        synchronized (columnHidingModel) {
            TableColumn tableColumn = this.enumToColumn.get(enum_);
            TableColumn tableColumn2 = this.enumToColumn.get(enum_2);
            for (int i = 0; i < super.getColumnCount(); ++i) {
                if (tableColumn == super.getColumn(i)) {
                    n = i;
                }
                if (tableColumn2 != super.getColumn(i)) continue;
                n2 = i;
            }
            if (n == -1 || n2 == -1) {
                return;
            }
        }
        this.moveColumn(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int translateViewToModel(Enum<?> enum_) {
        ColumnHidingModel columnHidingModel = this;
        synchronized (columnHidingModel) {
            TableColumn tableColumn = this.enumToColumn.get(enum_);
            return tableColumn.getModelIndex();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnMenuItem
    extends JCheckBoxMenuItem
    implements ActionListener {
        Enum<?> e;

        ColumnMenuItem(Enum<?> enum_, String string) {
            this.e = enum_;
            super.setText(string);
            super.setSelected(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isSelected()) {
                ColumnHidingModel.this.show(this.e);
            } else {
                ColumnHidingModel.this.hide(this.e);
            }
        }
    }
}

