/*
 * Decompiled with CFR 0.152.
 */
package ddb.util.tablefilter;

import ddb.util.tablefilter.TableFilterModel;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class LayeredTableModel
extends AbstractTableModel
implements TableFilterModel {
    List<TableFilterModel> filters;
    TableModel model;
    JTable table;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    Lock read = this.lock.readLock();
    Lock write = this.lock.writeLock();
    TableModelListener listener = new TableModelListener(){

        public void tableChanged(TableModelEvent tableModelEvent) {
            LayeredTableModel.this.fireTableChanged(new TableModelEvent(LayeredTableModel.this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), tableModelEvent.getType()));
        }
    };

    public LayeredTableModel() {
        this.filters = new Vector<TableFilterModel>();
    }

    public LayeredTableModel(TableModel tableModel) {
        this();
        this.setModel(tableModel);
    }

    public LayeredTableModel(TableModel tableModel, Collection<TableFilterModel> collection) {
        this(tableModel);
        for (TableFilterModel tableFilterModel : collection) {
            this.addFilter(tableFilterModel);
        }
    }

    public LayeredTableModel(TableModel tableModel, TableFilterModel[] tableFilterModelArray) {
        this(tableModel);
        for (TableFilterModel tableFilterModel : tableFilterModelArray) {
            this.addFilter(tableFilterModel);
        }
    }

    public LayeredTableModel(Collection<TableFilterModel> collection) {
        this();
        for (TableFilterModel tableFilterModel : collection) {
            this.addFilter(tableFilterModel);
        }
    }

    public LayeredTableModel(TableFilterModel[] tableFilterModelArray) {
        this();
        for (TableFilterModel tableFilterModel : tableFilterModelArray) {
            this.addFilter(tableFilterModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModel(TableModel tableModel) {
        this.write.lock();
        try {
            if (this.model != null) {
                if (this.filters.size() == 0) {
                    this.model.removeTableModelListener(this.listener);
                } else {
                    this.model.removeTableModelListener(this.filters.get(this.filters.size() - 1));
                }
            }
            this.model = tableModel;
            if (this.filters.size() == 0) {
                this.model.addTableModelListener(this.listener);
            } else {
                this.filters.get(this.filters.size() - 1).setModel(this.model);
            }
        }
        finally {
            this.write.unlock();
        }
        this.fireTableStructureChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFilterHelper(int n, TableFilterModel tableFilterModel) {
        this.write.lock();
        try {
            if (n == 0) {
                if (this.filters.size() == 0) {
                    if (this.model != null) {
                        this.model.removeTableModelListener(this.listener);
                    }
                } else {
                    this.filters.get(0).removeTableModelListener(this.listener);
                }
                tableFilterModel.addTableModelListener(this.listener);
            }
            this.filters.add(n, tableFilterModel);
            if (n != 0) {
                this.filters.get(n - 1).setModel(tableFilterModel);
            }
            if (n + 1 != this.filters.size()) {
                tableFilterModel.setModel(this.filters.get(n + 1));
            } else {
                tableFilterModel.setModel(this.model);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public void addFilter(TableFilterModel tableFilterModel) {
        this.addFilterHelper(this.filters.size(), tableFilterModel);
    }

    public void addFilter(int n, TableFilterModel tableFilterModel) {
        this.addFilterHelper(n, tableFilterModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllFilters(Collection<TableFilterModel> collection) {
        this.write.lock();
        try {
            for (TableFilterModel tableFilterModel : collection) {
                this.addFilterHelper(collection.size(), tableFilterModel);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllFilters(int n, Collection<TableFilterModel> collection) {
        this.write.lock();
        try {
            for (TableFilterModel tableFilterModel : collection) {
                this.addFilterHelper(n++, tableFilterModel);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(TableFilterModel tableFilterModel) {
        this.write.lock();
        try {
            if (this.unregisterFilter(this.filters.indexOf(tableFilterModel)) == null) {
                return;
            }
        }
        finally {
            this.write.unlock();
        }
        this.fireTableStructureChanged();
    }

    public TableFilterModel removeFilter(int n) {
        TableFilterModel tableFilterModel = this.unregisterFilter(n);
        if (tableFilterModel != null) {
            this.fireTableStructureChanged();
        }
        return tableFilterModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableFilterModel unregisterFilter(int n) {
        this.write.lock();
        try {
            if (n == -1) {
                TableFilterModel tableFilterModel = null;
                return tableFilterModel;
            }
            if (n >= this.filters.size()) {
                TableFilterModel tableFilterModel = null;
                return tableFilterModel;
            }
            TableFilterModel tableFilterModel = this.filters.remove(n);
            tableFilterModel.removeTableConfiguration(this.table);
            if (n == 0) {
                tableFilterModel.removeTableModelListener(this.listener);
                if (n == this.filters.size()) {
                    this.model.addTableModelListener(this.listener);
                } else {
                    this.filters.get(0).addTableModelListener(this.listener);
                }
            }
            if (n == this.filters.size()) {
                this.filters.get(n - 1).setModel(this.model);
            } else {
                this.filters.get(n - 1).setModel(this.filters.get(n));
            }
            TableFilterModel tableFilterModel2 = tableFilterModel;
            return tableFilterModel2;
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getColumnClass(int n) {
        this.read.lock();
        try {
            if (this.filters.size() == 0) {
                Class<?> clazz = this.model.getColumnClass(n);
                return clazz;
            }
            Class<?> clazz = this.filters.get(0).getColumnClass(n);
            return clazz;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnCount() {
        this.read.lock();
        try {
            if (this.filters.size() == 0) {
                int n = this.model.getColumnCount();
                return n;
            }
            int n = this.filters.get(0).getColumnCount();
            return n;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        this.read.lock();
        try {
            if (this.filters.size() == 0) {
                int n = this.model.getRowCount();
                return n;
            }
            int n = this.filters.get(0).getRowCount();
            return n;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n, int n2) {
        this.read.lock();
        try {
            if (this.filters.size() == 0) {
                Object object = this.model.getValueAt(n, n2);
                return object;
            }
            Object object = this.filters.get(0).getValueAt(n, n2);
            return object;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnName(int n) {
        this.read.lock();
        try {
            if (this.filters.size() == 0) {
                String string = this.model.getColumnName(n);
                return string;
            }
            String string = this.filters.get(0).getColumnName(n);
            return string;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCellEditable(int n, int n2) {
        this.read.lock();
        try {
            if (this.filters.size() == 0) {
                boolean bl = this.model.isCellEditable(n, n2);
                return bl;
            }
            boolean bl = this.filters.get(0).isCellEditable(n, n2);
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.write.lock();
        try {
            if (this.filters.size() == 0) {
                this.model.setValueAt(object, n, n2);
            } else {
                this.filters.get(0).setValueAt(object, n, n2);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public int translateViewLocationToModelColumn(int n, int n2) {
        return this.translateViewLocationToModelLocation((int)n, (int)n2).y;
    }

    @Override
    public int translateViewLocationToModelRow(int n, int n2) {
        return this.translateViewLocationToModelLocation((int)n, (int)n2).x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Point translateViewLocationToModelLocation(int n, int n2) {
        this.read.lock();
        try {
            Point point = new Point(n, n2);
            for (TableFilterModel tableFilterModel : this.filters) {
                point = new Point(tableFilterModel.translateViewLocationToModelRow(point.x, point.y), tableFilterModel.translateViewLocationToModelColumn(point.x, point.y));
            }
            Point point2 = point;
            return point2;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyTableConfiguration(JTable jTable) {
        this.write.lock();
        try {
            if (this.table != jTable) {
                this.removeTableConfiguration(this.table);
            }
            this.table = jTable;
            for (TableFilterModel tableFilterModel : this.filters) {
                tableFilterModel.applyTableConfiguration(this.table);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTableConfiguration(JTable jTable) {
        this.write.lock();
        try {
            if (this.table == jTable) {
                this.table = null;
            }
            for (TableFilterModel tableFilterModel : this.filters) {
                tableFilterModel.removeTableConfiguration(jTable);
            }
        }
        finally {
            this.write.unlock();
        }
    }
}

