/*
 * Decompiled with CFR 0.152.
 */
package ddb.util.magicmodel;

import ddb.util.magicmodel.ComponentRenderer;
import ddb.util.magicmodel.JButtonCellEditor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MagicTableModel
extends AbstractTableModel {
    public static final String UP_ICON_PATH = "images/1downarrow.png";
    public static final String DOWN_ICON_PATH = "images/1downarrow1.png";
    public static final String DELETE_ICON_PATH = "images/agt_action_fail.png";
    private static final Icon UP_ICON;
    private static final Icon DOWN_ICON;
    private static final Icon DELETE_ICON;
    private static final Insets BORDER;
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int DELETE = 2;
    List<List<Object>> data = new Vector<List<Object>>();
    List<JButton> up = new Vector<JButton>();
    List<JButton> down = new Vector<JButton>();
    List<JButton> delete = new Vector<JButton>();
    String[] columns;
    Class<?>[] clazzes;
    Predicate[] valid;
    List<Object> exemplar = null;

    public void setClasses(Class<?> ... classArray) {
        if (classArray.length != this.columns.length) {
            return;
        }
        this.clazzes = Arrays.copyOf(classArray, classArray.length);
    }

    public void setExemplar(Object ... objectArray) {
        this.setExemplar(Arrays.asList(objectArray));
    }

    public void setExemplar(List<Object> list) {
        if (list.size() != this.columns.length) {
            return;
        }
        this.exemplar = new Vector<Object>();
        for (Object object : list) {
            this.exemplar.add(object);
        }
    }

    public void setPredicate(Predicate ... predicateArray) {
        if (predicateArray.length != this.columns.length) {
            return;
        }
        this.valid = Arrays.copyOf(predicateArray, predicateArray.length);
    }

    public MagicTableModel(String ... stringArray) {
        this.columns = stringArray;
    }

    @Override
    public int getRowCount() {
        return this.data.size() + 1;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length + 3;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n < 0) {
            return null;
        }
        if (n == this.data.size()) {
            if (n2 <= this.columns.length) {
                return "";
            }
            return null;
        }
        if (n2 < this.columns.length) {
            return this.data.get(n).get(n2);
        }
        switch (n2 -= this.columns.length) {
            case 0: {
                if (n == 0) {
                    return null;
                }
                return this.up.get(n);
            }
            case 1: {
                if (n + 2 == this.getRowCount()) {
                    return null;
                }
                return this.down.get(n);
            }
            case 2: {
                if (n + 2 == this.getRowCount()) {
                    return null;
                }
                return this.delete.get(n);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n == this.data.size()) {
            return n2 < this.columns.length;
        }
        return true;
    }

    public static int getButtonWidth() {
        JButton jButton = new JButton(" + ");
        return jButton.getPreferredSize().width;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 >= this.columns.length) {
            return;
        }
        if (this.valid != null && !this.valid[n2].evaluate(object)) {
            return;
        }
        if (n == this.data.size()) {
            this.data.add(this.createEntry(n2, object));
            if (this.data.size() > this.up.size()) {
                this.up.add(this.addNewUp(this.up.size()));
            }
            if (this.data.size() > this.down.size()) {
                this.down.add(this.addNewDown(this.down.size()));
            }
            if (this.data.size() > this.delete.size()) {
                this.delete.add(this.addNewDelete(this.delete.size()));
            }
            this.fireTableRowsInserted(n + 1, n + 1);
        } else {
            this.data.get(n).set(n2, object);
        }
        this.fireTableRowsUpdated(n, n);
    }

    private List<Object> createEntry(int n, Object object) {
        Vector<Object> vector = new Vector<Object>();
        if (this.exemplar != null) {
            for (Object object2 : this.exemplar) {
                vector.add(object2);
            }
        } else {
            for (String string : this.columns) {
                vector.add("");
            }
        }
        vector.set(n, object);
        return vector;
    }

    void swap(int n, int n2) {
        List<Object> list = this.data.get(n);
        this.data.set(n, this.data.get(n2));
        this.data.set(n2, list);
        this.fireTableRowsUpdated(n, n2);
    }

    public void addData(Object ... objectArray) {
        int n = this.data.size();
        for (int i = 0; i < objectArray.length; ++i) {
            this.setValueAt(objectArray[i], n, i);
        }
    }

    private JButton addNewDelete(final int n) {
        JButton jButton = new JButton(DELETE_ICON);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MagicTableModel.this.deleteRow(n);
            }
        });
        jButton.setMargin(BORDER);
        return jButton;
    }

    private JButton addNewUp(final int n) {
        JButton jButton = new JButton(UP_ICON);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MagicTableModel.this.swap(n, n - 1);
            }
        });
        jButton.setMargin(BORDER);
        return jButton;
    }

    private JButton addNewDown(final int n) {
        JButton jButton = new JButton(DOWN_ICON);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MagicTableModel.this.swap(n, n + 1);
            }
        });
        jButton.setMargin(BORDER);
        return jButton;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n < this.columns.length) {
            if (this.clazzes != null) {
                return this.clazzes[n];
            }
            return String.class;
        }
        switch (n -= this.columns.length) {
            case 0: 
            case 1: 
            case 2: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int n) {
        if (n < this.columns.length) {
            return this.columns[n];
        }
        return "";
    }

    private void deleteRow(int n) {
        this.data.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public List<List<Object>> getValues() {
        return Collections.unmodifiableList(this.data);
    }

    public void customize(JTable jTable) {
        jTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        jTable.setDefaultRenderer(JButton.class, new ComponentRenderer(new DefaultTableCellRenderer()));
        jTable.setDefaultEditor(JButton.class, new JButtonCellEditor());
        this.setColumnWidth(jTable.getColumnModel().getColumn(this.columns.length + 0));
        this.setColumnWidth(jTable.getColumnModel().getColumn(this.columns.length + 1));
        this.setColumnWidth(jTable.getColumnModel().getColumn(this.columns.length + 2));
    }

    private void setColumnWidth(TableColumn tableColumn) {
        int n = MagicTableModel.getButtonWidth();
        tableColumn.setMaxWidth(n);
        tableColumn.setMinWidth(n);
    }

    static {
        BORDER = new Insets(0, 0, 0, 0);
        UP_ICON = new ImageIcon(ClassLoader.getSystemResource(UP_ICON_PATH));
        DOWN_ICON = new ImageIcon(ClassLoader.getSystemResource(DOWN_ICON_PATH));
        DELETE_ICON = new ImageIcon(ClassLoader.getSystemResource(DELETE_ICON_PATH));
    }
}

