/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import ddb.util.TableMap;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSorter
extends TableMap {
    public static final String upIcon = "images/up.png";
    public static final String downIcon = "images/down.png";
    int modelLength = 0;
    Integer[] indexes;
    boolean ascending = true;
    TableColumn storedColumn;
    Comparator<Object> compareBy;
    int sortingColumn = -1;
    private final ReentrantReadWriteLock Lock = new ReentrantReadWriteLock();

    private void readLock() {
        this.Lock.readLock().lock();
    }

    private void readUnlock() {
        this.Lock.readLock().unlock();
    }

    private void writeLock() {
        this.Lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.Lock.writeLock().unlock();
    }

    public TableSorter() {
        this.indexes = new Integer[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        this.readLock();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Integer[] integerArray = this.indexes;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = integerArray[i];
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.indexes[n2]);
            }
            System.out.println("Indices:  [" + stringBuilder.toString() + "]");
        }
        finally {
            this.readUnlock();
        }
    }

    public TableSorter(TableModel tableModel) {
        this.setModel(tableModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModel(TableModel tableModel) {
        this.writeLock();
        try {
            super.setModel(tableModel);
            this.modelLength = tableModel.getRowCount();
            this.reallocateIndexes();
        }
        finally {
            this.writeUnlock();
        }
        super.tableChanged(new TableModelEvent(this));
    }

    @Override
    public TableModel getModel() {
        return this.model;
    }

    public String toString() {
        return String.format("Table Sorter [%s]", this.model.toString());
    }

    public int compareRowsByColumn(int n, int n2, int n3) {
        if (n3 == -1) {
            return 0;
        }
        TableModel tableModel = this.model;
        Object object = tableModel.getValueAt(n, n3);
        Object object2 = tableModel.getValueAt(n2, n3);
        if (this.compareBy != null) {
            return this.compareBy.compare(object, object2);
        }
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof Comparable) {
            Comparable comparable = (Comparable)object;
            return comparable.compareTo(object2);
        }
        return object.toString().compareTo(object2.toString());
    }

    public int compare(int n, int n2) {
        int n3 = this.compareRowsByColumn(n, n2, this.sortingColumn);
        return this.ascending ? n3 : -n3;
    }

    public void reallocateIndexes() {
        this.indexes = new Integer[this.modelLength];
        for (int i = 0; i < this.modelLength; ++i) {
            this.indexes[i] = i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        this.readLock();
        try {
            int n = this.modelLength;
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.modelLength = this.model.getRowCount();
        this.writeLock();
        try {
            this.reallocateIndexes();
            if (this.sortingColumn != -1) {
                this.sort(null);
            }
        }
        finally {
            this.writeUnlock();
        }
        super.tableChanged(tableModelEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Object object) {
        this.writeLock();
        try {
            Arrays.sort(this.indexes, new Comparator<Integer>(){

                @Override
                public int compare(Integer n, Integer n2) {
                    int n3 = TableSorter.this.compareRowsByColumn(n, n2, TableSorter.this.sortingColumn);
                    if (n3 != 0) {
                        return TableSorter.this.ascending ? n3 : -n3;
                    }
                    return 0;
                }
            });
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n, int n2) {
        this.readLock();
        try {
            if (n >= this.indexes.length) {
                Object var3_3 = null;
                return var3_3;
            }
            Object object = this.model.getValueAt(this.convertViewRowToModel(n), n2);
            return object;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCellEditable(int n, int n2) {
        this.readLock();
        try {
            if (n >= this.indexes.length || n < 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.model.isCellEditable(this.convertViewRowToModel(n), n2);
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int convertViewRowToModel(int n) {
        this.readLock();
        try {
            if (n >= this.indexes.length || n < 0) {
                int n2 = -1;
                return n2;
            }
            int n3 = this.indexes[n];
            return n3;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.writeLock();
        try {
            if (n >= this.indexes.length) {
                return;
            }
            this.model.setValueAt(object, this.convertViewRowToModel(n), n2);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void sortByColumn(int n) {
        this.sortByColumn(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortByColumn(int n, boolean bl) {
        this.writeLock();
        try {
            this.ascending = bl;
            this.sortingColumn = n;
            this.sort(this);
        }
        finally {
            this.writeUnlock();
        }
        super.tableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final TableSorter tableSorter = this;
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() != 1) {
                    return;
                }
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = jTable2.columnAtPoint(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                TableSorter.this.setSortingColumn(tableColumnModel.getColumn(n), jTable2, tableSorter);
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    void setSortingColumn(TableColumn tableColumn, JTable jTable, TableSorter tableSorter) {
        Serializable serializable;
        if (this.storedColumn != null) {
            this.storedColumn.setHeaderRenderer(null);
        }
        if (tableColumn == null) {
            this.sortingColumn = -1;
            return;
        }
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        tableColumn.setHeaderRenderer(defaultTableCellRenderer);
        if (tableColumn == this.storedColumn) {
            boolean bl = this.ascending = !this.ascending;
            if (this.ascending) {
                this.setNoSort();
                this.storedColumn = null;
                return;
            }
        } else {
            this.storedColumn = tableColumn;
            this.ascending = true;
            serializable = new ImageIcon(this.getClass().getClassLoader().getResource(upIcon));
            defaultTableCellRenderer.setIcon((Icon)((Object)serializable));
        }
        if (this.ascending) {
            serializable = new ImageIcon(this.getClass().getClassLoader().getResource(downIcon));
            defaultTableCellRenderer.setIcon((Icon)((Object)serializable));
        } else {
            serializable = new ImageIcon(this.getClass().getClassLoader().getResource(upIcon));
            defaultTableCellRenderer.setIcon((Icon)((Object)serializable));
        }
        defaultTableCellRenderer.setIconTextGap(10);
        serializable = jTable.getSelectionBackground();
        Color color = jTable.getSelectionForeground();
        defaultTableCellRenderer.setBackground((Color)serializable);
        defaultTableCellRenderer.setForeground(color);
        defaultTableCellRenderer.setHorizontalAlignment(0);
        defaultTableCellRenderer.setHorizontalTextPosition(2);
        tableSorter.sortByColumn(this.storedColumn.getModelIndex(), this.ascending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoSort() {
        this.writeLock();
        try {
            this.setSortingColumn(null, null, null);
            this.reallocateIndexes();
        }
        finally {
            this.writeUnlock();
        }
        super.tableChanged(new TableModelEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComparator(Comparator<Object> comparator) {
        this.writeLock();
        try {
            this.compareBy = comparator;
            this.sort(null);
        }
        finally {
            this.writeUnlock();
        }
        super.tableChanged(new TableModelEvent(this));
    }
}

