/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnumeratedTableModel<E extends Enum<?>>
extends AbstractTableModel
implements TableModel {
    Class<E> columnsType;
    E[] EnumConstants;
    protected PublicObservable updateObservable = new PublicObservable();
    protected PublicObservable insertObservable = new PublicObservable();
    private boolean pendingDataChanged = false;

    public void addUpdateObserver(Observer observer) {
        this.updateObservable.addObserver(observer);
    }

    public void deleteUpdateObserver(Observer observer) {
        this.updateObservable.deleteObserver(observer);
    }

    public void addInsertObserver(Observer observer) {
        this.insertObservable.addObserver(observer);
    }

    public void deleteInsertObserver(Observer observer) {
        this.insertObservable.deleteObserver(observer);
    }

    public AbstractEnumeratedTableModel(Class<E> clazz) {
        this.columnsType = clazz;
        this.EnumConstants = (Enum[])clazz.getEnumConstants();
    }

    @Override
    public int getColumnCount() {
        return this.EnumConstants.length;
    }

    @Override
    public final Object getValueAt(int n, int n2) {
        return this.getValueAt(n, this.EnumConstants[n2]);
    }

    public void fireTableCellUpdated(int n, E e) {
        this.fireTableCellUpdated(n, (E)((Enum)e).ordinal());
    }

    @Override
    public final Class<?> getColumnClass(int n) {
        return this.getColumnClass(this.EnumConstants[n]);
    }

    @Override
    public final String getColumnName(int n) {
        return this.getColumnName(this.EnumConstants[n]);
    }

    public String getColumnName(E e) {
        return ((Enum)e).toString();
    }

    public Class<?> getColumnClass(E e) {
        return Object.class;
    }

    public abstract Object getValueAt(int var1, E var2);

    @Override
    public final boolean isCellEditable(int n, int n2) {
        return this.isCellEditable(n, this.EnumConstants[n2]);
    }

    public boolean isCellEditable(int n, E e) {
        return false;
    }

    @Override
    public final void setValueAt(Object object, int n, int n2) {
        this.setValueAt(object, n, this.EnumConstants[n2]);
    }

    public void setValueAt(Object object, int n, E e) {
    }

    private synchronized boolean isPendingDataChange() {
        return this.pendingDataChanged;
    }

    private synchronized void setPendingDataChange(boolean bl) {
        this.pendingDataChanged = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FireTableCellUpdated
    extends FireTableModification {
        int row;
        int column;

        public FireTableCellUpdated(int n, int n2) {
            super(TableModificationType.CellUpdated, true);
            this.row = n;
            this.column = n2;
        }

        public FireTableCellUpdated(int n, E e) {
            super(TableModificationType.CellUpdated, true);
            this.row = n;
            this.column = ((Enum)e).ordinal();
        }

        @Override
        protected final void runModification() {
            AbstractEnumeratedTableModel.this.fireTableCellUpdated(this.row, this.column);
        }
    }

    protected class FireTableStructureChanged
    extends FireTableModification {
        public FireTableStructureChanged() {
            super(TableModificationType.StructureChanged, true);
        }

        protected final void runModification() {
            AbstractEnumeratedTableModel.this.fireTableStructureChanged();
        }
    }

    protected class FireTableDataChanged
    extends FireTableModification {
        public FireTableDataChanged() {
            super(TableModificationType.DataChanged, false);
            if (AbstractEnumeratedTableModel.this.isPendingDataChange()) {
                this.voided = true;
            } else {
                AbstractEnumeratedTableModel.this.setPendingDataChange(true);
            }
        }

        protected final void runModification() {
            AbstractEnumeratedTableModel.this.setPendingDataChange(false);
            AbstractEnumeratedTableModel.this.fireTableDataChanged();
        }
    }

    protected class FireTableRowsDeleted
    extends FireTableModification {
        int i;
        int j;

        public FireTableRowsDeleted(int n, int n2) {
            super(TableModificationType.Deleted, true);
            this.i = n;
            this.j = n2;
        }

        protected final void runModification() {
            AbstractEnumeratedTableModel.this.fireTableRowsDeleted(this.i, this.j);
        }
    }

    protected class FireTableRowsInserted
    extends FireTableModification {
        int firstRow;
        int lastRow;

        public FireTableRowsInserted(int n, int n2) {
            super(TableModificationType.Inserted, true);
            this.firstRow = n;
            this.lastRow = n2;
        }

        protected final void runModification() {
            AbstractEnumeratedTableModel.this.fireTableRowsInserted(this.firstRow, this.lastRow);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FireTableRowsUpdated
    extends FireTableModification {
        int firstRow;
        int lastRow;

        public FireTableRowsUpdated(int n, int n2) {
            super(TableModificationType.Updated, true);
            this.firstRow = n;
            this.lastRow = n2;
        }

        @Override
        protected final void runModification() {
            AbstractEnumeratedTableModel.this.fireTableRowsUpdated(this.firstRow, this.lastRow);
        }

        @Override
        public int compareTo(FireTableModification fireTableModification) {
            if (this.getType() != fireTableModification.getType()) {
                return 0;
            }
            FireTableRowsUpdated fireTableRowsUpdated = (FireTableRowsUpdated)fireTableModification;
            if (this.firstRow < fireTableRowsUpdated.firstRow) {
                return -1;
            }
            if (this.firstRow > fireTableRowsUpdated.firstRow) {
                return 1;
            }
            if (this.lastRow < fireTableRowsUpdated.lastRow) {
                return -1;
            }
            if (this.lastRow > fireTableRowsUpdated.lastRow) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class FireTableModification
    implements Runnable,
    Comparable<FireTableModification> {
        private TableModificationType type;
        private final boolean voidable;
        protected boolean voided;

        protected FireTableModification(TableModificationType tableModificationType, boolean bl) {
            this.type = tableModificationType;
            this.voidable = bl;
            this.voided = bl && AbstractEnumeratedTableModel.this.isPendingDataChange();
        }

        public TableModificationType getType() {
            return this.type;
        }

        @Override
        public int compareTo(FireTableModification fireTableModification) {
            return 0;
        }

        @Override
        public final void run() {
            if (this.voidable && AbstractEnumeratedTableModel.this.isPendingDataChange() || this.voided) {
                return;
            }
            this.runModification();
        }

        protected abstract void runModification();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TableModificationType {
        Updated,
        Inserted,
        Deleted,
        CellUpdated,
        DataChanged,
        StructureChanged;

    }

    protected class PublicObservable
    extends Observable {
        protected PublicObservable() {
        }

        public void setChanged() {
            super.setChanged();
        }
    }
}

