/*
 * Decompiled with CFR 0.152.
 */
package ddb.gui.debugview;

import ddb.gui.debugview.OutputMessageColumns;
import ddb.util.tablefilter.DefaultTableFilter;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageTableFilter
extends DefaultTableFilter {
    private List<String> sections = new Vector<String>();
    private List<Integer> threads = new Vector<Integer>();
    int[] rowTranslation = new int[0];
    int size = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addString(String newString) {
        MessageTableFilter messageTableFilter = this;
        synchronized (messageTableFilter) {
            if (this.sections.contains(newString)) {
                return;
            }
            this.sections.add(newString);
        }
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeString(String oldString) {
        MessageTableFilter messageTableFilter = this;
        synchronized (messageTableFilter) {
            this.sections.remove(oldString);
        }
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        MessageTableFilter messageTableFilter = this;
        synchronized (messageTableFilter) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int translateViewLocationToModelRow(int row, int column) {
        MessageTableFilter messageTableFilter = this;
        synchronized (messageTableFilter) {
            return this.rowTranslation[row];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        MessageTableFilter messageTableFilter = this;
        synchronized (messageTableFilter) {
            this.size = 0;
            this.rowTranslation = new int[this.model.getRowCount()];
            for (int i = 0; i < this.rowTranslation.length; ++i) {
                String sec = this.model.getValueAt(i, OutputMessageColumns.SECTION.ordinal()).toString();
                if (this.sections.contains(sec)) {
                    this.rowTranslation[this.size++] = i;
                    continue;
                }
                Object o = this.model.getValueAt(i, OutputMessageColumns.THREAD.ordinal());
                if (!this.threads.contains(o)) continue;
                this.rowTranslation[this.size++] = i;
            }
        }
        this.fireTableDataChanged();
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        this.update();
    }

    public void tableChanged(TableModelEvent e) {
        if (e.getFirstRow() == -1 && e.getLastRow() == -1 && e.getColumn() == -1) {
            this.fireTableStructureChanged();
        } else {
            this.update();
        }
    }

    public void setThreads(List<Integer> newThreads) {
        this.threads = newThreads;
        this.update();
    }
}

