/*
 * Decompiled with CFR 0.152.
 */
package ddb.gui.debugview;

import ddb.gui.debugview.CalendarRenderer;
import ddb.gui.debugview.Importance;
import ddb.gui.debugview.ImportancePredicate;
import ddb.gui.debugview.MessageRecord;
import ddb.gui.debugview.MessageRecordDisplayModel;
import ddb.gui.debugview.MessageRecordImpl;
import ddb.gui.debugview.MutableMessageRecord;
import ddb.gui.debugview.OutputMessageColumns;
import ddb.predicate.PredicateClosure;
import ddb.predicate.PredicateClosureImpl;
import ddb.util.FrequentlyAppendedTableModel;
import ddb.util.checkedtablemodel.CheckableFilterList;
import ddb.util.checkedtablemodel.CheckedTableSelection;
import ddb.util.predicate.StringContainsPredicate;
import ddb.util.predicate.UnionListPredicate;
import ddb.util.tablefilter.FilteredTableModel;
import ddb.util.tablefilter.sample.ColumnHidingModel;
import ddb.writequeue.AbstractWritable;
import ddb.writequeue.Writable;
import ddb.writequeue.WriteQueue;
import ddb.writequeue.text.TextClear;
import ddb.writequeue.text.TextWrite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.ClosureUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.functors.SwitchClosure;
import org.jdesktop.layout.GroupLayout;

public class DebugView
extends JPanel {
    protected MutableMessageRecord lastRecord = null;
    MessageRecordDisplayModel recordModel = new MessageRecordDisplayModel();
    Importance minimumLevel = Importance.NOT_SET;
    CheckableFilterList<String> sectionFilterTable;
    final UnionListPredicate<String> sectionPredicate = new UnionListPredicate(false);
    final UnionListPredicate<Integer> threadPredicate = new UnionListPredicate(true);
    final ImportancePredicate importancePredicate = new ImportancePredicate();
    final StringContainsPredicate commentContainsPredicate = new StringContainsPredicate();
    ColumnHidingModel hideColumns = new ColumnHidingModel(OutputMessageColumns.class);
    FilteredTableModel filterModel = new FilteredTableModel((TableModel)((Object)this.recordModel));
    PredicateClosure[] closures = new PredicateClosure[]{new PredicateClosureImpl(PredicateUtils.instanceofPredicate(TextWriterImpl.class), new Closure(){

        public void execute(Object arg0) {
            TextWriterImpl twi = (TextWriterImpl)((Object)arg0);
            if (DebugView.this.showNewRaw.isSelected()) {
                DebugView.this.rawOutput.append(twi.getText());
                int lines = DebugView.this.rawOutput.getLineCount();
                int max = 25000;
                if (lines > max) {
                    int line = lines - max;
                    line += max * 3 / 10;
                    try {
                        DebugView.this.rawOutput.replaceRange("", 0, DebugView.this.rawOutput.getLineStartOffset(line));
                    }
                    catch (BadLocationException ex) {}
                }
            } else if (!DebugView.this.discardNewRaw.isSelected()) {
                DebugView.this.writeQueue.reque((Writable)twi);
            }
        }
    }), new PredicateClosureImpl(PredicateUtils.instanceofPredicate(TextClear.class), new Closure(){

        public void execute(Object arg0) {
            DebugView.this.rawOutput.setText("");
        }
    })};
    WriteQueue<AbstractWritable> writeQueue = new WriteQueue(SwitchClosure.getInstance((Predicate[])this.closures, (Closure[])this.closures, (Closure)ClosureUtils.nopClosure()), true);
    private JRadioButton DiscardNewMessages;
    private JPanel FancyView;
    private JRadioButton HoldNewMessages;
    private JRadioButton KeepAllMessages;
    private ButtonGroup PossibleMessageStates;
    private JRadioButton ShowNewMessages;
    private JPanel SimpleView;
    private JButton applyThreads;
    private JButton clearButton;
    private JButton clearSimpleView;
    private JTextArea details;
    private JScrollPane detailsScroller;
    private JRadioButton discardNewRaw;
    private JRadioButton discardNewRaw1;
    private JPanel filterPanel;
    private JRadioButton holdNewRaw;
    private JSplitPane mainSplit;
    private JTextField message;
    private JLabel messageLabel;
    private JTabbedPane outputDisplayMethod;
    private ButtonGroup rawMessageStates;
    private JTextArea rawOutput;
    private JPanel recordPanel;
    private JScrollPane recordScroll;
    private JTable recordTable;
    private JComboBox scopeChooser;
    private JPanel sectionPanel;
    private JRadioButton showNewRaw;
    private JScrollPane simpleScroll;
    private JLabel threadLabel;
    private JTextField threads;
    private JPanel topPanel;

    void setColumnWidth() {
        for (int column = 0; column < this.recordTable.getColumnModel().getColumnCount(); ++column) {
            TableColumn col = this.recordTable.getColumnModel().getColumn(column);
            for (OutputMessageColumns imp : OutputMessageColumns.values()) {
                if (!col.getHeaderValue().equals(imp.getColumnName()) || imp.getDefaultValue() == null) continue;
                this.setColumnWidth(col, imp.getDefaultValue(), false, imp.isBinding());
            }
        }
    }

    public void setMinimumLevel(Importance minLevel) {
        this.minimumLevel = minLevel;
    }

    public void setCurrentLevel(Importance minLevel) {
        this.scopeChooser.setSelectedItem((Object)minLevel);
    }

    public void setMaximum(int maximum) {
        this.recordModel.setMaximum(maximum);
    }

    public void append(final String text) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    DebugView.this.append(text);
                }
            });
            return;
        }
        MutableMessageRecord mr = MessageRecordImpl.ParseMessage(text);
        if (mr != null) {
            this.lastRecord = mr;
            if (this.sectionFilterTable.addElement((Object)mr.getSection(), true)) {
                this.sectionPredicate.addItem((Object)mr.getSection());
            }
            if (mr.getPriority().ordinal() >= this.minimumLevel.ordinal()) {
                this.recordModel.addRecord(mr);
            }
        } else if (this.lastRecord != null) {
            this.lastRecord.append(text);
        }
        this.writeQueue.enqueue((Writable)new TextWriterImpl(text));
    }

    public void addMessageRecord(MessageRecord newRecord) {
        if (newRecord.getPriority().ordinal() < this.minimumLevel.ordinal()) {
            return;
        }
        if (newRecord != null) {
            if (this.sectionFilterTable.addElement((Object)newRecord.getSection(), true)) {
                this.sectionPredicate.addItem((Object)newRecord.getSection());
            }
            this.recordModel.addRecord(newRecord);
        }
    }

    private void setColumnWidth(TableColumn column, String string, boolean icon, boolean binding) {
        JLabel label = new JLabel(string);
        int size = label.getPreferredSize().width;
        column.setPreferredWidth(size + 10);
        column.setWidth(size + 10);
        if (binding) {
            column.setMaxWidth(size + 15);
            column.setMinWidth(size + 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescan() {
        UnionListPredicate<Integer> unionListPredicate = this.threadPredicate;
        synchronized (unionListPredicate) {
            String list = this.threads.getText();
            String[] individuals = list.split(" ");
            this.threadPredicate.clear();
            for (int i = 0; i < individuals.length; ++i) {
                try {
                    this.threadPredicate.addItem((Object)Integer.valueOf(individuals[i]));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.filterModel.filterChanged();
        }
    }

    void doFilter() {
        this.commentContainsPredicate.setString(this.message.getText());
        this.filterModel.filterChanged();
    }

    public DebugView() {
        this.sectionFilterTable = new CheckableFilterList("Sections", (CheckedTableSelection)new CheckedTableCallback(), String.CASE_INSENSITIVE_ORDER);
        this.filterModel.addFilter((Predicate)this.importancePredicate, new Enum[]{OutputMessageColumns.PRIORITY});
        this.filterModel.addFilter(this.sectionPredicate, new Enum[]{OutputMessageColumns.SECTION});
        this.filterModel.addFilter(this.threadPredicate, new Enum[]{OutputMessageColumns.THREAD});
        this.filterModel.addFilter((Predicate)this.commentContainsPredicate, new Enum[]{OutputMessageColumns.MESSAGE});
        this.initComponents();
    }

    private void initComponents() {
        this.PossibleMessageStates = new ButtonGroup();
        this.rawMessageStates = new ButtonGroup();
        this.outputDisplayMethod = new JTabbedPane();
        this.FancyView = new JPanel();
        this.mainSplit = new JSplitPane();
        this.detailsScroller = new JScrollPane();
        this.details = new JTextArea();
        this.topPanel = new JPanel();
        this.filterPanel = new JPanel();
        this.messageLabel = new JLabel();
        this.threadLabel = new JLabel();
        this.message = new JTextField();
        this.threads = new JTextField();
        this.applyThreads = new JButton();
        this.sectionPanel = new JPanel();
        this.DiscardNewMessages = new JRadioButton();
        this.HoldNewMessages = new JRadioButton();
        this.ShowNewMessages = new JRadioButton();
        this.KeepAllMessages = new JRadioButton();
        this.recordPanel = new JPanel();
        this.recordScroll = new JScrollPane();
        this.recordTable = new JTable();
        this.clearButton = new JButton();
        this.scopeChooser = new JComboBox();
        this.SimpleView = new JPanel();
        this.simpleScroll = new JScrollPane();
        this.rawOutput = new JTextArea();
        this.clearSimpleView = new JButton();
        this.showNewRaw = new JRadioButton();
        this.holdNewRaw = new JRadioButton();
        this.discardNewRaw = new JRadioButton();
        this.discardNewRaw1 = new JRadioButton();
        this.mainSplit.setDividerLocation(275);
        this.mainSplit.setOrientation(0);
        this.mainSplit.setResizeWeight(0.8);
        this.details.setColumns(20);
        this.details.setRows(5);
        this.detailsScroller.setViewportView(this.details);
        this.mainSplit.setRightComponent(this.detailsScroller);
        this.messageLabel.setText("Message:");
        this.threadLabel.setText("Threads:");
        this.message.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                DebugView.this.messageKeyReleased(evt);
            }
        });
        this.applyThreads.setText("Apply");
        this.applyThreads.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DebugView.this.applyThreadsActionPerformed(evt);
            }
        });
        GroupLayout sectionPanelLayout = new GroupLayout((Container)this.sectionPanel);
        this.sectionPanel.setLayout((LayoutManager)sectionPanelLayout);
        sectionPanelLayout.setHorizontalGroup((GroupLayout.Group)sectionPanelLayout.createParallelGroup(1).add(0, 238, Short.MAX_VALUE));
        sectionPanelLayout.setVerticalGroup((GroupLayout.Group)sectionPanelLayout.createParallelGroup(1).add(0, 113, Short.MAX_VALUE));
        this.PossibleMessageStates.add(this.DiscardNewMessages);
        this.DiscardNewMessages.setText("Discard New Messages");
        this.DiscardNewMessages.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.DiscardNewMessages.setMargin(new Insets(0, 0, 0, 0));
        this.DiscardNewMessages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DebugView.this.filterMessages(evt);
            }
        });
        this.PossibleMessageStates.add(this.HoldNewMessages);
        this.HoldNewMessages.setText("Hold New Messages");
        this.HoldNewMessages.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.HoldNewMessages.setMargin(new Insets(0, 0, 0, 0));
        this.HoldNewMessages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DebugView.this.filterMessages(evt);
            }
        });
        this.PossibleMessageStates.add(this.ShowNewMessages);
        this.ShowNewMessages.setSelected(true);
        this.ShowNewMessages.setText("Show New Messages");
        this.ShowNewMessages.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ShowNewMessages.setMargin(new Insets(0, 0, 0, 0));
        this.ShowNewMessages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DebugView.this.filterMessages(evt);
            }
        });
        this.PossibleMessageStates.add(this.KeepAllMessages);
        this.KeepAllMessages.setText("Keep All Messages");
        this.KeepAllMessages.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.KeepAllMessages.setMargin(new Insets(0, 0, 0, 0));
        this.KeepAllMessages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DebugView.this.filterMessages(evt);
            }
        });
        GroupLayout filterPanelLayout = new GroupLayout((Container)this.filterPanel);
        this.filterPanel.setLayout((LayoutManager)filterPanelLayout);
        filterPanelLayout.setHorizontalGroup((GroupLayout.Group)filterPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)filterPanelLayout.createSequentialGroup().add((GroupLayout.Group)filterPanelLayout.createParallelGroup(2).add((Component)this.sectionPanel, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)filterPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)filterPanelLayout.createParallelGroup(1).add((Component)this.ShowNewMessages, -1, 228, Short.MAX_VALUE).add((Component)this.HoldNewMessages, -1, 228, Short.MAX_VALUE).add((Component)this.DiscardNewMessages, -1, 228, Short.MAX_VALUE).add((Component)this.KeepAllMessages, -1, 228, Short.MAX_VALUE))).add(1, (GroupLayout.Group)filterPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)filterPanelLayout.createParallelGroup(2).add((GroupLayout.Group)filterPanelLayout.createSequentialGroup().add((Component)this.threadLabel).add(7, 7, 7)).add((Component)this.messageLabel)).addPreferredGap(0).add((GroupLayout.Group)filterPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)filterPanelLayout.createSequentialGroup().add((Component)this.threads, -1, 107, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.applyThreads)).add((Component)this.message, -1, 174, Short.MAX_VALUE)))).addContainerGap()));
        filterPanelLayout.setVerticalGroup((GroupLayout.Group)filterPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)filterPanelLayout.createSequentialGroup().add((Component)this.sectionPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)filterPanelLayout.createParallelGroup(2).add((GroupLayout.Group)filterPanelLayout.createSequentialGroup().add((Component)this.threadLabel).add(9, 9, 9)).add((GroupLayout.Group)filterPanelLayout.createSequentialGroup().add((GroupLayout.Group)filterPanelLayout.createParallelGroup(3).add((Component)this.applyThreads).add((Component)this.threads, -2, -1, -2)).addPreferredGap(0))).add((GroupLayout.Group)filterPanelLayout.createParallelGroup(3).add((Component)this.messageLabel).add((Component)this.message, -2, -1, -2)).addPreferredGap(0).add((Component)this.ShowNewMessages).addPreferredGap(0).add((Component)this.HoldNewMessages).addPreferredGap(0).add((Component)this.DiscardNewMessages).addPreferredGap(0).add((Component)this.KeepAllMessages).add(11, 11, 11)));
        this.sectionPanel.setLayout(new BorderLayout());
        this.sectionPanel.add((Component)this.sectionFilterTable, "Center");
        this.recordPanel.setBorder(BorderFactory.createTitledBorder("Output Messages"));
        this.recordTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.recordTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                try {
                    DebugView.this.details.setText(DebugView.this.recordModel.getValueAt(DebugView.this.filterModel.translateViewLocationToModelRow(DebugView.this.recordTable.getSelectedRow(), 0), OutputMessageColumns.MESSAGE).toString());
                }
                catch (Exception e2) {
                    DebugView.this.details.setText("");
                }
            }
        });
        this.recordScroll.setViewportView(this.recordTable);
        this.recordTable.setColumnModel((TableColumnModel)this.hideColumns);
        this.recordTable.setModel((TableModel)this.filterModel);
        this.hideColumns.applyToTable(this.recordTable);
        this.recordTable.setDefaultRenderer(Calendar.class, (TableCellRenderer)((Object)new CalendarRenderer()));
        this.hideColumns.hide((Enum)OutputMessageColumns.TIME);
        this.setColumnWidth();
        GroupLayout recordPanelLayout = new GroupLayout((Container)this.recordPanel);
        this.recordPanel.setLayout((LayoutManager)recordPanelLayout);
        recordPanelLayout.setHorizontalGroup((GroupLayout.Group)recordPanelLayout.createParallelGroup(1).add((Component)this.recordScroll, -1, 368, Short.MAX_VALUE));
        recordPanelLayout.setVerticalGroup((GroupLayout.Group)recordPanelLayout.createParallelGroup(1).add((Component)this.recordScroll, -1, 248, Short.MAX_VALUE));
        GroupLayout topPanelLayout = new GroupLayout((Container)this.topPanel);
        this.topPanel.setLayout((LayoutManager)topPanelLayout);
        topPanelLayout.setHorizontalGroup((GroupLayout.Group)topPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)topPanelLayout.createSequentialGroup().add((Component)this.recordPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.filterPanel, -2, -1, -2)));
        topPanelLayout.setVerticalGroup((GroupLayout.Group)topPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)topPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.filterPanel, -1, -1, Short.MAX_VALUE)).add(2, (Component)this.recordPanel, -1, -1, Short.MAX_VALUE));
        this.mainSplit.setLeftComponent(this.topPanel);
        this.clearButton.setText("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DebugView.this.clearButtonActionPerformed(evt);
            }
        });
        for (Importance imp : Importance.values()) {
            this.scopeChooser.addItem(imp);
        }
        this.scopeChooser.setSelectedItem((Object)this.importancePredicate.getImportance());
        this.scopeChooser.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DebugView.this.scopeChooserItemStateChanged(evt);
            }
        });
        GroupLayout FancyViewLayout = new GroupLayout((Container)this.FancyView);
        this.FancyView.setLayout((LayoutManager)FancyViewLayout);
        FancyViewLayout.setHorizontalGroup((GroupLayout.Group)FancyViewLayout.createParallelGroup(1).add((GroupLayout.Group)FancyViewLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)FancyViewLayout.createParallelGroup(1).add(2, (GroupLayout.Group)FancyViewLayout.createSequentialGroup().add((Component)this.scopeChooser, 0, 571, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.clearButton)).add(2, (Component)this.mainSplit, -1, 636, Short.MAX_VALUE)).addContainerGap()));
        FancyViewLayout.setVerticalGroup((GroupLayout.Group)FancyViewLayout.createParallelGroup(1).add((GroupLayout.Group)FancyViewLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)FancyViewLayout.createParallelGroup(3).add((Component)this.clearButton).add((Component)this.scopeChooser, -2, -1, -2)).addPreferredGap(0).add((Component)this.mainSplit, -1, 499, Short.MAX_VALUE).addContainerGap()));
        this.outputDisplayMethod.addTab("Formatted Output", this.FancyView);
        this.rawOutput.setColumns(20);
        this.rawOutput.setEditable(false);
        this.rawOutput.setRows(5);
        this.simpleScroll.setViewportView(this.rawOutput);
        this.clearSimpleView.setText("Clear");
        this.clearSimpleView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DebugView.this.clearSimpleViewActionPerformed(evt);
            }
        });
        this.rawMessageStates.add(this.showNewRaw);
        this.showNewRaw.setSelected(true);
        this.showNewRaw.setText("Show New Messages");
        this.showNewRaw.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DebugView.this.filterRawMessages(evt);
            }
        });
        this.rawMessageStates.add(this.holdNewRaw);
        this.holdNewRaw.setText("Hold New Messages");
        this.holdNewRaw.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DebugView.this.filterRawMessages(evt);
            }
        });
        this.rawMessageStates.add(this.discardNewRaw);
        this.discardNewRaw.setText("Discard New Messages");
        this.discardNewRaw.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DebugView.this.filterRawMessages(evt);
            }
        });
        this.rawMessageStates.add(this.discardNewRaw1);
        this.discardNewRaw1.setText("Keep All Messages");
        this.discardNewRaw1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DebugView.this.filterRawMessages(evt);
            }
        });
        GroupLayout SimpleViewLayout = new GroupLayout((Container)this.SimpleView);
        this.SimpleView.setLayout((LayoutManager)SimpleViewLayout);
        SimpleViewLayout.setHorizontalGroup((GroupLayout.Group)SimpleViewLayout.createParallelGroup(1).add((GroupLayout.Group)SimpleViewLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)SimpleViewLayout.createParallelGroup(1).add((Component)this.simpleScroll, -1, 636, Short.MAX_VALUE).add((GroupLayout.Group)SimpleViewLayout.createSequentialGroup().add((Component)this.showNewRaw).addPreferredGap(0).add((Component)this.holdNewRaw).addPreferredGap(0).add((Component)this.discardNewRaw).addPreferredGap(0).add((Component)this.discardNewRaw1).addPreferredGap(0, 83, Short.MAX_VALUE).add((Component)this.clearSimpleView))).addContainerGap()));
        SimpleViewLayout.setVerticalGroup((GroupLayout.Group)SimpleViewLayout.createParallelGroup(1).add(2, (GroupLayout.Group)SimpleViewLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)SimpleViewLayout.createParallelGroup(1).add((GroupLayout.Group)SimpleViewLayout.createParallelGroup(3).add((Component)this.showNewRaw).add((Component)this.holdNewRaw).add((Component)this.discardNewRaw).add((Component)this.clearSimpleView)).add((Component)this.discardNewRaw1)).addPreferredGap(0).add((Component)this.simpleScroll, -1, 499, Short.MAX_VALUE).addContainerGap()));
        this.outputDisplayMethod.addTab("Raw Output", this.SimpleView);
        this.outputDisplayMethod.setSelectedIndex(1);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.outputDisplayMethod, -1, 661, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.outputDisplayMethod, -1, 575, Short.MAX_VALUE));
    }

    private void filterMessages(ActionEvent evt) {
        if (this.ShowNewMessages.isSelected()) {
            this.recordModel.setRecordState(FrequentlyAppendedTableModel.RecordState.SHOW);
        }
        if (this.KeepAllMessages.isSelected()) {
            this.recordModel.setRecordState(FrequentlyAppendedTableModel.RecordState.KEEP);
        }
        if (this.DiscardNewMessages.isSelected()) {
            this.recordModel.setRecordState(FrequentlyAppendedTableModel.RecordState.DISCARD);
        }
        if (this.HoldNewMessages.isSelected()) {
            this.recordModel.setRecordState(FrequentlyAppendedTableModel.RecordState.HOLD);
        }
    }

    private void scopeChooserItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 1) {
            return;
        }
        Object o = evt.getItem();
        if (o instanceof Importance) {
            Importance imp = (Importance)((Object)Importance.class.cast(o));
            if (imp != null) {
                this.importancePredicate.setImportance(imp);
                this.filterModel.filterChanged();
            }
            if (this.minimumLevel.ordinal() > imp.ordinal()) {
                this.minimumLevel = imp;
            }
        }
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.recordModel.clear();
    }

    private void applyThreadsActionPerformed(ActionEvent evt) {
        this.rescan();
    }

    private void messageKeyReleased(KeyEvent evt) {
        this.doFilter();
    }

    private void clearSimpleViewActionPerformed(ActionEvent evt) {
        this.writeQueue.enqueue((Writable)new TextClear());
    }

    private void filterRawMessages(ActionEvent evt) {
    }

    public void clear() {
        this.recordModel.clear();
    }

    class TextWriterImpl
    extends TextWrite {
        public TextWriterImpl(String text) {
            super(text);
        }

        public boolean combine(Writable second) {
            if (second instanceof TextWriterImpl) {
                TextWriterImpl twi = (TextWriterImpl)second;
                this.sb.append(twi.getText());
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageState {
        SHOW,
        HOLD,
        DISCARD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CheckedTableCallback
    implements CheckedTableSelection<String> {
        private CheckedTableCallback() {
        }

        public void selected(String caption, boolean selected) {
            if (selected) {
                DebugView.this.sectionPredicate.addItem((Object)caption.toString());
            } else {
                DebugView.this.sectionPredicate.removeItem((Object)caption.toString());
            }
            DebugView.this.filterModel.filterChanged();
        }
    }
}

