/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.appconsole;

import ddb.antialiasing.AntialiasedTextField;
import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszHideable;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.annotations.DszUserStartable;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.connection.ConnectionChangeEvent;
import ddb.dsz.plugin.AbstractPlugin;
import ddb.dsz.plugin.NoHostAbstractPlugin;
import ddb.gui.debugview.DebugView;
import ddb.gui.debugview.Importance;
import ddb.gui.debugview.MessageRecord;
import ddb.gui.debugview.MessageRecordImpl;
import ddb.util.StreamDumper;
import ddb.util.StringAppender;
import ds.core.DSConstants;
import ds.core.controller.MutableCoreController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DszLive(live=true, replay=false)
@DszLogo(value="images/gnome-applications.png")
@DszName(value="Implant Console")
@DszDescription(value="An output screen for stdout and stderr of the implant application")
@DszUserStartable(value=false)
@DszHideable(hide=false, unhide=true)
public class ImplantConsole
extends NoHostAbstractPlugin
implements StringAppender {
    protected DebugView debugView;
    protected JPanel mainPanel;
    protected JTextField commandLine;
    protected InputStream stdOut;
    protected InputStream stdErr;
    protected StreamDumper dumper;
    protected boolean commandRunning;
    protected Process runningProcess;
    private File screenLog;
    private OutputStreamWriter screenLogWriter;
    protected static int BUFFER_SIZE = 500;
    protected int currentBufferFill = 0;
    protected StringBuffer sb;
    boolean establishedConnection = false;
    MutableCoreController mcc = null;
    String command = null;
    List<String> arguments = new Vector<String>();

    public ImplantConsole() {
        this.prefferedSize = new Dimension(1000, 350);
        super.setCanClose(false);
    }

    private void attachStreams(InputStream inputStream, InputStream inputStream2) {
        this.stdOut = inputStream;
        this.stdErr = inputStream2;
        this.dumper = new StreamDumper(this.stdOut, this.stdErr, (StringAppender)this, this.core.getSystemLogger());
        this.dumper.start((ThreadFactory)this.core);
    }

    public boolean startCommand() {
        if (this.command == null) {
            this.core.logEvent(Level.SEVERE, "Command not provided!");
            return false;
        }
        try {
            String[] stringArray = new String[]{"Path", "PATH", "LD_LIBRARY_PATH"};
            File file = new File(this.core.getLogDirectory());
            this.core.logEvent(Level.INFO, "Starting '" + this.command + "' in " + file.getAbsolutePath());
            this.runningProcess = null;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(new File(String.format("%s/%s", this.core.getResourceDirectory(), "../Bin")).getAbsolutePath());
            stringBuilder.append(";");
            stringBuilder.append(new File(String.format("%s/ExternalLibraries/%s", this.core.getResourceDirectory(), DSConstants.getOsString())).getAbsolutePath());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ImplantConsole.this.commandLine.setText(ImplantConsole.this.command);
                }
            });
            try {
                Vector<String> vector = new Vector<String>();
                vector.add(this.command);
                vector.addAll(this.arguments);
                ProcessBuilder processBuilder = new ProcessBuilder(vector);
                Map<String, String> map = processBuilder.environment();
                for (String string : stringArray) {
                    if (map.get(string) == null) continue;
                    map.put(string, String.format("%s;%s", map.get(string), stringBuilder.toString()));
                }
                map.put("DSZ_LP_ENV_RES_DIR_LOCATION", new File(this.core.getResourceDirectory()).getAbsolutePath());
                map.put("DSZ_LP_ENV_LOG_DIR_LOCATION", new File(this.core.getLogDirectory()).getAbsolutePath());
                map.put("DSZ_LP_ENV_CFG_DIR_LOCATION", new File(this.core.getUserConfigDirectory()).getAbsolutePath());
                map.put("DSZ_LP_ENV_OPS_DIR_LOCATION", new File(this.core.getOpDir()).getAbsolutePath());
                map.put("DSZ_LP_ENV_DISPATCHER_PORT", String.format("%d", this.core.getDispatcherPort()));
                map.put("DSZ_LP_ENV_LOCAL_HOST", this.core.getLocalhostAddress());
                map.put("PYTHONOPTIMIZE", "TRUE");
                processBuilder.directory(file);
                this.runningProcess = processBuilder.start();
            }
            catch (IOException iOException) {
                this.core.logEvent(Level.SEVERE, iOException.getMessage(), (Throwable)iOException);
                return false;
            }
            if (this.runningProcess == null) {
                this.core.logEvent(Level.SEVERE, "ImplantConsole failed to start command: " + this.command);
                System.err.println("ImplantConsole failed to start command: " + this.command);
                return false;
            }
            this.attachStreams(this.runningProcess.getInputStream(), this.runningProcess.getErrorStream());
            this.commandRunning = true;
            this.core.schedule(new Runnable(){

                public void run() {
                    try {
                        ImplantConsole.this.runningProcess.exitValue();
                        if (ImplantConsole.this.mcc != null) {
                            ImplantConsole.this.mcc.applicationEnded(ImplantConsole.this.command);
                        } else {
                            System.out.println("AppConsole exit");
                            JOptionPane.showMessageDialog(((AbstractPlugin)ImplantConsole.this).parentDisplay, "Command " + ImplantConsole.this.command + " prematurely terminated.\nYou can expect no more output.", "Command terminated", 2);
                        }
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        ImplantConsole.this.core.schedule((Runnable)this, 1L, TimeUnit.SECONDS);
                    }
                }
            }, 1L, TimeUnit.SECONDS);
            return true;
        }
        catch (Exception exception) {
            this.core.logEvent(Level.SEVERE, "Command start failed", (Throwable)exception);
            return false;
        }
    }

    public void stopProcess() {
        if (this.runningProcess == null) {
            return;
        }
        if (this.establishedConnection) {
            try {
                int n = this.runningProcess.waitFor();
                this.core.logEvent(Level.INFO, "Lp exited with value " + n);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            this.core.logEvent(Level.SEVERE, "Lp was never connected - destroying it");
            this.runningProcess.destroy();
        }
    }

    public void connectionChanged(ConnectionChangeEvent connectionChangeEvent) {
        this.establishedConnection = true;
    }

    protected final void fini2() {
        this.stopProcess();
        try {
            this.screenLogWriter.flush();
            this.screenLogWriter.close();
        }
        catch (IOException iOException) {
            this.core.logEvent(Level.WARNING, "Exception caught while closing " + this.screenLog.getName() + ": " + iOException.getMessage(), (Throwable)iOException);
        }
    }

    protected int init2() {
        if (this.core instanceof MutableCoreController) {
            this.mcc = (MutableCoreController)MutableCoreController.class.cast(this.core);
        }
        this.debugView = new DebugView();
        boolean bl = true;
        if (this.core.getBuildType().toLowerCase().startsWith("release")) {
            bl = false;
        }
        this.debugView.setCurrentLevel(bl ? Importance.INFO : Importance.WARNING);
        this.debugView.setMinimumLevel(Importance.NOT_SET);
        this.commandLine = new AntialiasedTextField();
        this.commandLine.setEditable(false);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)this.debugView, "Center");
        this.mainPanel.add((Component)this.commandLine, "North");
        super.setDisplay((JComponent)this.mainPanel);
        this.setupScreenLog();
        return 0;
    }

    protected int postParseArguments() {
        this.core.newThread("AppConsole Start Thread", new Runnable(){

            public void run() {
                if (!ImplantConsole.this.startCommand()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unable to start comamnd:\n");
                    stringBuilder.append(String.format("\tCommand = '%s'\n", ImplantConsole.this.command));
                    if (ImplantConsole.this.arguments != null) {
                        for (String string : ImplantConsole.this.arguments) {
                            stringBuilder.append(String.format("\t\t'%s'\n", string));
                        }
                    }
                    ImplantConsole.this.core.logEvent(Level.SEVERE, stringBuilder.toString());
                }
            }
        }).start();
        return super.postParseArguments();
    }

    protected final boolean parseArgument2(String string, String string2) {
        this.core.logEvent(Level.FINER, String.format("Parsing arguments:  %s=%s", string, string2));
        if (string.equalsIgnoreCase("-exe") && string2 != null) {
            this.command = string2;
            return true;
        }
        if (string.equalsIgnoreCase("-arg") && string2 != null) {
            this.arguments.add(string2);
            return true;
        }
        if (string.equalsIgnoreCase("-max") && string2 != null) {
            try {
                this.debugView.setMaximum(Integer.parseInt(string2));
                return true;
            }
            catch (Exception exception) {
                this.core.logEvent(Level.SEVERE, "AppConsole", "Invalid parameter in AppConsole: \n" + string2, (Throwable)exception);
                return false;
            }
        }
        return false;
    }

    private void setupScreenLog() {
        this.screenLog = this.core.createLogFile("LpConsole");
        try {
            this.screenLogWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.screenLog), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.core.logEvent(Level.WARNING, "UnsupportedEncodingException caught while creating UTF-8 screen log\nUsing default encoding instead", (Throwable)unsupportedEncodingException);
            try {
                this.screenLogWriter = new FileWriter(this.screenLog);
            }
            catch (IOException iOException) {
                this.core.logEvent(Level.SEVERE, "Exception caught while setting up logfile: " + iOException.getMessage(), (Throwable)iOException);
                this.core.logEvent(Level.SEVERE, "LP console window will not be logged", (Throwable)iOException);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.core.logEvent(Level.SEVERE, "Exception caught while setting up logfile: " + fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
            this.core.logEvent(Level.SEVERE, "LP console window will not be logged", (Throwable)fileNotFoundException);
        }
    }

    public void append(String string) {
        try {
            this.screenLogWriter.write(string);
            this.screenLogWriter.flush();
        }
        catch (IOException iOException) {
            this.core.logEvent(Level.SEVERE, "Exception caught while writing to screen log", (Throwable)iOException);
            this.core.logEvent(Level.SEVERE, "Unlogged text: " + string);
        }
        this.debugView.append(string);
    }

    public boolean allowNewInstance(Class<?> clazz) {
        return !((Object)((Object)this)).getClass().equals(clazz);
    }

    public void commandEventReceived(CommandEvent commandEvent) {
        super.commandEventReceived(commandEvent);
        if (commandEvent.getId().getId() == 0) {
            MessageRecordImpl messageRecordImpl = new MessageRecordImpl();
            if (commandEvent.getText().length() == 0) {
                messageRecordImpl.setMessage(commandEvent.getType().toString());
            } else {
                messageRecordImpl.setMessage(commandEvent.getText());
            }
            messageRecordImpl.setPriority(Importance.INFO);
            messageRecordImpl.setSection("Command-Zero");
            messageRecordImpl.setThread(Long.valueOf(Thread.currentThread().getId()).intValue());
            this.debugView.addMessageRecord((MessageRecord)messageRecordImpl);
        }
    }

    public static void main(String[] stringArray) throws Throwable {
        Class<?> clazz = Class.forName("ds.plugin.live.DSClientApp");
        Class<?> clazz2 = Class.forName("ds.plugin.replay.OpReplayDriver");
        Method method = clazz.getMethod("main", stringArray.getClass());
        method.invoke(null, new Object[]{stringArray});
    }
}

