/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.tags.Tag;
import com.jpexs.asdec.types.CXFORM;
import com.jpexs.asdec.types.MATRIX;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class PlaceObjectTag
extends Tag {
    public int characterId;
    public int depth;
    public MATRIX matrix;
    public CXFORM colorTransform;

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            sos.writeUI16(this.characterId);
            sos.writeUI16(this.depth);
            sos.writeMatrix(this.matrix);
            if (this.colorTransform != null) {
                sos.writeCXFORM(this.colorTransform);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public PlaceObjectTag(byte[] data, int version, long pos) throws IOException {
        super(4, "PlaceObject", data, pos);
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.characterId = sis.readUI16();
        this.depth = sis.readUI16();
        this.matrix = sis.readMatrix();
        if (sis.available() > 0) {
            this.colorTransform = sis.readCXFORM();
        }
    }

    public PlaceObjectTag(int characterId, int depth, MATRIX matrix, CXFORM colorTransform) {
        super(4, "PlaceObject", new byte[0], 0L);
        this.characterId = characterId;
        this.depth = depth;
        this.matrix = matrix;
        this.colorTransform = colorTransform;
    }

    @Override
    public Set<Integer> getNeededCharacters() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.add(this.characterId);
        return ret;
    }
}

