/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.tags.base.ASMSource;
import com.jpexs.asdec.tags.base.CharacterTag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DoInitActionTag
extends CharacterTag
implements ASMSource {
    public int spriteId = 0;
    public byte[] actionBytes;

    public DoInitActionTag(byte[] data, int version, long pos) throws IOException {
        super(59, "DoInitAction", data, pos);
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.spriteId = sis.readUI16();
        this.actionBytes = sis.readBytes(sis.available());
    }

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(baos, version);
        try {
            sos.writeUI16(this.spriteId);
            sos.write(this.actionBytes);
            sos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    @Override
    public boolean containsSource() {
        return true;
    }

    @Override
    public String getASMSource(int version) {
        List<Action> actions = new ArrayList<Action>();
        try {
            actions = new SWFInputStream(new ByteArrayInputStream(this.actionBytes), version).readActionList();
        }
        catch (IOException ex) {
            Logger.getLogger(DoInitActionTag.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Action.actionsToString(actions, null, version);
    }

    @Override
    public List<Action> getActions(int version) {
        try {
            return new SWFInputStream(new ByteArrayInputStream(this.actionBytes), version).readActionList();
        }
        catch (IOException ex) {
            Logger.getLogger(DoInitActionTag.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<Action>();
        }
    }

    @Override
    public void setActions(List<Action> actions, int version) {
        this.actionBytes = Action.actionsToBytes(actions, true, version);
    }

    @Override
    public byte[] getActionBytes() {
        return this.actionBytes;
    }

    @Override
    public void setActionBytes(byte[] actionBytes) {
        this.actionBytes = actionBytes;
    }

    @Override
    public int getCharacterID() {
        return this.spriteId;
    }
}

