/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.tags.base.CharacterTag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DefineSoundTag
extends CharacterTag {
    public int soundId;
    public int soundFormat;
    public static final int FORMAT_UNCOMPRESSED_NATIVE_ENDIAN = 0;
    public static final int FORMAT_ADPCM = 1;
    public static final int FORMAT_MP3 = 2;
    public static final int FORMAT_UNCOMPRESSED_LITTLE_ENDIAN = 3;
    public static final int FORMAT_NELLYMOSER16KHZ = 4;
    public static final int FORMAT_NELLYMOSER8KHZ = 5;
    public static final int FORMAT_NELLYMOSER = 6;
    public static final int FORMAT_SPEEX = 11;
    public int soundRate;
    public boolean soundType;
    public long soundSampleCount;
    public byte[] soundData;

    @Override
    public int getCharacterID() {
        return this.soundId;
    }

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            sos.writeUI16(this.soundId);
            sos.writeUB(4, this.soundFormat);
            sos.writeUB(2, this.soundRate);
            sos.writeUB(1, this.soundType ? 1L : 0L);
            sos.writeUI32(this.soundSampleCount);
            sos.write(this.soundData);
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public DefineSoundTag(byte[] data, int version, long pos) throws IOException {
        super(14, "DefineSound", data, pos);
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.soundId = sis.readUI16();
        this.soundFormat = (int)sis.readUB(4);
        this.soundRate = (int)sis.readUB(2);
        this.soundType = sis.readUB(1) == 1L;
        this.soundSampleCount = sis.readUI32();
        this.soundData = sis.readBytes(sis.available());
    }
}

