/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.tags.base.CharacterTag;
import com.jpexs.asdec.tags.base.FontTag;
import com.jpexs.asdec.types.SHAPE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DefineFontTag
extends CharacterTag
implements FontTag {
    public int fontId;
    public int[] offsetTable;
    public SHAPE[] glyphShapeTable;

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            sos.writeUI16(this.fontId);
            for (int offset : this.offsetTable) {
                sos.writeUI16(offset);
            }
            for (SHAPE shape : this.glyphShapeTable) {
                sos.writeSHAPE(shape, 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public DefineFontTag(byte[] data, int version, long pos) throws IOException {
        super(10, "DefineFont", data, pos);
        int i;
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.fontId = sis.readUI16();
        int firstOffset = sis.readUI16();
        int nGlyphs = firstOffset / 2;
        this.offsetTable = new int[nGlyphs];
        this.glyphShapeTable = new SHAPE[nGlyphs];
        this.offsetTable[0] = firstOffset;
        for (i = 1; i < nGlyphs; ++i) {
            this.offsetTable[i] = sis.readUI16();
        }
        for (i = 0; i < nGlyphs; ++i) {
            this.glyphShapeTable[i] = sis.readSHAPE(1);
        }
    }

    @Override
    public int getFontId() {
        return this.fontId;
    }

    @Override
    public SHAPE[] getGlyphShapeTable() {
        return this.glyphShapeTable;
    }

    @Override
    public int getCharacterID() {
        return this.fontId;
    }
}

