/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.tags.Tag;
import com.jpexs.asdec.types.LANGCODE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DefineFontInfo2Tag
extends Tag {
    public int fontID;
    public String fontName;
    public boolean fontFlagsSmallText;
    public boolean fontFlagsShiftJIS;
    public boolean fontFlagsANSI;
    public boolean fontFlagsItalic;
    public boolean fontFlagsBold;
    public boolean fontFlagsWideCodes;
    public LANGCODE languageCode;
    public int[] codeTable;

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            sos.writeUI16(this.fontID);
            sos.writeUI8(this.fontName.getBytes().length);
            sos.write(this.fontName.getBytes());
            sos.writeUB(2, 0L);
            sos.writeUB(1, this.fontFlagsSmallText ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsShiftJIS ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsANSI ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsItalic ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsBold ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsWideCodes ? 1L : 0L);
            sos.writeLANGCODE(this.languageCode);
            for (int i = 0; i < this.codeTable.length; ++i) {
                sos.writeUI16(this.codeTable[i]);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public DefineFontInfo2Tag(byte[] data, int version, long pos) throws IOException {
        super(62, "DefineFontInfo2", data, pos);
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.fontID = sis.readUI16();
        int fontNameLen = sis.readUI8();
        this.fontName = new String(sis.readBytes(fontNameLen));
        sis.readUB(2);
        this.fontFlagsSmallText = sis.readUB(1) == 1L;
        this.fontFlagsShiftJIS = sis.readUB(1) == 1L;
        this.fontFlagsANSI = sis.readUB(1) == 1L;
        this.fontFlagsItalic = sis.readUB(1) == 1L;
        this.fontFlagsBold = sis.readUB(1) == 1L;
        this.fontFlagsWideCodes = sis.readUB(1) == 1L;
        this.languageCode = sis.readLANGCODE();
        this.codeTable = new int[sis.available() / 2];
        for (int i = 0; i < this.codeTable.length; ++i) {
            this.codeTable[i] = sis.readUI16();
        }
    }
}

