/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.Main;
import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.abc.CopyOutputStream;
import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.tags.base.ASMSource;
import com.jpexs.asdec.tags.base.CharacterTag;
import com.jpexs.asdec.types.BUTTONRECORD;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefineButtonTag
extends CharacterTag
implements ASMSource {
    public int buttonId;
    public List<BUTTONRECORD> characters;
    public byte[] actionBytes;

    @Override
    public int getCharacterID() {
        return this.buttonId;
    }

    public DefineButtonTag(byte[] data, int version, long pos) throws IOException {
        super(7, "DefineButton", data, pos);
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.buttonId = sis.readUI16();
        this.characters = sis.readBUTTONRECORDList(false);
        this.actionBytes = sis.readBytes(sis.available());
    }

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        if (Main.DISABLE_DANGEROUS) {
            return super.getData(version);
        }
        OutputStream os = baos = new ByteArrayOutputStream();
        if (Main.DEBUG_COPY) {
            os = new CopyOutputStream(os, new ByteArrayInputStream(this.data));
        }
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            sos.writeUI16(this.buttonId);
            sos.writeBUTTONRECORDList(this.characters, false);
            sos.write(this.actionBytes);
            sos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    @Override
    public String getASMSource(int version) {
        List<Action> actions = new ArrayList<Action>();
        try {
            actions = new SWFInputStream(new ByteArrayInputStream(this.actionBytes), version).readActionList();
        }
        catch (IOException ex) {
            Logger.getLogger(DefineButtonTag.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Action.actionsToString(actions, null, version);
    }

    @Override
    public boolean containsSource() {
        return true;
    }

    @Override
    public List<Action> getActions(int version) {
        try {
            return new SWFInputStream(new ByteArrayInputStream(this.actionBytes), version).readActionList();
        }
        catch (IOException ex) {
            return new ArrayList<Action>();
        }
    }

    @Override
    public void setActions(List<Action> actions, int version) {
        this.actionBytes = Action.actionsToBytes(actions, true, version);
    }

    @Override
    public byte[] getActionBytes() {
        return this.actionBytes;
    }

    @Override
    public void setActionBytes(byte[] actionBytes) {
        this.actionBytes = actionBytes;
    }
}

