/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Highlighting {
    public int startPos;
    public int len;
    public long offset;
    public static boolean doHighlight = true;
    private static final String OFSOPEN = "[OFS";
    private static final String OFSCLOSE = "]";
    private static final String OFSEND = "[/OFS]";
    private static final String TRAITOPEN = "[TRAIT";
    private static final String TRAITCLOSE = "]";
    private static final String TRAITEND = "[/TRAIT]";
    private static final String METHODOPEN = "[METHOD";
    private static final String METHODCLOSE = "]";
    private static final String METHODEND = "[/METHOD]";
    private static final String CLASSOPEN = "[CLASS";
    private static final String CLASSCLOSE = "]";
    private static final String CLASSEND = "[/CLASS]";

    public String toString() {
        return "" + this.startPos + "-" + (this.startPos + this.len) + " ofs" + this.offset;
    }

    public Highlighting(int startPos, int len, long offset) {
        this.startPos = startPos;
        this.len = len;
        this.offset = offset;
    }

    public static String hilighOffset(String text, long offset) {
        if (!doHighlight) {
            return text;
        }
        return OFSOPEN + offset + "]" + text + OFSEND;
    }

    public static String hilighMethod(String text, long index) {
        if (!doHighlight) {
            return text;
        }
        return Highlighting.hilighMethodBegin(index) + text + Highlighting.hilighMethodEnd();
    }

    public static String hilighMethodBegin(long index) {
        if (!doHighlight) {
            return "";
        }
        return METHODOPEN + index + "]";
    }

    public static String hilighMethodEnd() {
        if (!doHighlight) {
            return "";
        }
        return METHODEND;
    }

    public static String hilighTrait(String text, long offset) {
        if (!doHighlight) {
            return text;
        }
        return TRAITOPEN + offset + "]" + text + TRAITEND;
    }

    public static String hilighClass(String text, long offset) {
        if (!doHighlight) {
            return text;
        }
        return CLASSOPEN + offset + "]" + text + CLASSEND;
    }

    public static String stripHilights(String text) {
        if (!doHighlight) {
            return text;
        }
        text = Highlighting.stripInstrHilights(text);
        text = Highlighting.stripTraitHilights(text);
        text = Highlighting.stripMethodHilights(text);
        text = Highlighting.stripClassHilights(text);
        return text;
    }

    public static String stripInstrHilights(String text) {
        return Highlighting.stripSpecificHilights(text, OFSOPEN, "]", OFSEND);
    }

    public static String stripMethodHilights(String text) {
        return Highlighting.stripSpecificHilights(text, METHODOPEN, "]", METHODEND);
    }

    public static String stripTraitHilights(String text) {
        return Highlighting.stripSpecificHilights(text, TRAITOPEN, "]", TRAITEND);
    }

    public static String stripClassHilights(String text) {
        return Highlighting.stripSpecificHilights(text, CLASSOPEN, "]", CLASSEND);
    }

    private static String stripSpecificHilights(String text, String txtOpen, String txtClose, String txtEnd) {
        text = text.replaceAll(Pattern.quote(txtOpen) + "[0-9]+" + Pattern.quote(txtClose), "");
        text = text.replace(txtEnd, "");
        return text;
    }

    private static List<Highlighting> getSpecificHighlights(String text, String txtOpen, String txtClose, String txtEnd) {
        int openpos;
        ArrayList<Highlighting> ret = new ArrayList<Highlighting>();
        int pos = 0;
        while ((openpos = text.indexOf(txtOpen)) != -1) {
            int closepos = text.indexOf(txtClose, openpos);
            int enpos = text.indexOf(txtEnd, openpos);
            int textlen = enpos - closepos - txtClose.length();
            int nextopenpos = text.indexOf(txtOpen, openpos + 1);
            if (nextopenpos != -1 && nextopenpos < enpos) {
                Logger.getLogger(Highlighting.class.getName()).log(Level.SEVERE, "Crossed highligh - str:{0}", text);
                enpos = nextopenpos;
            }
            long offset = Long.parseLong(text.substring(openpos + txtOpen.length(), closepos));
            Highlighting hl = new Highlighting(pos + openpos, textlen, offset);
            pos += openpos + textlen;
            text = text.substring(enpos + txtEnd.length());
            ret.add(hl);
        }
        return ret;
    }

    public static List<Highlighting> getTraitHighlights(String text) {
        text = text.replace("\r\n", "\n");
        text = Highlighting.stripInstrHilights(text);
        text = Highlighting.stripMethodHilights(text);
        text = Highlighting.stripClassHilights(text);
        return Highlighting.getSpecificHighlights(text, TRAITOPEN, "]", TRAITEND);
    }

    public static List<Highlighting> getMethodHighlights(String text) {
        text = text.replace("\r\n", "\n");
        text = Highlighting.stripInstrHilights(text);
        text = Highlighting.stripTraitHilights(text);
        text = Highlighting.stripClassHilights(text);
        return Highlighting.getSpecificHighlights(text, METHODOPEN, "]", METHODEND);
    }

    public static List<Highlighting> getInstrHighlights(String text) {
        text = text.replace("\r\n", "\n");
        text = Highlighting.stripTraitHilights(text);
        text = Highlighting.stripMethodHilights(text);
        text = Highlighting.stripClassHilights(text);
        return Highlighting.getSpecificHighlights(text, OFSOPEN, "]", OFSEND);
    }

    public static List<Highlighting> getClassHighlights(String text) {
        text = text.replace("\r\n", "\n");
        text = Highlighting.stripTraitHilights(text);
        text = Highlighting.stripMethodHilights(text);
        text = Highlighting.stripInstrHilights(text);
        return Highlighting.getSpecificHighlights(text, CLASSOPEN, "]", CLASSEND);
    }
}

