/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.gui;

import com.jpexs.asdec.Configuration;
import com.jpexs.asdec.Main;
import com.jpexs.asdec.SWF;
import com.jpexs.asdec.abc.gui.ABCPanel;
import com.jpexs.asdec.abc.gui.TreeLeafScript;
import com.jpexs.asdec.action.gui.ActionPanel;
import com.jpexs.asdec.action.gui.TagTreeModel;
import com.jpexs.asdec.gui.LoadingPanel;
import com.jpexs.asdec.gui.TagNode;
import com.jpexs.asdec.gui.TagPanel;
import com.jpexs.asdec.gui.View;
import com.jpexs.asdec.tags.DefineBitsJPEG2Tag;
import com.jpexs.asdec.tags.DefineBitsJPEG3Tag;
import com.jpexs.asdec.tags.DefineBitsJPEG4Tag;
import com.jpexs.asdec.tags.DefineBitsLossless2Tag;
import com.jpexs.asdec.tags.DefineBitsLosslessTag;
import com.jpexs.asdec.tags.DefineBitsTag;
import com.jpexs.asdec.tags.DefineButton2Tag;
import com.jpexs.asdec.tags.DefineButtonTag;
import com.jpexs.asdec.tags.DefineEditTextTag;
import com.jpexs.asdec.tags.DefineFont2Tag;
import com.jpexs.asdec.tags.DefineFont3Tag;
import com.jpexs.asdec.tags.DefineFont4Tag;
import com.jpexs.asdec.tags.DefineFontTag;
import com.jpexs.asdec.tags.DefineMorphShape2Tag;
import com.jpexs.asdec.tags.DefineMorphShapeTag;
import com.jpexs.asdec.tags.DefineShape2Tag;
import com.jpexs.asdec.tags.DefineShape3Tag;
import com.jpexs.asdec.tags.DefineShape4Tag;
import com.jpexs.asdec.tags.DefineShapeTag;
import com.jpexs.asdec.tags.DefineSpriteTag;
import com.jpexs.asdec.tags.DefineText2Tag;
import com.jpexs.asdec.tags.DefineTextTag;
import com.jpexs.asdec.tags.DoABCTag;
import com.jpexs.asdec.tags.DoInitActionTag;
import com.jpexs.asdec.tags.ExportAssetsTag;
import com.jpexs.asdec.tags.JPEGTablesTag;
import com.jpexs.asdec.tags.ShowFrameTag;
import com.jpexs.asdec.tags.Tag;
import com.jpexs.asdec.tags.base.ASMSource;
import com.jpexs.asdec.tags.base.Container;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.border.BevelBorder;

public class MainFrame
extends JFrame
implements ActionListener {
    private SWF swf;
    public ABCPanel abcPanel;
    public ActionPanel actionPanel;
    private JTabbedPane tabPane;
    public LoadingPanel loadingPanel = new LoadingPanel(20, 20);
    public JLabel statusLabel = new JLabel("");
    public JPanel statusPanel = new JPanel();
    public JProgressBar progressBar = new JProgressBar(0, 100);
    private TagPanel imagesTagPanel;
    private TagPanel shapesTagPanel;
    private TagPanel morphshapesTagPanel;
    private TagPanel spritesTagPanel;
    private TagPanel textsTagPanel;
    private TagPanel buttonsTagPanel;
    private TagPanel fontsTagPanel;

    public void setPercent(int percent) {
        this.progressBar.setValue(percent);
        this.progressBar.setVisible(true);
    }

    public void hidePercent() {
        if (this.progressBar.isVisible()) {
            this.progressBar.setVisible(false);
        }
    }

    private static void addTab(JTabbedPane tabbedPane, Component tab, String title, Icon icon) {
        tabbedPane.add(tab);
        JLabel lbl = new JLabel(title);
        lbl.setIcon(icon);
        lbl.setIconTextGap(5);
        lbl.setHorizontalTextPosition(4);
        tabbedPane.setTabComponentAt(tabbedPane.getTabCount() - 1, lbl);
    }

    public void setStatus(String s) {
        if (s.equals("")) {
            this.loadingPanel.setVisible(false);
        } else {
            this.loadingPanel.setVisible(true);
        }
        this.statusLabel.setText(s);
    }

    public MainFrame(SWF swf) {
        this.setSize(1000, 700);
        this.tabPane = new JTabbedPane();
        View.setWindowIcon(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (Main.proxyFrame != null && Main.proxyFrame.isVisible()) {
                    return;
                }
                Main.exit();
            }
        });
        this.setTitle("JP ActionScript Decompiler v.1.2.0u1 - " + Main.getFileTitle());
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        JMenuItem miOpen = new JMenuItem("Open...");
        miOpen.setIcon(new ImageIcon(View.loadImage("com/jpexs/asdec/gui/graphics/open16.png")));
        miOpen.setActionCommand("OPEN");
        miOpen.addActionListener(this);
        JMenuItem miSave = new JMenuItem("Save");
        miSave.setIcon(new ImageIcon(View.loadImage("com/jpexs/asdec/gui/graphics/save16.png")));
        miSave.setActionCommand("SAVE");
        miSave.addActionListener(this);
        JMenuItem miSaveAs = new JMenuItem("Save as...");
        miSaveAs.setIcon(new ImageIcon(View.loadImage("com/jpexs/asdec/gui/graphics/saveas16.png")));
        miSaveAs.setActionCommand("SAVEAS");
        miSaveAs.addActionListener(this);
        JMenu menuExportAll = new JMenu("Export all");
        JMenuItem miExportAllAS = new JMenuItem("ActionScript...");
        miExportAllAS.setIcon(new ImageIcon(View.loadImage("com/jpexs/asdec/gui/graphics/as16.png")));
        miExportAllAS.setActionCommand("EXPORT");
        miExportAllAS.addActionListener(this);
        JMenuItem miExportAllPCode = new JMenuItem("PCode...");
        miExportAllPCode.setIcon(new ImageIcon(View.loadImage("com/jpexs/asdec/gui/graphics/pcode16.png")));
        miExportAllPCode.setActionCommand("EXPORTPCODE");
        miExportAllPCode.addActionListener(this);
        JMenuItem miExportImages = new JMenuItem("Images...");
        miExportImages.setIcon(new ImageIcon(View.loadImage("com/jpexs/asdec/gui/graphics/image16.png")));
        miExportImages.setActionCommand("EXPORTIMAGES");
        miExportImages.addActionListener(this);
        menuExportAll.add(miExportAllAS);
        menuExportAll.add(miExportAllPCode);
        menuExportAll.add(miExportImages);
        JMenu menuExportSel = new JMenu("Export selection");
        JMenuItem miExportSelAS = new JMenuItem("ActionScript...");
        miExportSelAS.setIcon(new ImageIcon(View.loadImage("com/jpexs/asdec/gui/graphics/as16.png")));
        miExportSelAS.setActionCommand("EXPORTSEL");
        miExportSelAS.addActionListener(this);
        JMenuItem miExportSelPCode = new JMenuItem("PCode...");
        miExportSelPCode.setIcon(new ImageIcon(View.loadImage("com/jpexs/asdec/gui/graphics/pcode16.png")));
        miExportSelPCode.setActionCommand("EXPORTPCODESEL");
        miExportSelPCode.addActionListener(this);
        JMenuItem miExportSelImages = new JMenuItem("Images...");
        miExportSelImages.setIcon(new ImageIcon(View.loadImage("com/jpexs/asdec/gui/graphics/image16.png")));
        miExportSelImages.setActionCommand("EXPORTIMAGESSEL");
        miExportSelImages.addActionListener(this);
        menuExportSel.add(miExportSelAS);
        menuExportSel.add(miExportSelPCode);
        menuExportSel.add(miExportSelImages);
        menuFile.add(miOpen);
        menuFile.add(miSave);
        menuFile.add(miSaveAs);
        menuFile.add(menuExportAll);
        menuFile.add(menuExportSel);
        menuFile.addSeparator();
        JMenuItem miClose = new JMenuItem("Exit");
        miClose.setIcon(new ImageIcon(View.loadImage("com/jpexs/asdec/gui/graphics/exit16.png")));
        miClose.setActionCommand("EXIT");
        miClose.addActionListener(this);
        menuFile.add(miClose);
        menuBar.add(menuFile);
        JMenu menuDeobfuscation = new JMenu("Deobfuscation");
        JCheckBoxMenuItem miSubLimiter = new JCheckBoxMenuItem("Enable sub limiter");
        miSubLimiter.setActionCommand("SUBLIMITER");
        miSubLimiter.addActionListener(this);
        JMenuItem miRenameIdentifiers = new JMenuItem("Rename identifiers");
        miRenameIdentifiers.setActionCommand("RENAMEIDENTIFIERS");
        miRenameIdentifiers.addActionListener(this);
        menuDeobfuscation.add(miSubLimiter);
        menuDeobfuscation.add(miRenameIdentifiers);
        JMenu menuTools = new JMenu("Tools");
        JMenuItem miProxy = new JMenuItem("Proxy");
        miProxy.setActionCommand("SHOWPROXY");
        miProxy.setIcon(new ImageIcon(View.loadImage("com/jpexs/asdec/gui/graphics/proxy16.png")));
        miProxy.addActionListener(this);
        menuTools.add(miProxy);
        menuTools.add(menuDeobfuscation);
        menuBar.add(menuTools);
        JMenu menuHelp = new JMenu("Help");
        JMenuItem miAbout = new JMenuItem("About...");
        miAbout.setActionCommand("ABOUT");
        miAbout.addActionListener(this);
        JMenuItem miCheckUpdates = new JMenuItem("Check for updates...");
        miCheckUpdates.setActionCommand("CHECKUPDATES");
        miCheckUpdates.addActionListener(this);
        menuHelp.add(miAbout);
        menuHelp.add(miCheckUpdates);
        menuBar.add(menuHelp);
        this.setJMenuBar(menuBar);
        ArrayList<Object> objs = new ArrayList<Object>();
        objs.addAll(swf.tags);
        this.swf = swf;
        this.getContentPane().setLayout(new BorderLayout());
        ArrayList<Tag> shapes = new ArrayList<Tag>();
        ArrayList<Tag> images = new ArrayList<Tag>();
        ArrayList<Tag> morphShapes = new ArrayList<Tag>();
        ArrayList<Tag> sprites = new ArrayList<Tag>();
        ArrayList<Tag> fonts = new ArrayList<Tag>();
        ArrayList<Tag> texts = new ArrayList<Tag>();
        ArrayList<Tag> buttons = new ArrayList<Tag>();
        ArrayList<DoABCTag> abcList = new ArrayList<DoABCTag>();
        MainFrame.getShapes(objs, shapes);
        MainFrame.getImages(objs, images);
        MainFrame.getMorphShapes(objs, morphShapes);
        MainFrame.getSprites(objs, sprites);
        MainFrame.getFonts(objs, fonts);
        MainFrame.getTexts(objs, texts);
        MainFrame.getButtons(objs, buttons);
        MainFrame.getActionScript3(objs, abcList);
        this.getContentPane().add((Component)this.tabPane, "Center");
        if (!abcList.isEmpty()) {
            this.abcPanel = new ABCPanel(abcList);
            MainFrame.addTab(this.tabPane, this.abcPanel, "ActionScript3", new ImageIcon(this.getClass().getClassLoader().getResource("com/jpexs/asdec/gui/graphics/as16.png")));
        } else {
            this.actionPanel = new ActionPanel(swf.tags);
            if (this.actionPanel.tagTree.getRowCount() > 1) {
                MainFrame.addTab(this.tabPane, this.actionPanel, "ActionScript", new ImageIcon(this.getClass().getClassLoader().getResource("com/jpexs/asdec/gui/graphics/as16.png")));
            }
            menuDeobfuscation.setEnabled(false);
        }
        if (!shapes.isEmpty()) {
            this.shapesTagPanel = new TagPanel(shapes, swf);
            MainFrame.addTab(this.tabPane, this.shapesTagPanel, "Shapes", new ImageIcon(this.getClass().getClassLoader().getResource("com/jpexs/asdec/gui/graphics/shape16.png")));
        }
        if (!morphShapes.isEmpty()) {
            this.morphshapesTagPanel = new TagPanel(morphShapes, swf);
            MainFrame.addTab(this.tabPane, this.morphshapesTagPanel, "MorphShapes", new ImageIcon(this.getClass().getClassLoader().getResource("com/jpexs/asdec/gui/graphics/morphshape16.png")));
        }
        if (!images.isEmpty()) {
            this.imagesTagPanel = new TagPanel(images, swf);
            MainFrame.addTab(this.tabPane, this.imagesTagPanel, "Images", new ImageIcon(this.getClass().getClassLoader().getResource("com/jpexs/asdec/gui/graphics/image16.png")));
        }
        if (!sprites.isEmpty()) {
            this.spritesTagPanel = new TagPanel(sprites, swf);
            MainFrame.addTab(this.tabPane, this.spritesTagPanel, "Sprites", new ImageIcon(this.getClass().getClassLoader().getResource("com/jpexs/asdec/gui/graphics/sprite16.png")));
        }
        if (!fonts.isEmpty()) {
            this.fontsTagPanel = new TagPanel(fonts, swf);
            MainFrame.addTab(this.tabPane, this.fontsTagPanel, "Fonts", new ImageIcon(this.getClass().getClassLoader().getResource("com/jpexs/asdec/gui/graphics/font16.png")));
        }
        if (!texts.isEmpty()) {
            this.textsTagPanel = new TagPanel(texts, swf);
            MainFrame.addTab(this.tabPane, this.textsTagPanel, "Texts", new ImageIcon(this.getClass().getClassLoader().getResource("com/jpexs/asdec/gui/graphics/text16.png")));
        }
        if (!buttons.isEmpty()) {
            this.buttonsTagPanel = new TagPanel(buttons, swf);
            MainFrame.addTab(this.tabPane, this.buttonsTagPanel, "Buttons", new ImageIcon(this.getClass().getClassLoader().getResource("com/jpexs/asdec/gui/graphics/button16.png")));
        }
        this.loadingPanel.setPreferredSize(new Dimension(30, 30));
        this.statusPanel = new JPanel();
        this.statusPanel.setPreferredSize(new Dimension(1, 30));
        this.statusPanel.setBorder(new BevelBorder(1));
        this.statusPanel.setLayout(new BorderLayout());
        this.statusPanel.add((Component)this.loadingPanel, "West");
        this.statusPanel.add((Component)this.statusLabel, "Center");
        this.loadingPanel.setVisible(false);
        this.add((Component)this.statusPanel, "South");
        View.centerScreen(this);
        Main.stopWork();
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            if (this.abcPanel != null) {
                this.abcPanel.initSplits();
            }
            if (this.actionPanel != null) {
                this.actionPanel.initSplits();
            }
        }
    }

    public static void getShapes(List<Object> list, List<Tag> shapes) {
        for (Object t : list) {
            if (t instanceof Container) {
                MainFrame.getShapes(((Container)t).getSubItems(), shapes);
            }
            if (!(t instanceof DefineShapeTag) && !(t instanceof DefineShape2Tag) && !(t instanceof DefineShape3Tag) && !(t instanceof DefineShape4Tag)) continue;
            shapes.add((Tag)t);
        }
    }

    public static void getFonts(List<Object> list, List<Tag> fonts) {
        for (Object t : list) {
            if (t instanceof Container) {
                MainFrame.getFonts(((Container)t).getSubItems(), fonts);
            }
            if (!(t instanceof DefineFontTag) && !(t instanceof DefineFont2Tag) && !(t instanceof DefineFont3Tag) && !(t instanceof DefineFont4Tag)) continue;
            fonts.add((Tag)t);
        }
    }

    public static void getActionScript3(List<Object> list, List<DoABCTag> actionScripts) {
        for (Object t : list) {
            if (t instanceof Container) {
                MainFrame.getActionScript3(((Container)t).getSubItems(), actionScripts);
            }
            if (!(t instanceof DoABCTag)) continue;
            actionScripts.add((DoABCTag)t);
        }
    }

    public static void getMorphShapes(List<Object> list, List<Tag> morphShapes) {
        for (Object t : list) {
            if (t instanceof Container) {
                MainFrame.getMorphShapes(((Container)t).getSubItems(), morphShapes);
            }
            if (!(t instanceof DefineMorphShapeTag) && !(t instanceof DefineMorphShape2Tag)) continue;
            morphShapes.add((Tag)t);
        }
    }

    public static void getImages(List<Object> list, List<Tag> images) {
        for (Object t : list) {
            if (t instanceof Container) {
                MainFrame.getImages(((Container)t).getSubItems(), images);
            }
            if (!(t instanceof DefineBitsTag) && !(t instanceof DefineBitsJPEG2Tag) && !(t instanceof DefineBitsJPEG3Tag) && !(t instanceof DefineBitsJPEG4Tag) && !(t instanceof DefineBitsLosslessTag) && !(t instanceof DefineBitsLossless2Tag)) continue;
            images.add((Tag)t);
        }
    }

    public static void getTexts(List<Object> list, List<Tag> texts) {
        for (Object t : list) {
            if (t instanceof Container) {
                MainFrame.getTexts(((Container)t).getSubItems(), texts);
            }
            if (!(t instanceof DefineTextTag) && !(t instanceof DefineText2Tag) && !(t instanceof DefineEditTextTag)) continue;
            texts.add((Tag)t);
        }
    }

    public static void getSprites(List<Object> list, List<Tag> sprites) {
        for (Object t : list) {
            if (t instanceof Container) {
                MainFrame.getSprites(((Container)t).getSubItems(), sprites);
            }
            if (!(t instanceof DefineSpriteTag)) continue;
            sprites.add((Tag)t);
        }
    }

    public static void getButtons(List<Object> list, List<Tag> buttons) {
        for (Object t : list) {
            if (t instanceof Container) {
                MainFrame.getButtons(((Container)t).getSubItems(), buttons);
            }
            if (!(t instanceof DefineButtonTag) && !(t instanceof DefineButton2Tag)) continue;
            buttons.add((Tag)t);
        }
    }

    public static List<TagNode> createTagList(List<Object> list) {
        ArrayList<TagNode> ret = new ArrayList<TagNode>();
        int frame = 1;
        ArrayList<TagNode> frames = new ArrayList<TagNode>();
        ArrayList<TagNode> shapes = new ArrayList<TagNode>();
        ArrayList<TagNode> morphShapes = new ArrayList<TagNode>();
        ArrayList<TagNode> sprites = new ArrayList<TagNode>();
        ArrayList<TagNode> buttons = new ArrayList<TagNode>();
        ArrayList<TagNode> images = new ArrayList<TagNode>();
        ArrayList<TagNode> fonts = new ArrayList<TagNode>();
        ArrayList<TagNode> texts = new ArrayList<TagNode>();
        ArrayList<ExportAssetsTag> exportAssetsTags = new ArrayList<ExportAssetsTag>();
        for (Object t : list) {
            TagNode tti;
            if (t instanceof ExportAssetsTag) {
                exportAssetsTags.add((ExportAssetsTag)t);
            }
            if (t instanceof DefineFontTag || t instanceof DefineFont2Tag || t instanceof DefineFont3Tag || t instanceof DefineFont4Tag) {
                fonts.add(new TagNode(t));
            }
            if (t instanceof DefineTextTag || t instanceof DefineText2Tag || t instanceof DefineEditTextTag) {
                texts.add(new TagNode(t));
            }
            if (t instanceof DefineBitsTag || t instanceof DefineBitsJPEG2Tag || t instanceof DefineBitsJPEG3Tag || t instanceof DefineBitsJPEG4Tag || t instanceof DefineBitsLosslessTag || t instanceof DefineBitsLossless2Tag) {
                images.add(new TagNode(t));
            }
            if (t instanceof DefineShapeTag || t instanceof DefineShape2Tag || t instanceof DefineShape3Tag || t instanceof DefineShape4Tag) {
                shapes.add(new TagNode(t));
            }
            if (t instanceof DefineMorphShapeTag || t instanceof DefineMorphShape2Tag) {
                morphShapes.add(new TagNode(t));
            }
            if (t instanceof DefineSpriteTag) {
                sprites.add(new TagNode(t));
            }
            if (t instanceof DefineButtonTag || t instanceof DefineButton2Tag) {
                buttons.add(new TagNode(t));
            }
            if (t instanceof ShowFrameTag) {
                tti = new TagNode("frame" + frame);
                ++frame;
                frames.add(tti);
            }
            if (!(t instanceof Container)) continue;
            tti = new TagNode(t);
            if (((Container)t).getItemCount() <= 0) continue;
            List<Object> subItems = ((Container)t).getSubItems();
            tti.subItems = MainFrame.createTagList(subItems);
        }
        TagNode textsNode = new TagNode("texts");
        textsNode.subItems.addAll(texts);
        TagNode imagesNode = new TagNode("images");
        imagesNode.subItems.addAll(images);
        TagNode fontsNode = new TagNode("fonts");
        fontsNode.subItems.addAll(fonts);
        TagNode spritesNode = new TagNode("sprites");
        spritesNode.subItems.addAll(sprites);
        TagNode shapesNode = new TagNode("shapes");
        shapesNode.subItems.addAll(shapes);
        TagNode morphShapesNode = new TagNode("morphshapes");
        morphShapesNode.subItems.addAll(morphShapes);
        TagNode buttonsNode = new TagNode("buttons");
        buttonsNode.subItems.addAll(buttons);
        TagNode framesNode = new TagNode("frames");
        framesNode.subItems.addAll(frames);
        ret.add(shapesNode);
        ret.add(morphShapesNode);
        ret.add(spritesNode);
        ret.add(textsNode);
        ret.add(imagesNode);
        ret.add(buttonsNode);
        ret.add(fontsNode);
        ret.add(framesNode);
        for (int i = ret.size() - 1; i >= 0; --i) {
            ASMSource ass;
            if (((TagNode)ret.get((int)i)).tag instanceof DefineSpriteTag) {
                ((DefineSpriteTag)((TagNode)ret.get((int)i)).tag).exportAssetsTags = exportAssetsTags;
            }
            if (((TagNode)ret.get((int)i)).tag instanceof DefineButtonTag) {
                ((DefineButtonTag)((TagNode)ret.get((int)i)).tag).exportAssetsTags = exportAssetsTags;
            }
            if (((TagNode)ret.get((int)i)).tag instanceof DefineButton2Tag) {
                ((DefineButton2Tag)((TagNode)ret.get((int)i)).tag).exportAssetsTags = exportAssetsTags;
            }
            if (((TagNode)ret.get((int)i)).tag instanceof DoInitActionTag) {
                ((DoInitActionTag)((TagNode)ret.get((int)i)).tag).exportAssetsTags = exportAssetsTags;
            }
            if ((!(((TagNode)ret.get((int)i)).tag instanceof ASMSource) || !(ass = (ASMSource)((TagNode)ret.get((int)i)).tag).containsSource()) && !((TagNode)ret.get((int)i)).subItems.isEmpty()) continue;
        }
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("EXIT")) {
            this.setVisible(false);
            if (Main.proxyFrame != null && Main.proxyFrame.isVisible()) {
                return;
            }
            Main.exit();
        }
        if (Main.isWorking()) {
            return;
        }
        if (e.getActionCommand().equals("ABOUT")) {
            Main.about();
        }
        if (e.getActionCommand().equals("SHOWPROXY")) {
            Main.showProxy();
        }
        if (e.getActionCommand().equals("SUBLIMITER") && e.getSource() instanceof JCheckBoxMenuItem) {
            Main.setSubLimiter(((JCheckBoxMenuItem)e.getSource()).getState());
        }
        if (e.getActionCommand().equals("SAVE")) {
            try {
                Main.saveFile(Main.file);
            }
            catch (IOException ex) {
                Logger.getLogger(ABCPanel.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(null, "Cannot save file", "Error", 0);
            }
        }
        if (e.getActionCommand().equals("SAVEAS") && Main.saveFileDialog()) {
            this.setTitle("JP ActionScript Decompiler v.1.2.0u1 - " + Main.getFileTitle());
        }
        if (e.getActionCommand().equals("OPEN")) {
            Main.openFileDialog();
        }
        if (e.getActionCommand().startsWith("EXPORT")) {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File((String)Configuration.getConfig("lastExportDir", ".")));
            chooser.setDialogTitle("Select directory to export");
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showOpenDialog(this) == 0) {
                Main.startWork("Exporting...");
                final String selFile = chooser.getSelectedFile().getAbsolutePath();
                Configuration.setConfig("lastExportDir", chooser.getSelectedFile().getParentFile().getAbsolutePath());
                final boolean isPcode = e.getActionCommand().startsWith("EXPORTPCODE");
                final boolean onlySel = e.getActionCommand().endsWith("SEL");
                final boolean images = e.getActionCommand().startsWith("EXPORTIMAGES");
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            if (onlySel) {
                                if (images) {
                                    if (MainFrame.this.imagesTagPanel != null) {
                                        Object[] lob;
                                        ArrayList<Tag> list = new ArrayList<Tag>();
                                        for (Object o : lob = ((MainFrame)MainFrame.this).imagesTagPanel.tagList.getSelectedValues()) {
                                            if (!(o instanceof Tag)) continue;
                                            list.add((Tag)o);
                                        }
                                        JPEGTablesTag jtt = null;
                                        for (Tag t : ((MainFrame)MainFrame.this).swf.tags) {
                                            if (!(t instanceof JPEGTablesTag)) continue;
                                            jtt = (JPEGTablesTag)t;
                                            break;
                                        }
                                        SWF.exportImages(selFile, list, jtt);
                                    }
                                } else if (MainFrame.this.abcPanel != null) {
                                    List<TreeLeafScript> tlsList = MainFrame.this.abcPanel.classTree.getSelectedScripts();
                                    if (tlsList.isEmpty()) {
                                        JOptionPane.showMessageDialog(null, "No script selected!");
                                    }
                                    for (int i = 0; i < tlsList.size(); ++i) {
                                        TreeLeafScript tls = tlsList.get(i);
                                        Main.startWork("Exporting " + (i + 1) + "/" + tlsList.size() + " " + tls.abc.script_info[tls.scriptIndex].getPath(tls.abc) + " ...");
                                        tls.abc.script_info[tls.scriptIndex].export(tls.abc, MainFrame.this.abcPanel.list, selFile, isPcode);
                                    }
                                } else if (MainFrame.this.actionPanel != null) {
                                    List<com.jpexs.asdec.action.TagNode> nodes = MainFrame.this.actionPanel.getSelectedNodes();
                                    if (nodes.isEmpty()) {
                                        JOptionPane.showMessageDialog(null, "No nodes selected!");
                                    }
                                    TagTreeModel ttm = (TagTreeModel)MainFrame.this.actionPanel.tagTree.getModel();
                                    List<com.jpexs.asdec.action.TagNode> allnodes = ttm.getNodeList();
                                    com.jpexs.asdec.action.TagNode.setExport(allnodes, false);
                                    com.jpexs.asdec.action.TagNode.setExport(nodes, true);
                                    com.jpexs.asdec.action.TagNode.exportNode(allnodes, selFile, isPcode);
                                }
                            } else if (images) {
                                Main.swf.exportImages(selFile);
                            } else {
                                Main.swf.exportActionScript(selFile, isPcode);
                            }
                        }
                        catch (Exception ignored) {
                            JOptionPane.showMessageDialog(null, "Cannot write to the file");
                        }
                        Main.stopWork();
                    }
                }.start();
            }
        }
        if (e.getActionCommand().equals("CHECKUPDATES") && !Main.checkForUpdates()) {
            JOptionPane.showMessageDialog(null, "No new version available.");
        }
        if (e.getActionCommand().equals("RENAMEIDENTIFIERS") && JOptionPane.showConfirmDialog(null, "Following procedure can damage SWF file which can be then unplayable.\r\nUSE IT ON YOUR OWN RISK. Do you want to continue?", "Warning", 2, 2) == 0) {
            Main.startWork("Renaming identifiers...");
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    int cnt = 0;
                    for (DoABCTag tag : MainFrame.this.abcPanel.list) {
                        cnt += tag.abc.deobfuscateIdentifiers();
                    }
                    Main.stopWork();
                    JOptionPane.showMessageDialog(null, "Identifiers renamed: " + cnt);
                    MainFrame.this.abcPanel.reload();
                    return true;
                }
            }.execute();
        }
    }
}

