/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.action.treemodel;

import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.action.treemodel.ConstantPool;
import com.jpexs.asdec.action.treemodel.DirectValueTreeItem;
import com.jpexs.asdec.helpers.Highlighting;

public abstract class TreeItem {
    public static final int PRECEDENCE_PRIMARY = 0;
    public static final int PRECEDENCE_POSTFIX = 1;
    public static final int PRECEDENCE_UNARY = 2;
    public static final int PRECEDENCE_MULTIPLICATIVE = 3;
    public static final int PRECEDENCE_ADDITIVE = 4;
    public static final int PRECEDENCE_BITWISESHIFT = 5;
    public static final int PRECEDENCE_RELATIONAL = 6;
    public static final int PRECEDENCE_EQUALITY = 7;
    public static final int PRECEDENCE_BITWISEAND = 8;
    public static final int PRECEDENCE_BITWISEXOR = 9;
    public static final int PRECEDENCE_BITWISEOR = 10;
    public static final int PRECEDENCE_LOGICALAND = 11;
    public static final int PRECEDENCE_LOGICALOR = 12;
    public static final int PRECEDENCE_CONDITIONAL = 13;
    public static final int PRECEDENCE_ASSIGMENT = 14;
    public static final int PRECEDENCE_COMMA = 15;
    public static final int NOPRECEDENCE = 16;
    public int precedence = 16;
    public Action instruction;

    public TreeItem(Action instruction, int precedence) {
        this.instruction = instruction;
        this.precedence = precedence;
    }

    public abstract String toString(ConstantPool var1);

    public String toString() {
        return this.toString(null);
    }

    protected String hilight(String str) {
        if (this.instruction == null) {
            return str;
        }
        return Highlighting.hilighOffset(str, this.instruction.getAddress());
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    protected boolean isEmptyString(TreeItem target) {
        return target instanceof DirectValueTreeItem && ((DirectValueTreeItem)target).value instanceof String && ((DirectValueTreeItem)target).value.equals("");
    }

    protected String stripQuotes(TreeItem target) {
        if (target instanceof DirectValueTreeItem && ((DirectValueTreeItem)target).value instanceof String) {
            return (String)((DirectValueTreeItem)target).value;
        }
        if (target == null) {
            return "";
        }
        return target.toString();
    }
}

