/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.action.parser;

import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.action.flashlite.ActionFSCommand2;
import com.jpexs.asdec.action.flashlite.ActionStrictMode;
import com.jpexs.asdec.action.parser.FlasmLexer;
import com.jpexs.asdec.action.parser.Label;
import com.jpexs.asdec.action.parser.ParseException;
import com.jpexs.asdec.action.parser.ParsedSymbol;
import com.jpexs.asdec.action.swf3.ActionGetURL;
import com.jpexs.asdec.action.swf3.ActionGoToLabel;
import com.jpexs.asdec.action.swf3.ActionGotoFrame;
import com.jpexs.asdec.action.swf3.ActionNextFrame;
import com.jpexs.asdec.action.swf3.ActionPlay;
import com.jpexs.asdec.action.swf3.ActionPrevFrame;
import com.jpexs.asdec.action.swf3.ActionSetTarget;
import com.jpexs.asdec.action.swf3.ActionStop;
import com.jpexs.asdec.action.swf3.ActionStopSounds;
import com.jpexs.asdec.action.swf3.ActionToggleQuality;
import com.jpexs.asdec.action.swf3.ActionWaitForFrame;
import com.jpexs.asdec.action.swf4.ActionAdd;
import com.jpexs.asdec.action.swf4.ActionAnd;
import com.jpexs.asdec.action.swf4.ActionAsciiToChar;
import com.jpexs.asdec.action.swf4.ActionCall;
import com.jpexs.asdec.action.swf4.ActionCharToAscii;
import com.jpexs.asdec.action.swf4.ActionCloneSprite;
import com.jpexs.asdec.action.swf4.ActionDivide;
import com.jpexs.asdec.action.swf4.ActionEndDrag;
import com.jpexs.asdec.action.swf4.ActionEquals;
import com.jpexs.asdec.action.swf4.ActionGetProperty;
import com.jpexs.asdec.action.swf4.ActionGetTime;
import com.jpexs.asdec.action.swf4.ActionGetURL2;
import com.jpexs.asdec.action.swf4.ActionGetVariable;
import com.jpexs.asdec.action.swf4.ActionGotoFrame2;
import com.jpexs.asdec.action.swf4.ActionIf;
import com.jpexs.asdec.action.swf4.ActionJump;
import com.jpexs.asdec.action.swf4.ActionLess;
import com.jpexs.asdec.action.swf4.ActionMBAsciiToChar;
import com.jpexs.asdec.action.swf4.ActionMBCharToAscii;
import com.jpexs.asdec.action.swf4.ActionMBStringExtract;
import com.jpexs.asdec.action.swf4.ActionMBStringLength;
import com.jpexs.asdec.action.swf4.ActionMultiply;
import com.jpexs.asdec.action.swf4.ActionNot;
import com.jpexs.asdec.action.swf4.ActionOr;
import com.jpexs.asdec.action.swf4.ActionPop;
import com.jpexs.asdec.action.swf4.ActionPush;
import com.jpexs.asdec.action.swf4.ActionRandomNumber;
import com.jpexs.asdec.action.swf4.ActionRemoveSprite;
import com.jpexs.asdec.action.swf4.ActionSetProperty;
import com.jpexs.asdec.action.swf4.ActionSetTarget2;
import com.jpexs.asdec.action.swf4.ActionSetVariable;
import com.jpexs.asdec.action.swf4.ActionStartDrag;
import com.jpexs.asdec.action.swf4.ActionStringAdd;
import com.jpexs.asdec.action.swf4.ActionStringEquals;
import com.jpexs.asdec.action.swf4.ActionStringExtract;
import com.jpexs.asdec.action.swf4.ActionStringLength;
import com.jpexs.asdec.action.swf4.ActionStringLess;
import com.jpexs.asdec.action.swf4.ActionSubtract;
import com.jpexs.asdec.action.swf4.ActionToInteger;
import com.jpexs.asdec.action.swf4.ActionTrace;
import com.jpexs.asdec.action.swf4.ActionWaitForFrame2;
import com.jpexs.asdec.action.swf5.ActionAdd2;
import com.jpexs.asdec.action.swf5.ActionBitAnd;
import com.jpexs.asdec.action.swf5.ActionBitLShift;
import com.jpexs.asdec.action.swf5.ActionBitOr;
import com.jpexs.asdec.action.swf5.ActionBitRShift;
import com.jpexs.asdec.action.swf5.ActionBitURShift;
import com.jpexs.asdec.action.swf5.ActionBitXor;
import com.jpexs.asdec.action.swf5.ActionCallFunction;
import com.jpexs.asdec.action.swf5.ActionCallMethod;
import com.jpexs.asdec.action.swf5.ActionConstantPool;
import com.jpexs.asdec.action.swf5.ActionDecrement;
import com.jpexs.asdec.action.swf5.ActionDefineFunction;
import com.jpexs.asdec.action.swf5.ActionDefineLocal;
import com.jpexs.asdec.action.swf5.ActionDefineLocal2;
import com.jpexs.asdec.action.swf5.ActionDelete;
import com.jpexs.asdec.action.swf5.ActionDelete2;
import com.jpexs.asdec.action.swf5.ActionEnumerate;
import com.jpexs.asdec.action.swf5.ActionEquals2;
import com.jpexs.asdec.action.swf5.ActionGetMember;
import com.jpexs.asdec.action.swf5.ActionIncrement;
import com.jpexs.asdec.action.swf5.ActionInitArray;
import com.jpexs.asdec.action.swf5.ActionInitObject;
import com.jpexs.asdec.action.swf5.ActionLess2;
import com.jpexs.asdec.action.swf5.ActionModulo;
import com.jpexs.asdec.action.swf5.ActionNewMethod;
import com.jpexs.asdec.action.swf5.ActionNewObject;
import com.jpexs.asdec.action.swf5.ActionPushDuplicate;
import com.jpexs.asdec.action.swf5.ActionReturn;
import com.jpexs.asdec.action.swf5.ActionSetMember;
import com.jpexs.asdec.action.swf5.ActionStackSwap;
import com.jpexs.asdec.action.swf5.ActionStoreRegister;
import com.jpexs.asdec.action.swf5.ActionTargetPath;
import com.jpexs.asdec.action.swf5.ActionToNumber;
import com.jpexs.asdec.action.swf5.ActionToString;
import com.jpexs.asdec.action.swf5.ActionTypeOf;
import com.jpexs.asdec.action.swf5.ActionWith;
import com.jpexs.asdec.action.swf6.ActionEnumerate2;
import com.jpexs.asdec.action.swf6.ActionGreater;
import com.jpexs.asdec.action.swf6.ActionInstanceOf;
import com.jpexs.asdec.action.swf6.ActionStrictEquals;
import com.jpexs.asdec.action.swf6.ActionStringGreater;
import com.jpexs.asdec.action.swf7.ActionCastOp;
import com.jpexs.asdec.action.swf7.ActionDefineFunction2;
import com.jpexs.asdec.action.swf7.ActionExtends;
import com.jpexs.asdec.action.swf7.ActionImplementsOp;
import com.jpexs.asdec.action.swf7.ActionThrow;
import com.jpexs.asdec.action.swf7.ActionTry;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ASMParser {
    public static List<Action> parse(List<Label> labels, long address, FlasmLexer lexer, List<String> constantPool, int version) throws IOException, ParseException {
        ParsedSymbol symb;
        ArrayList<Action> list = new ArrayList<Action>();
        while (true) {
            symb = lexer.yylex();
            if (symb.type == 8) {
                labels.add(new Label((String)symb.value, address));
                continue;
            }
            if (symb.type == 3) {
                String instructionName = ((String)symb.value).toLowerCase();
                if (instructionName.equals("GetURL".toLowerCase())) {
                    list.add(new ActionGetURL(lexer));
                } else if (instructionName.equals("GoToLabel".toLowerCase())) {
                    list.add(new ActionGoToLabel(lexer));
                } else if (instructionName.equals("GotoFrame".toLowerCase())) {
                    list.add(new ActionGotoFrame(lexer));
                } else if (instructionName.equals("NextFrame".toLowerCase())) {
                    list.add(new ActionNextFrame());
                } else if (instructionName.equals("Play".toLowerCase())) {
                    list.add(new ActionPlay());
                } else if (instructionName.equals("PrevFrame".toLowerCase())) {
                    list.add(new ActionPrevFrame());
                } else if (instructionName.equals("SetTarget".toLowerCase())) {
                    list.add(new ActionSetTarget(lexer));
                } else if (instructionName.equals("Stop".toLowerCase())) {
                    list.add(new ActionStop());
                } else if (instructionName.equals("StopSounds".toLowerCase())) {
                    list.add(new ActionStopSounds());
                } else if (instructionName.equals("ToggleQuality".toLowerCase())) {
                    list.add(new ActionToggleQuality());
                } else if (instructionName.equals("WaitForFrame".toLowerCase())) {
                    list.add(new ActionWaitForFrame(lexer));
                } else if (instructionName.equals("Add".toLowerCase())) {
                    list.add(new ActionAdd());
                } else if (instructionName.equals("And".toLowerCase())) {
                    list.add(new ActionAnd());
                } else if (instructionName.equals("AsciiToChar".toLowerCase())) {
                    list.add(new ActionAsciiToChar());
                } else if (instructionName.equals("Call".toLowerCase())) {
                    list.add(new ActionCall());
                } else if (instructionName.equals("CharToAscii".toLowerCase())) {
                    list.add(new ActionCharToAscii());
                } else if (instructionName.equals("CloneSprite".toLowerCase())) {
                    list.add(new ActionCloneSprite());
                } else if (instructionName.equals("Divide".toLowerCase())) {
                    list.add(new ActionDivide());
                } else if (instructionName.equals("EndDrag".toLowerCase())) {
                    list.add(new ActionEndDrag());
                } else if (instructionName.equals("Equals".toLowerCase())) {
                    list.add(new ActionEquals());
                } else if (instructionName.equals("GetProperty".toLowerCase())) {
                    list.add(new ActionGetProperty());
                } else if (instructionName.equals("GetTime".toLowerCase())) {
                    list.add(new ActionGetTime());
                } else if (instructionName.equals("GetURL2".toLowerCase())) {
                    list.add(new ActionGetURL2(lexer));
                } else if (instructionName.equals("GetVariable".toLowerCase())) {
                    list.add(new ActionGetVariable());
                } else if (instructionName.equals("GotoFrame2".toLowerCase())) {
                    list.add(new ActionGotoFrame2(lexer));
                } else if (instructionName.equals("If".toLowerCase())) {
                    list.add(new ActionIf(lexer));
                } else if (instructionName.equals("Jump".toLowerCase())) {
                    list.add(new ActionJump(lexer));
                } else if (instructionName.equals("Less".toLowerCase())) {
                    list.add(new ActionLess());
                } else if (instructionName.equals("MBAsciiToChar".toLowerCase())) {
                    list.add(new ActionMBAsciiToChar());
                } else if (instructionName.equals("MBCharToAscii".toLowerCase())) {
                    list.add(new ActionMBCharToAscii());
                } else if (instructionName.equals("MBStringExtract".toLowerCase())) {
                    list.add(new ActionMBStringExtract());
                } else if (instructionName.equals("MBStringLength".toLowerCase())) {
                    list.add(new ActionMBStringLength());
                } else if (instructionName.equals("Multiply".toLowerCase())) {
                    list.add(new ActionMultiply());
                } else if (instructionName.equals("Not".toLowerCase())) {
                    list.add(new ActionNot());
                } else if (instructionName.equals("Or".toLowerCase())) {
                    list.add(new ActionOr());
                } else if (instructionName.equals("Pop".toLowerCase())) {
                    list.add(new ActionPop());
                } else if (instructionName.equals("Push".toLowerCase())) {
                    list.add(new ActionPush(lexer, constantPool));
                } else if (instructionName.equals("RandomNumber".toLowerCase())) {
                    list.add(new ActionRandomNumber());
                } else if (instructionName.equals("RemoveSprite".toLowerCase())) {
                    list.add(new ActionRemoveSprite());
                } else if (instructionName.equals("SetProperty".toLowerCase())) {
                    list.add(new ActionSetProperty());
                } else if (instructionName.equals("SetTarget2".toLowerCase())) {
                    list.add(new ActionSetTarget2());
                } else if (instructionName.equals("SetVariable".toLowerCase())) {
                    list.add(new ActionSetVariable());
                } else if (instructionName.equals("StartDrag".toLowerCase())) {
                    list.add(new ActionStartDrag());
                } else if (instructionName.equals("StringAdd".toLowerCase())) {
                    list.add(new ActionStringAdd());
                } else if (instructionName.equals("StringEquals".toLowerCase())) {
                    list.add(new ActionStringEquals());
                } else if (instructionName.equals("StringExtract".toLowerCase())) {
                    list.add(new ActionStringExtract());
                } else if (instructionName.equals("StringLength".toLowerCase())) {
                    list.add(new ActionStringLength());
                } else if (instructionName.equals("StringLess".toLowerCase())) {
                    list.add(new ActionStringLess());
                } else if (instructionName.equals("Subtract".toLowerCase())) {
                    list.add(new ActionSubtract());
                } else if (instructionName.equals("ToInteger".toLowerCase())) {
                    list.add(new ActionToInteger());
                } else if (instructionName.equals("Trace".toLowerCase())) {
                    list.add(new ActionTrace());
                } else if (instructionName.equals("WaitForFrame2".toLowerCase())) {
                    list.add(new ActionWaitForFrame2(lexer));
                } else if (instructionName.equals("Add2".toLowerCase())) {
                    list.add(new ActionAdd2());
                } else if (instructionName.equals("BitAnd".toLowerCase())) {
                    list.add(new ActionBitAnd());
                } else if (instructionName.equals("BitLShift".toLowerCase())) {
                    list.add(new ActionBitLShift());
                } else if (instructionName.equals("BitOr".toLowerCase())) {
                    list.add(new ActionBitOr());
                } else if (instructionName.equals("BitRShift".toLowerCase())) {
                    list.add(new ActionBitRShift());
                } else if (instructionName.equals("BitURShift".toLowerCase())) {
                    list.add(new ActionBitURShift());
                } else if (instructionName.equals("BitXor".toLowerCase())) {
                    list.add(new ActionBitXor());
                } else if (instructionName.equals("CallFunction".toLowerCase())) {
                    list.add(new ActionCallFunction());
                } else if (instructionName.equals("CallMethod".toLowerCase())) {
                    list.add(new ActionCallMethod());
                } else if (instructionName.equals("ConstantPool".toLowerCase())) {
                    ActionConstantPool acp = new ActionConstantPool(lexer);
                    constantPool = acp.constantPool;
                    list.add(acp);
                } else if (instructionName.equals("Decrement".toLowerCase())) {
                    list.add(new ActionDecrement());
                } else if (instructionName.equals("DefineFunction".toLowerCase())) {
                    list.add(new ActionDefineFunction(labels, address, lexer, constantPool, version));
                } else if (instructionName.equals("DefineLocal".toLowerCase())) {
                    list.add(new ActionDefineLocal());
                } else if (instructionName.equals("DefineLocal2".toLowerCase())) {
                    list.add(new ActionDefineLocal2());
                } else if (instructionName.equals("Delete".toLowerCase())) {
                    list.add(new ActionDelete());
                } else if (instructionName.equals("Delete2".toLowerCase())) {
                    list.add(new ActionDelete2());
                } else if (instructionName.equals("Enumerate".toLowerCase())) {
                    list.add(new ActionEnumerate());
                } else if (instructionName.equals("Equals2".toLowerCase())) {
                    list.add(new ActionEquals2());
                } else if (instructionName.equals("GetMember".toLowerCase())) {
                    list.add(new ActionGetMember());
                } else if (instructionName.equals("Increment".toLowerCase())) {
                    list.add(new ActionIncrement());
                } else if (instructionName.equals("InitArray".toLowerCase())) {
                    list.add(new ActionInitArray());
                } else if (instructionName.equals("InitObject".toLowerCase())) {
                    list.add(new ActionInitObject());
                } else if (instructionName.equals("Less2".toLowerCase())) {
                    list.add(new ActionLess2());
                } else if (instructionName.equals("Modulo".toLowerCase())) {
                    list.add(new ActionModulo());
                } else if (instructionName.equals("NewMethod".toLowerCase())) {
                    list.add(new ActionNewMethod());
                } else if (instructionName.equals("NewObject".toLowerCase())) {
                    list.add(new ActionNewObject());
                } else if (instructionName.equals("PushDuplicate".toLowerCase())) {
                    list.add(new ActionPushDuplicate());
                } else if (instructionName.equals("Return".toLowerCase())) {
                    list.add(new ActionReturn());
                } else if (instructionName.equals("SetMember".toLowerCase())) {
                    list.add(new ActionSetMember());
                } else if (instructionName.equals("StackSwap".toLowerCase())) {
                    list.add(new ActionStackSwap());
                } else if (instructionName.equals("StoreRegister".toLowerCase())) {
                    list.add(new ActionStoreRegister(lexer));
                } else if (instructionName.equals("TargetPath".toLowerCase())) {
                    list.add(new ActionTargetPath());
                } else if (instructionName.equals("ToNumber".toLowerCase())) {
                    list.add(new ActionToNumber());
                } else if (instructionName.equals("ToString".toLowerCase())) {
                    list.add(new ActionToString());
                } else if (instructionName.equals("TypeOf".toLowerCase())) {
                    list.add(new ActionTypeOf());
                } else if (instructionName.equals("With".toLowerCase())) {
                    list.add(new ActionWith(labels, address, lexer, constantPool, version));
                } else if (instructionName.equals("Enumerate2".toLowerCase())) {
                    list.add(new ActionEnumerate2());
                } else if (instructionName.equals("Greater".toLowerCase())) {
                    list.add(new ActionGreater());
                } else if (instructionName.equals("InstanceOf".toLowerCase())) {
                    list.add(new ActionInstanceOf());
                } else if (instructionName.equals("StrictEquals".toLowerCase())) {
                    list.add(new ActionStrictEquals());
                } else if (instructionName.equals("StringGreater".toLowerCase())) {
                    list.add(new ActionStringGreater());
                } else if (instructionName.equals("CastOp".toLowerCase())) {
                    list.add(new ActionCastOp());
                } else if (instructionName.equals("DefineFunction2".toLowerCase())) {
                    list.add(new ActionDefineFunction2(labels, address, lexer, constantPool, version));
                } else if (instructionName.equals("Extends".toLowerCase())) {
                    list.add(new ActionExtends());
                } else if (instructionName.equals("ImplementsOp".toLowerCase())) {
                    list.add(new ActionImplementsOp());
                } else if (instructionName.equals("Throw".toLowerCase())) {
                    list.add(new ActionThrow());
                } else if (instructionName.equals("Try".toLowerCase())) {
                    list.add(new ActionTry(labels, address, lexer, constantPool, version));
                } else if (instructionName.equals("FSCommand2".toLowerCase())) {
                    list.add(new ActionFSCommand2());
                } else if (instructionName.equals("StrictMode".toLowerCase())) {
                    list.add(new ActionStrictMode(lexer));
                } else {
                    throw new ParseException("Unknown instruction name :" + instructionName, lexer.yyline());
                }
                address += (long)((Action)list.get(list.size() - 1)).getBytes(version).length;
                continue;
            }
            if (symb.type != 16) break;
        }
        if (symb.type == 2 || symb.type == 7) {
            return list;
        }
        throw new ParseException("Label or Instruction name expected, found:" + symb.type, lexer.yyline());
    }

    public static List<Action> parse(InputStream is, int version) throws IOException, ParseException {
        FlasmLexer lexer = new FlasmLexer(is);
        ArrayList<Label> labels = new ArrayList<Label>();
        List<Action> ret = ASMParser.parse(labels, 0L, lexer, new ArrayList<String>(), version);
        List<Action> links = Action.getActionsAllIfsOrJumps(ret);
        Action.setActionsAddresses(ret, 0L, version);
        for (Action link : links) {
            if (link instanceof ActionJump) {
                for (Label label : labels) {
                    if (!((ActionJump)link).identifier.equals(label.name)) continue;
                    ((ActionJump)link).offset = (int)(label.address - (((ActionJump)link).getAddress() + (long)((ActionJump)link).getBytes(version).length));
                }
            }
            if (!(link instanceof ActionIf)) continue;
            for (Label label : labels) {
                if (!((ActionIf)link).identifier.equals(label.name)) continue;
                ((ActionIf)link).offset = (int)(label.address - (((ActionIf)link).getAddress() + (long)((ActionIf)link).getBytes(version).length));
            }
        }
        return ret;
    }
}

