/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.action.gui;

import com.jpexs.asdec.Main;
import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.action.TagNode;
import com.jpexs.asdec.action.gui.TagTreeModel;
import com.jpexs.asdec.action.parser.ASMParser;
import com.jpexs.asdec.action.parser.ParseException;
import com.jpexs.asdec.helpers.Highlighting;
import com.jpexs.asdec.tags.Tag;
import com.jpexs.asdec.tags.base.ASMSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import jsyntaxpane.DefaultSyntaxKit;

public class ActionPanel
extends JPanel
implements TreeSelectionListener,
ActionListener {
    public JTree tagTree;
    public JEditorPane editor;
    public JEditorPane decompiledEditor;
    public List<Tag> list;
    public JSplitPane splitPane;
    public JSplitPane splitPane2;
    public JButton saveButton = new JButton("Save");
    public JButton saveHexButton = new JButton("Save hex");
    public JButton loadHexButton = new JButton("Load hex");
    public JLabel asmLabel = new JLabel("P-code source (editable)");
    public JLabel decLabel = new JLabel("ActionScript source");

    public ActionPanel(List<Tag> list) {
        this.list = list;
        DefaultSyntaxKit.initKit();
        this.editor = new JEditorPane();
        this.decompiledEditor = new JEditorPane();
        this.tagTree = new JTree(new TagTreeModel(list));
        DefaultTreeCellRenderer treeRenderer = new DefaultTreeCellRenderer();
        ClassLoader cldr = this.getClass().getClassLoader();
        URL imageURL = cldr.getResource("com/jpexs/asdec/gui/graphics/as16.png");
        ImageIcon leafIcon = new ImageIcon(imageURL);
        treeRenderer.setLeafIcon(leafIcon);
        this.tagTree.setCellRenderer(treeRenderer);
        JPanel panB = new JPanel();
        panB.setLayout(new BorderLayout());
        this.asmLabel.setHorizontalAlignment(0);
        this.asmLabel.setBorder(new BevelBorder(0));
        panB.add((Component)this.asmLabel, "North");
        panB.add((Component)new JScrollPane(this.editor), "Center");
        JPanel buttonsPan = new JPanel();
        buttonsPan.setLayout(new FlowLayout());
        buttonsPan.add(this.saveButton);
        panB.add((Component)buttonsPan, "South");
        this.saveHexButton.addActionListener(this);
        this.saveHexButton.setActionCommand("SAVEHEXACTION");
        this.loadHexButton.addActionListener(this);
        this.loadHexButton.setActionCommand("LOADHEXACTION");
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand("SAVEACTION");
        JPanel panA = new JPanel();
        panA.setLayout(new BorderLayout());
        panA.add((Component)new JScrollPane(this.decompiledEditor), "Center");
        panA.add((Component)this.decLabel, "North");
        this.decLabel.setHorizontalAlignment(0);
        this.decLabel.setBorder(new BevelBorder(0));
        this.setLayout(new BorderLayout());
        this.splitPane2 = new JSplitPane(1, panA, panB);
        this.splitPane = new JSplitPane(1, new JScrollPane(this.tagTree), this.splitPane2);
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setResizeWeight(0.5);
        this.splitPane2.setResizeWeight(0.5);
        this.editor.setContentType("text/flasm");
        this.decompiledEditor.setContentType("text/actionscript");
        this.tagTree.addTreeSelectionListener(this);
    }

    public void initSplits() {
        this.splitPane.setDividerLocation(this.getWidth() / 3);
        this.splitPane2.setDividerLocation(this.getWidth() / 3);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (Main.isWorking()) {
            return;
        }
        Object obj = this.tagTree.getLastSelectedPathComponent();
        if (obj instanceof TagNode && (obj = ((TagNode)obj).tag) instanceof ASMSource) {
            Main.startWork("Decompiling...");
            final ASMSource asm = (ASMSource)obj;
            new Thread(){

                @Override
                public void run() {
                    ActionPanel.this.editor.setText(asm.getASMSource(10));
                    List<Action> as = asm.getActions(10);
                    Action.setActionsAddresses(as, 0L, 10);
                    ActionPanel.this.decompiledEditor.setText(Highlighting.stripHilights(Action.actionsToSource(as, 10)));
                    Main.stopWork();
                }
            }.start();
        }
    }

    public void display() {
        this.setVisible(true);
        this.splitPane.setDividerLocation(0.5);
        this.splitPane2.setDividerLocation(0.5);
    }

    public List<TagNode> getSelectedNodes() {
        ArrayList<TagNode> ret = new ArrayList<TagNode>();
        TreePath[] tps = this.tagTree.getSelectionPaths();
        if (tps == null) {
            return ret;
        }
        for (TreePath tp : tps) {
            TagNode te = (TagNode)tp.getLastPathComponent();
            ret.add(te);
        }
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("SAVEACTION")) {
            TagNode ti = (TagNode)this.tagTree.getLastSelectedPathComponent();
            if (ti.tag instanceof ASMSource) {
                ASMSource dat = (ASMSource)ti.tag;
                try {
                    dat.setActions(ASMParser.parse(new ByteArrayInputStream(this.editor.getText().getBytes()), 10), 10);
                    this.valueChanged(null);
                    JOptionPane.showMessageDialog(this, "Code successfully saved");
                }
                catch (IOException ex) {
                }
                catch (ParseException ex) {
                    JOptionPane.showMessageDialog(this, "" + ex.text + " on line " + ex.line, "Error", 0);
                }
            }
        }
    }
}

