/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.types.traits;

import com.jpexs.asdec.abc.ABC;
import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.avm2.treemodel.TreeItem;
import com.jpexs.asdec.abc.types.Multiname;
import com.jpexs.asdec.abc.types.Namespace;
import com.jpexs.asdec.abc.types.ValueKind;
import com.jpexs.asdec.abc.types.traits.Trait;
import com.jpexs.asdec.helpers.Helper;
import com.jpexs.asdec.helpers.Highlighting;
import com.jpexs.asdec.tags.DoABCTag;
import java.util.HashMap;
import java.util.List;

public class TraitSlotConst
extends Trait {
    public int slot_id;
    public int type_index;
    public int value_index;
    public int value_kind;
    public TreeItem assignedValue;

    @Override
    public String toString(ABC abc, List<String> fullyQualifiedNames) {
        String typeStr = "*";
        if (this.type_index > 0) {
            typeStr = abc.constants.constant_multiname[this.type_index].toString(abc.constants, fullyQualifiedNames);
        }
        return "0x" + Helper.formatAddress(this.fileOffset) + " " + Helper.byteArrToString(this.bytes) + " SlotConst " + abc.constants.constant_multiname[this.name_index].toString(abc.constants, fullyQualifiedNames) + " slot=" + this.slot_id + " type=" + typeStr + " value=" + new ValueKind(this.value_index, this.value_kind).toString(abc.constants) + " metadata=" + Helper.intArrToString(this.metadata);
    }

    public String getType(ConstantPool constants, List<String> fullyQualifiedNames) {
        String typeStr = "*";
        if (this.type_index > 0) {
            typeStr = constants.constant_multiname[this.type_index].getName(constants, fullyQualifiedNames);
        }
        return typeStr;
    }

    public String getNameValueStr(ABC abc, List<String> fullyQualifiedNames) {
        String typeStr = this.getType(abc.constants, fullyQualifiedNames);
        typeStr = typeStr.equals("*") ? "" : ":" + typeStr;
        String valueStr = "";
        ValueKind val = null;
        if (this.value_kind != 0) {
            val = new ValueKind(this.value_index, this.value_kind);
            valueStr = " = " + val.toString(abc.constants);
        }
        if (this.assignedValue != null) {
            valueStr = " = " + Highlighting.stripHilights(this.assignedValue.toString(abc.constants, new HashMap<Integer, String>(), fullyQualifiedNames));
        }
        String slotconst = "var";
        if (this.kindType == 6) {
            slotconst = "const";
        }
        if (val != null && val.isNamespace()) {
            slotconst = "namespace";
        }
        return slotconst + " " + this.getName(abc).getName(abc.constants, fullyQualifiedNames) + typeStr + valueStr + ";";
    }

    public boolean isNamespace() {
        if (this.value_kind != 0) {
            ValueKind val = new ValueKind(this.value_index, this.value_kind);
            return val.isNamespace();
        }
        return false;
    }

    @Override
    public String convert(List<DoABCTag> abcTags, ABC abc, boolean isStatic, boolean pcode, int classIndex, boolean highlight, List<String> fullyQualifiedNames) {
        String modifier = this.getModifiers(abcTags, abc, isStatic) + " ";
        if (modifier.equals(" ")) {
            modifier = "";
        }
        Multiname n = this.getName(abc);
        boolean showModifier = true;
        if (classIndex == -1 && n != null) {
            Namespace ns = n.getNamespace(abc.constants);
            if (ns == null) {
                showModifier = false;
            } else if (ns.kind != 22 && ns.kind != 23) {
                showModifier = false;
            }
        }
        if (!showModifier) {
            modifier = "";
        }
        return ABC.IDENT_STRING + ABC.IDENT_STRING + modifier + this.getNameValueStr(abc, fullyQualifiedNames);
    }

    public boolean isConst() {
        return this.kindType == 6;
    }

    public boolean isVar() {
        return this.kindType == 0;
    }
}

