/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.types.traits;

import com.jpexs.asdec.abc.ABC;
import com.jpexs.asdec.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.asdec.abc.avm2.instructions.construction.NewFunctionIns;
import com.jpexs.asdec.abc.avm2.instructions.other.FindPropertyIns;
import com.jpexs.asdec.abc.avm2.instructions.other.FindPropertyStrictIns;
import com.jpexs.asdec.abc.avm2.instructions.other.GetLexIns;
import com.jpexs.asdec.abc.avm2.instructions.types.AsTypeIns;
import com.jpexs.asdec.abc.avm2.instructions.types.CoerceIns;
import com.jpexs.asdec.abc.avm2.treemodel.TreeItem;
import com.jpexs.asdec.abc.types.ABCException;
import com.jpexs.asdec.abc.types.MethodBody;
import com.jpexs.asdec.abc.types.Multiname;
import com.jpexs.asdec.abc.types.Namespace;
import com.jpexs.asdec.abc.types.NamespaceSet;
import com.jpexs.asdec.abc.types.ScriptInfo;
import com.jpexs.asdec.abc.types.traits.Trait;
import com.jpexs.asdec.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.asdec.abc.types.traits.TraitSlotConst;
import com.jpexs.asdec.abc.types.traits.Traits;
import com.jpexs.asdec.helpers.Helper;
import com.jpexs.asdec.helpers.Highlighting;
import com.jpexs.asdec.tags.DoABCTag;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class TraitClass
extends Trait {
    public int slot_id;
    public int class_info;
    private static final String[] builtInClasses = new String[]{"ArgumentError", "arguments", "Array", "Boolean", "Class", "Date", "DefinitionError", "Error", "EvalError", "Function", "int", "JSON", "Math", "Namespace", "Number", "Object", "QName", "RangeError", "ReferenceError", "RegExp", "SecurityError", "String", "SyntaxError", "TypeError", "uint", "URIError", "VerifyError", "XML", "XMLList"};

    private static boolean isBuiltInClass(String name) {
        for (String g : builtInClasses) {
            if (!g.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString(ABC abc, List<String> fullyQualifiedNames) {
        return "Class " + abc.constants.constant_multiname[this.name_index].toString(abc.constants, fullyQualifiedNames) + " slot=" + this.slot_id + " class_info=" + this.class_info + " metadata=" + Helper.intArrToString(this.metadata);
    }

    private boolean parseUsagesFromNS(List<DoABCTag> abcTags, ABC abc, List imports, List<String> uses, int namespace_index, String ignorePackage, String name) {
        String newimport;
        Namespace ns = abc.constants.constant_namespace[namespace_index];
        if (name.equals("")) {
            name = "*";
        }
        String oldimport = newimport = ns.getName(abc.constants);
        newimport = null;
        for (DoABCTag abcTag : abcTags) {
            String newname = abcTag.abc.nsValueToName(oldimport);
            if (newname.equals("-")) {
                return true;
            }
            if (newname.equals("")) continue;
            newimport = newname;
            break;
        }
        if (newimport != null) {
            if (!imports.contains(newimport)) {
                String usname;
                if (newimport.contains(":")) {
                    return true;
                }
                String pkg = "";
                if (newimport.contains(".")) {
                    pkg = newimport.substring(0, newimport.lastIndexOf("."));
                }
                if ((usname = newimport).contains(".")) {
                    usname = usname.substring(usname.lastIndexOf(".") + 1);
                }
                if (!pkg.equals(ignorePackage)) {
                    imports.add(newimport);
                }
                if (!uses.contains(usname)) {
                    uses.add(usname);
                }
            }
            return true;
        }
        return false;
    }

    private void parseImportsUsagesFromNS(List<DoABCTag> abcTags, ABC abc, List imports, List<String> uses, int namespace_index, String ignorePackage, String name) {
        String pkg;
        Namespace ns = abc.constants.constant_namespace[namespace_index];
        if (name.equals("")) {
            name = "*";
        }
        String newimport = ns.getName(abc.constants);
        if (this.parseUsagesFromNS(abcTags, abc, imports, uses, namespace_index, ignorePackage, name)) {
            return;
        }
        if (ns.kind != 22 && ns.kind != 23) {
            return;
        }
        if (newimport.equals("-")) {
            newimport = "";
        }
        if ((newimport = newimport + "." + name).contains(":")) {
            return;
        }
        if (!imports.contains(newimport) && !(pkg = newimport.substring(0, newimport.lastIndexOf("."))).equals(ignorePackage)) {
            imports.add(newimport);
        }
    }

    private void parseUsagesFromMultiname(List<DoABCTag> abcTags, ABC abc, List<String> imports, List<String> uses, Multiname m, String ignorePackage, List<String> fullyQualifiedNames) {
        if (m != null) {
            if (m.kind == 29) {
                if (m.qname_index != 0) {
                    this.parseUsagesFromMultiname(abcTags, abc, imports, uses, abc.constants.constant_multiname[m.qname_index], ignorePackage, fullyQualifiedNames);
                }
                for (Integer i : m.params) {
                    if (i == 0) continue;
                    this.parseUsagesFromMultiname(abcTags, abc, imports, uses, abc.constants.constant_multiname[i], ignorePackage, fullyQualifiedNames);
                }
                return;
            }
            Namespace ns = m.getNamespace(abc.constants);
            String name = m.getName(abc.constants, fullyQualifiedNames);
            NamespaceSet nss = m.getNamespaceSet(abc.constants);
            if (ns != null) {
                this.parseUsagesFromNS(abcTags, abc, imports, uses, m.namespace_index, ignorePackage, name);
            }
            if (nss != null && nss.namespaces.length == 1) {
                this.parseUsagesFromNS(abcTags, abc, imports, uses, nss.namespaces[0], ignorePackage, name);
            }
        }
    }

    private void parseImportsUsagesFromMultiname(List<DoABCTag> abcTags, ABC abc, List<String> imports, List<String> uses, Multiname m, String ignorePackage, List<String> fullyQualifiedNames) {
        if (m != null) {
            if (m.kind == 29) {
                if (m.qname_index != 0) {
                    this.parseImportsUsagesFromMultiname(abcTags, abc, imports, uses, abc.constants.constant_multiname[m.qname_index], ignorePackage, fullyQualifiedNames);
                }
                for (Integer i : m.params) {
                    if (i == 0) continue;
                    this.parseImportsUsagesFromMultiname(abcTags, abc, imports, uses, abc.constants.constant_multiname[i], ignorePackage, fullyQualifiedNames);
                }
                return;
            }
            Namespace ns = m.getNamespace(abc.constants);
            String name = m.getName(abc.constants, fullyQualifiedNames);
            NamespaceSet nss = m.getNamespaceSet(abc.constants);
            if (ns != null) {
                this.parseImportsUsagesFromNS(abcTags, abc, imports, uses, m.namespace_index, ignorePackage, name);
            }
            if (nss != null && nss.namespaces.length == 1) {
                this.parseImportsUsagesFromNS(abcTags, abc, imports, uses, nss.namespaces[0], ignorePackage, name);
            }
        }
    }

    private void parseImportsUsagesFromMethodInfo(List<DoABCTag> abcTags, ABC abc, int method_index, List<String> imports, List<String> uses, String ignorePackage, List<String> fullyQualifiedNames) {
        if (abc.method_info[method_index].ret_type != 0) {
            this.parseImportsUsagesFromMultiname(abcTags, abc, imports, uses, abc.constants.constant_multiname[abc.method_info[method_index].ret_type], ignorePackage, fullyQualifiedNames);
        }
        for (int t : abc.method_info[method_index].param_types) {
            if (t == 0) continue;
            this.parseImportsUsagesFromMultiname(abcTags, abc, imports, uses, abc.constants.constant_multiname[t], ignorePackage, fullyQualifiedNames);
        }
        MethodBody body = abc.findBody(method_index);
        if (body != null) {
            this.parseImportsUsagesFromTraits(abcTags, abc, body.traits, imports, uses, ignorePackage, fullyQualifiedNames);
            for (ABCException ex : body.exceptions) {
                this.parseImportsUsagesFromMultiname(abcTags, abc, imports, uses, abc.constants.constant_multiname[ex.type_index], ignorePackage, fullyQualifiedNames);
            }
            for (AVM2Instruction ins : body.code.code) {
                if (ins.definition instanceof NewFunctionIns) {
                    this.parseImportsUsagesFromMethodInfo(abcTags, abc, ins.operands[0], imports, uses, ignorePackage, fullyQualifiedNames);
                }
                if (ins.definition instanceof FindPropertyStrictIns || ins.definition instanceof FindPropertyIns || ins.definition instanceof GetLexIns || ins.definition instanceof CoerceIns || ins.definition instanceof AsTypeIns) {
                    int m = ins.operands[0];
                    if (m == 0) continue;
                    this.parseImportsUsagesFromMultiname(abcTags, abc, imports, uses, abc.constants.constant_multiname[m], ignorePackage, fullyQualifiedNames);
                    continue;
                }
                for (int k = 0; k < ins.definition.operands.length; ++k) {
                    if (ins.definition.operands[k] != 257) continue;
                    int multinameIndex = ins.operands[k];
                    this.parseUsagesFromMultiname(abcTags, abc, imports, uses, abc.constants.constant_multiname[multinameIndex], ignorePackage, fullyQualifiedNames);
                }
            }
        }
    }

    private void parseImportsUsagesFromTraits(List<DoABCTag> abcTags, ABC abc, Traits ts, List<String> imports, List<String> uses, String ignorePackage, List<String> fullyQualifiedNames) {
        for (Trait t : ts.traits) {
            this.parseImportsUsagesFromTrait(abcTags, abc, t, imports, uses, ignorePackage, fullyQualifiedNames);
        }
    }

    private void parseImportsUsagesFromTrait(List<DoABCTag> abcTags, ABC abc, Trait t, List<String> imports, List<String> uses, String ignorePackage, List<String> fullyQualifiedNames) {
        if (t instanceof TraitMethodGetterSetter) {
            TraitMethodGetterSetter tm = (TraitMethodGetterSetter)t;
            this.parseImportsUsagesFromMultiname(abcTags, abc, imports, uses, abc.constants.constant_multiname[tm.name_index], ignorePackage, fullyQualifiedNames);
            if (tm.method_info != 0) {
                this.parseImportsUsagesFromMethodInfo(abcTags, abc, tm.method_info, imports, uses, ignorePackage, fullyQualifiedNames);
            }
        }
        this.parseImportsUsagesFromMultiname(abcTags, abc, imports, uses, t.getName(abc), ignorePackage, fullyQualifiedNames);
        if (t instanceof TraitSlotConst) {
            TraitSlotConst ts = (TraitSlotConst)t;
            this.parseImportsUsagesFromMultiname(abcTags, abc, imports, uses, abc.constants.constant_multiname[ts.name_index], ignorePackage, fullyQualifiedNames);
            this.parseImportsUsagesFromMultiname(abcTags, abc, imports, uses, abc.constants.constant_multiname[ts.type_index], ignorePackage, fullyQualifiedNames);
        }
    }

    private List getImportsUsages(List<DoABCTag> abcTags, ABC abc, List<String> imports, List<String> uses, List<String> fullyQualifiedNames) {
        String packageName = abc.instance_info[this.class_info].getName(abc.constants).getNamespace(abc.constants).getName(abc.constants);
        this.parseImportsUsagesFromMultiname(abcTags, abc, imports, uses, abc.constants.constant_multiname[abc.instance_info[this.class_info].name_index], packageName, fullyQualifiedNames);
        if (abc.instance_info[this.class_info].super_index > 0) {
            this.parseImportsUsagesFromMultiname(abcTags, abc, imports, uses, abc.constants.constant_multiname[abc.instance_info[this.class_info].super_index], packageName, fullyQualifiedNames);
        }
        for (int i : abc.instance_info[this.class_info].interfaces) {
            this.parseImportsUsagesFromMultiname(abcTags, abc, imports, uses, abc.constants.constant_multiname[i], packageName, fullyQualifiedNames);
        }
        this.parseImportsUsagesFromTraits(abcTags, abc, abc.class_info[this.class_info].static_traits, imports, uses, packageName, fullyQualifiedNames);
        this.parseImportsUsagesFromMethodInfo(abcTags, abc, abc.class_info[this.class_info].cinit_index, imports, uses, packageName, fullyQualifiedNames);
        this.parseImportsUsagesFromTraits(abcTags, abc, abc.instance_info[this.class_info].instance_traits, imports, uses, packageName, fullyQualifiedNames);
        this.parseImportsUsagesFromMethodInfo(abcTags, abc, abc.instance_info[this.class_info].iinit_index, imports, uses, packageName, fullyQualifiedNames);
        return imports;
    }

    @Override
    public String convert(List<DoABCTag> abcTags, ABC abc, boolean isStatic, boolean pcode, int classIndex, boolean highlight, List<String> fullyQualifiedNames) {
        if (!highlight) {
            Highlighting.doHighlight = false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        String packageName = abc.instance_info[this.class_info].getName(abc.constants).getNamespace(abc.constants).getName(abc.constants);
        ArrayList<String> namesInThisPackage = new ArrayList<String>();
        for (DoABCTag tag : abcTags) {
            for (ScriptInfo si : tag.abc.script_info) {
                String path = si.getPath(tag.abc);
                String pkg = "";
                String name = path;
                if (path.contains(".")) {
                    pkg = path.substring(0, path.lastIndexOf("."));
                    name = path.substring(path.lastIndexOf(".") + 1);
                }
                if (!pkg.equals(packageName)) continue;
                namesInThisPackage.add(name);
            }
        }
        ArrayList<String> imports = new ArrayList<String>();
        ArrayList<String> uses = new ArrayList<String>();
        this.getImportsUsages(abcTags, abc, imports, uses, new ArrayList<String>());
        fullyQualifiedNames = new ArrayList<String>();
        ArrayList<String> importnames = new ArrayList<String>();
        importnames.addAll(namesInThisPackage);
        Iterator i$ = imports.iterator();
        while (i$.hasNext()) {
            String path;
            String name = path = (String)i$.next();
            String pkg = "";
            if (name.contains(".")) {
                pkg = name.substring(0, name.lastIndexOf("."));
                name = name.substring(name.lastIndexOf(".") + 1);
            }
            if (importnames.contains(name) || !pkg.equals("") && TraitClass.isBuiltInClass(name)) {
                fullyQualifiedNames.add(name);
                continue;
            }
            importnames.add(name);
        }
        for (String imp : imports) {
            if (imp.startsWith(".")) continue;
            out.println(ABC.IDENT_STRING + "import " + imp + ";");
        }
        out.println();
        for (String us : uses) {
            out.println(ABC.IDENT_STRING + "use namespace " + us + ";");
        }
        out.println();
        String classHeader = abc.instance_info[this.class_info].getClassHeaderStr(abc, fullyQualifiedNames);
        if (classHeader.startsWith("private ")) {
            classHeader = classHeader.substring("private ".length());
        }
        out.println(ABC.IDENT_STRING + classHeader);
        out.println(ABC.IDENT_STRING + "{");
        LinkedList<String> outTraits = new LinkedList<String>();
        String bodyStr = "";
        int bodyIndex = abc.findBodyIndex(abc.class_info[this.class_info].cinit_index);
        if (bodyIndex != -1) {
            bodyStr = abc.bodies[bodyIndex].toString(pcode, true, this.class_info, abc, abc.constants, abc.method_info, new Stack<TreeItem>(), true, highlight, fullyQualifiedNames, abc.class_info[this.class_info].static_traits);
        }
        String toPrint = Highlighting.stripHilights(bodyStr).equals("") ? ABC.addTabs(bodyStr, 3) : ABC.IDENT_STRING + ABC.IDENT_STRING + "{\r\n" + ABC.addTabs(bodyStr, 3) + "\r\n" + ABC.IDENT_STRING + ABC.IDENT_STRING + "}";
        if (highlight) {
            toPrint = Highlighting.hilighTrait(toPrint, abc.class_info[this.class_info].static_traits.traits.length + abc.instance_info[this.class_info].instance_traits.traits.length + 1);
        }
        outTraits.add(toPrint);
        if (!abc.instance_info[this.class_info].isInterface()) {
            String constructorParams;
            Namespace ns;
            String modifier = "";
            Multiname m = abc.constants.constant_multiname[abc.instance_info[this.class_info].name_index];
            if (m != null && (ns = m.getNamespace(abc.constants)) != null) {
                modifier = ns.getPrefix(abc) + " ";
                if (modifier.equals(" ")) {
                    modifier = "";
                }
                if (modifier.startsWith("private")) {
                    modifier = "";
                }
            }
            bodyStr = "";
            bodyIndex = abc.findBodyIndex(abc.instance_info[this.class_info].iinit_index);
            if (bodyIndex != -1) {
                bodyStr = ABC.addTabs(abc.bodies[bodyIndex].toString(pcode, false, this.class_info, abc, abc.constants, abc.method_info, new Stack<TreeItem>(), false, highlight, fullyQualifiedNames, abc.instance_info[this.class_info].instance_traits), 3);
                constructorParams = abc.method_info[abc.instance_info[this.class_info].iinit_index].getParamStr(abc.constants, abc.bodies[bodyIndex], abc, fullyQualifiedNames);
            } else {
                constructorParams = abc.method_info[abc.instance_info[this.class_info].iinit_index].getParamStr(abc.constants, null, abc, fullyQualifiedNames);
            }
            toPrint = ABC.IDENT_STRING + ABC.IDENT_STRING + modifier + "function " + abc.constants.constant_multiname[abc.instance_info[this.class_info].name_index].getName(abc.constants, new ArrayList<String>()) + "(" + constructorParams + ") {\r\n" + bodyStr + "\r\n" + ABC.IDENT_STRING + ABC.IDENT_STRING + "}";
            if (highlight) {
                toPrint = Highlighting.hilighTrait(toPrint, abc.class_info[this.class_info].static_traits.traits.length + abc.instance_info[this.class_info].instance_traits.traits.length);
            }
            outTraits.add(toPrint);
        }
        outTraits.add(abc.class_info[this.class_info].static_traits.convert(abcTags, abc, true, pcode, false, this.class_info, highlight, fullyQualifiedNames));
        outTraits.add(abc.instance_info[this.class_info].instance_traits.convert(abcTags, abc, false, pcode, false, this.class_info, highlight, fullyQualifiedNames));
        out.println(Helper.joinStrings(outTraits, "\r\n\r\n"));
        out.println(ABC.IDENT_STRING + "}");
        out.flush();
        Highlighting.doHighlight = true;
        return baos.toString();
    }

    @Override
    public Multiname getName(ABC abc) {
        return abc.constants.constant_multiname[abc.instance_info[this.class_info].name_index];
    }
}

