/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.types;

import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.types.Namespace;
import com.jpexs.asdec.abc.types.NamespaceSet;
import java.util.List;

public class Multiname {
    public static final int QNAME = 7;
    public static final int QNAMEA = 13;
    public static final int RTQNAME = 15;
    public static final int RTQNAMEA = 16;
    public static final int RTQNAMEL = 17;
    public static final int RTQNAMELA = 18;
    public static final int MULTINAME = 9;
    public static final int MULTINAMEA = 14;
    public static final int MULTINAMEL = 27;
    public static final int MULTINAMELA = 28;
    public static final int TYPENAME = 29;
    private static final int[] multinameKinds = new int[]{7, 13, 9, 14, 15, 16, 27, 17, 18, 28, 29};
    private static final String[] multinameKindNames = new String[]{"Qname", "QnameA", "Multiname", "MultinameA", "RTQname", "RTQnameA", "MultinameL", "RTQnameL", "RTQnameLA", "MultinameLA", "TypeName"};
    public int kind = -1;
    public int name_index = -1;
    public int namespace_index = -1;
    public int namespace_set_index = -1;
    public int qname_index = -1;
    public List<Integer> params;

    public Multiname(int kind, int name_index, int namespace_index, int namespace_set_index, int qname_index, List<Integer> params) {
        this.kind = kind;
        this.name_index = name_index;
        this.namespace_index = namespace_index;
        this.namespace_set_index = namespace_set_index;
        this.qname_index = qname_index;
        this.params = params;
    }

    public boolean isAttribute() {
        if (this.kind == 13) {
            return true;
        }
        if (this.kind == 14) {
            return true;
        }
        if (this.kind == 16) {
            return true;
        }
        if (this.kind == 18) {
            return true;
        }
        return this.kind == 28;
    }

    public boolean isRuntime() {
        if (this.kind == 15) {
            return true;
        }
        if (this.kind == 16) {
            return true;
        }
        if (this.kind == 27) {
            return true;
        }
        return this.kind == 28;
    }

    public boolean needsName() {
        if (this.kind == 17) {
            return true;
        }
        if (this.kind == 18) {
            return true;
        }
        if (this.kind == 27) {
            return true;
        }
        return this.kind == 28;
    }

    public boolean needsNs() {
        if (this.kind == 15) {
            return true;
        }
        if (this.kind == 16) {
            return true;
        }
        if (this.kind == 17) {
            return true;
        }
        return this.kind == 18;
    }

    public String getKindStr() {
        String kindStr = "?";
        for (int k = 0; k < multinameKinds.length; ++k) {
            if (multinameKinds[k] != this.kind) continue;
            kindStr = multinameKindNames[k];
            break;
        }
        return kindStr;
    }

    public String toString() {
        String kindStr = this.getKindStr();
        return "kind=" + kindStr + " name_index=" + this.name_index + " namespace_index=" + this.namespace_index + " namespace_set_index=" + this.namespace_set_index + " qname_index=" + this.qname_index + " params_size:" + this.params.size();
    }

    public String toString(ConstantPool constants, List<String> fullyQualifiedNames) {
        String kindStr = "?";
        for (int k = 0; k < multinameKinds.length; ++k) {
            if (multinameKinds[k] != this.kind) continue;
            kindStr = multinameKindNames[k] + " ";
            break;
        }
        String nameStr = "";
        if (this.name_index > 0) {
            nameStr = constants.constant_string[this.name_index];
        }
        if (this.name_index == 0) {
            nameStr = "*";
        }
        String namespaceStr = "";
        if (this.namespace_index > 0) {
            namespaceStr = constants.constant_namespace[this.namespace_index].toString(constants);
        }
        if (!namespaceStr.equals("")) {
            namespaceStr = namespaceStr + ".";
        }
        if (this.namespace_index == 0) {
            namespaceStr = "*.";
        }
        String namespaceSetStr = "";
        if (this.namespace_set_index > 0) {
            namespaceSetStr = " <NS:" + constants.constant_namespace_set[this.namespace_set_index].toString(constants) + ">";
        }
        String typeNameStr = "";
        if (this.kind == 29) {
            typeNameStr = this.typeNameToStr(constants, fullyQualifiedNames);
        }
        return namespaceStr + nameStr + namespaceSetStr + typeNameStr;
    }

    private String typeNameToStr(ConstantPool constants, List<String> fullyQualifiedNames) {
        String typeNameStr = constants.constant_multiname[this.qname_index].getName(constants, fullyQualifiedNames);
        if (!this.params.isEmpty()) {
            typeNameStr = typeNameStr + ".<";
            for (int i = 0; i < this.params.size(); ++i) {
                if (i > 0) {
                    typeNameStr = typeNameStr + ",";
                }
                typeNameStr = this.params.get(i) == 0 ? typeNameStr + "*" : typeNameStr + constants.constant_multiname[this.params.get(i)].getName(constants, fullyQualifiedNames);
            }
            typeNameStr = typeNameStr + ">";
        }
        return typeNameStr;
    }

    public String getName(ConstantPool constants, List<String> fullyQualifiedNames) {
        if (this.kind == 29) {
            return this.typeNameToStr(constants, fullyQualifiedNames);
        }
        if (this.name_index == -1) {
            return "";
        }
        if (this.name_index == 0) {
            return this.isAttribute() ? "@*" : "*";
        }
        String name = constants.constant_string[this.name_index];
        if (fullyQualifiedNames != null && fullyQualifiedNames.contains(name)) {
            return this.getNameWithNamespace(constants);
        }
        return (this.isAttribute() ? "@" : "") + name;
    }

    public String getNameWithNamespace(ConstantPool constants) {
        String nsname;
        String ret = "";
        Namespace ns = this.getNamespace(constants);
        if (ns != null && !(nsname = ns.getName(constants)).equals("")) {
            ret = ret + nsname + ".";
        }
        ret = ret + this.getName(constants, null);
        return ret;
    }

    public Namespace getNamespace(ConstantPool constants) {
        if (this.namespace_index == 0 || this.namespace_index == -1) {
            return null;
        }
        return constants.constant_namespace[this.namespace_index];
    }

    public NamespaceSet getNamespaceSet(ConstantPool constants) {
        if (this.namespace_set_index == 0) {
            return null;
        }
        if (this.namespace_set_index == -1) {
            return null;
        }
        return constants.constant_namespace_set[this.namespace_set_index];
    }
}

