/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.types;

import com.jpexs.asdec.abc.ABC;
import com.jpexs.asdec.abc.avm2.AVM2Code;
import com.jpexs.asdec.abc.avm2.CodeStats;
import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.avm2.treemodel.TreeItem;
import com.jpexs.asdec.abc.types.ABCException;
import com.jpexs.asdec.abc.types.MethodInfo;
import com.jpexs.asdec.abc.types.traits.Traits;
import com.jpexs.asdec.helpers.Highlighting;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class MethodBody
implements Cloneable {
    public int method_info;
    public int max_stack;
    public int max_regs;
    public int init_scope_depth;
    public int max_scope_depth;
    public byte[] codeBytes;
    public AVM2Code code;
    public ABCException[] exceptions = new ABCException[0];
    public Traits traits = new Traits();

    public String toString() {
        String s = "";
        s = s + "method_info=" + this.method_info + " max_stack=" + this.max_stack + " max_regs=" + this.max_regs + " scope_depth=" + this.init_scope_depth + " max_scope=" + this.max_scope_depth;
        s = s + "\r\nCode:\r\n" + this.code.toString();
        return s;
    }

    public HashMap<Integer, String> getLocalRegNames(ABC abc) {
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        for (int i = 1; i <= abc.method_info[this.method_info].param_types.length; ++i) {
            String paramName = "param" + i;
            if (abc.method_info[this.method_info].flagHas_paramnames()) {
                // empty if block
            }
            ret.put(i, paramName);
        }
        int pos = abc.method_info[this.method_info].param_types.length + 1;
        if (abc.method_info[this.method_info].flagNeed_arguments()) {
            ret.put(pos, "arguments");
            ++pos;
        }
        if (abc.method_info[this.method_info].flagNeed_rest()) {
            ret.put(pos, "rest");
            ++pos;
        }
        HashMap<Integer, String> debugRegNames = this.code.getLocalRegNamesFromDebug(abc);
        for (int k : debugRegNames.keySet()) {
            ret.put(k, debugRegNames.get(k));
        }
        return ret;
    }

    public String toString(boolean pcode, boolean isStatic, int classIndex, ABC abc, ConstantPool constants, MethodInfo[] method_info, Stack<TreeItem> scopeStack, boolean isStaticInitializer, boolean hilight, List<String> fullyQualifiedNames, Traits initTraits) {
        String s = "";
        if (pcode) {
            s = s + this.code.toASMSource(constants, this);
        } else {
            try {
                s = s + this.code.toSource(isStatic, classIndex, abc, constants, method_info, this, hilight, this.getLocalRegNames(abc), scopeStack, isStaticInitializer, fullyQualifiedNames, initTraits);
                s = s.trim();
                if (hilight) {
                    s = Highlighting.hilighMethod(s, this.method_info);
                }
            }
            catch (Exception ex) {
                s = "//error:" + ex.toString();
            }
        }
        return s;
    }

    public Object clone() throws CloneNotSupportedException {
        MethodBody ret = new MethodBody();
        ret.code = this.code;
        ret.codeBytes = this.codeBytes;
        ret.exceptions = this.exceptions;
        ret.max_regs = this.max_regs;
        ret.max_scope_depth = this.max_scope_depth;
        ret.max_stack = this.max_stack;
        ret.method_info = this.method_info;
        ret.init_scope_depth = this.init_scope_depth;
        ret.traits = this.traits;
        return ret;
    }

    public boolean autoFillStats(ABC abc) {
        CodeStats stats = this.code.getStats(abc, this);
        if (stats == null) {
            return false;
        }
        this.max_stack = stats.maxstack;
        this.max_scope_depth = this.init_scope_depth + stats.maxscope;
        this.max_regs = stats.maxlocal;
        abc.method_info[this.method_info].setFlagSetsdxns(stats.has_set_dxns);
        abc.method_info[this.method_info].setFlagNeed_activation(stats.has_activation);
        return true;
    }
}

