/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.types;

import com.jpexs.asdec.abc.avm2.AVM2Code;
import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.avm2.ConvertException;
import com.jpexs.asdec.helpers.Helper;
import java.util.List;

public class ABCException {
    public int start;
    public int end;
    public int target;
    public int type_index;
    public int name_index;

    public String toString() {
        return "Exception: startServer=" + Helper.formatAddress(this.start) + " end=" + Helper.formatAddress(this.end) + " target=" + this.target + " type_index=" + this.type_index + " name_index=" + this.name_index;
    }

    public String toString(ConstantPool constants, List<String> fullyQualifiedNames) {
        return "Exception: startServer=" + Helper.formatAddress(this.start) + " end=" + Helper.formatAddress(this.end) + " target=" + this.target + " type=\"" + this.getTypeName(constants, fullyQualifiedNames) + "\" name=\"" + this.getVarName(constants, fullyQualifiedNames) + "\"";
    }

    public String toString(ConstantPool constants, AVM2Code code, List<String> fullyQualifiedNames) {
        try {
            return "Exception: startServer=" + code.adr2pos(this.start) + ":" + code.code.get(code.adr2pos(this.start)).toStringNoAddress(constants, fullyQualifiedNames) + " end=" + code.adr2pos(this.end) + ":" + code.code.get(code.adr2pos(this.end)).toStringNoAddress(constants, fullyQualifiedNames) + " target=" + code.adr2pos(this.target) + ":" + code.code.get(code.adr2pos(this.target)).toStringNoAddress(constants, fullyQualifiedNames) + " type=\"" + this.getTypeName(constants, fullyQualifiedNames) + "\" name=\"" + this.getVarName(constants, fullyQualifiedNames) + "\"";
        }
        catch (ConvertException ex) {
            return "";
        }
    }

    public boolean isFinally() {
        return this.name_index == 0 && this.type_index == 0;
    }

    public String getVarName(ConstantPool constants, List<String> fullyQualifiedNames) {
        if (this.name_index == 0) {
            return "";
        }
        return constants.constant_multiname[this.name_index].getName(constants, fullyQualifiedNames);
    }

    public String getTypeName(ConstantPool constants, List<String> fullyQualifiedNames) {
        if (this.type_index == 0) {
            return "*";
        }
        return constants.constant_multiname[this.type_index].getName(constants, fullyQualifiedNames);
    }
}

