/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.gui;

import com.jpexs.asdec.Main;
import com.jpexs.asdec.abc.types.MethodBody;
import java.awt.Color;
import java.awt.Dimension;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MethodBodyParamsPanel
extends JPanel
implements ChangeListener {
    public JLabel maxStackLabel = new JLabel("Max stack:", 4);
    public JFormattedTextField maxStackField = new JFormattedTextField(NumberFormat.getNumberInstance());
    public JLabel localCountLabel = new JLabel("Local registers count:", 4);
    public JFormattedTextField localCountField = new JFormattedTextField(NumberFormat.getNumberInstance());
    public JLabel initScopeDepthLabel = new JLabel("Minimum scope depth:", 4);
    public JFormattedTextField initScopeDepthField = new JFormattedTextField(NumberFormat.getNumberInstance());
    public JLabel maxScopeDepthLabel = new JLabel("Maximum scope depth:", 4);
    public JFormattedTextField maxScopeDepthField = new JFormattedTextField(NumberFormat.getNumberInstance());
    public MethodBody body;
    public JCheckBox autoFillCheckBox = new JCheckBox("Auto fill on code save (GLOBAL SETTING)");
    public JLabel experimentalLabel = new JLabel("...EXPERIMENTAL");

    public MethodBodyParamsPanel() {
        this.setLayout(null);
        this.maxStackLabel.setBounds(10, 10, 150, 25);
        this.maxStackField.setBounds(170, 10, 75, 25);
        this.add(this.maxStackLabel);
        this.add(this.maxStackField);
        this.localCountLabel.setBounds(10, 40, 150, 25);
        this.localCountField.setBounds(170, 40, 75, 25);
        this.add(this.localCountLabel);
        this.add(this.localCountField);
        this.initScopeDepthLabel.setBounds(10, 70, 150, 25);
        this.initScopeDepthField.setBounds(170, 70, 75, 25);
        this.add(this.initScopeDepthLabel);
        this.add(this.initScopeDepthField);
        this.maxScopeDepthLabel.setBounds(10, 100, 150, 25);
        this.maxScopeDepthField.setBounds(170, 100, 75, 25);
        this.add(this.maxScopeDepthLabel);
        this.add(this.maxScopeDepthField);
        this.autoFillCheckBox.setBounds(30, 130, 230, 25);
        this.add(this.autoFillCheckBox);
        this.autoFillCheckBox.addChangeListener(this);
        this.experimentalLabel.setForeground(Color.red);
        this.experimentalLabel.setBounds(250, 130, 100, 25);
        this.add(this.experimentalLabel);
        this.setPreferredSize(new Dimension(300, 150));
    }

    public void loadFromBody(MethodBody body) {
        this.body = body;
        if (body == null) {
            this.maxStackField.setText("0");
            this.localCountField.setText("0");
            this.initScopeDepthField.setText("0");
            this.maxScopeDepthField.setText("0");
            return;
        }
        this.maxStackField.setText("" + body.max_stack);
        this.localCountField.setText("" + body.max_regs);
        this.initScopeDepthField.setText("" + body.init_scope_depth);
        this.maxScopeDepthField.setText("" + body.max_scope_depth);
    }

    public boolean save() {
        if (this.body != null) {
            this.body.init_scope_depth = Integer.parseInt(this.initScopeDepthField.getText());
            if (!this.autoFillCheckBox.isSelected()) {
                this.body.max_stack = Integer.parseInt(this.maxStackField.getText());
                this.body.max_regs = Integer.parseInt(this.localCountField.getText());
                this.body.max_scope_depth = Integer.parseInt(this.maxScopeDepthField.getText());
            } else if (!this.body.autoFillStats(Main.mainFrame.abcPanel.abc)) {
                JOptionPane.showMessageDialog(null, "Cannot get code stats for automatic body params.\r\nUncheck autofill to avoid this message.", "Warning", 2);
            }
            return true;
        }
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.autoFillCheckBox) {
            if (this.autoFillCheckBox.isSelected()) {
                this.localCountField.setEnabled(false);
                this.maxScopeDepthField.setEnabled(false);
                this.maxStackField.setEnabled(false);
            } else {
                this.localCountField.setEnabled(true);
                this.maxScopeDepthField.setEnabled(true);
                this.maxStackField.setEnabled(true);
            }
        }
    }
}

