/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.gui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Element;

public class LineMarkedEditorPane
extends JEditorPane {
    int lastLine = -1;

    public LineMarkedEditorPane() {
        this.setOpaque(false);
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int caretPosition = LineMarkedEditorPane.this.getCaretPosition();
                Element root = LineMarkedEditorPane.this.getDocument().getDefaultRootElement();
                int currentLine = root.getElementIndex(caretPosition);
                if (currentLine != LineMarkedEditorPane.this.lastLine) {
                    LineMarkedEditorPane.this.lastLine = currentLine;
                    LineMarkedEditorPane.this.repaint();
                }
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        int h;
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        FontMetrics fontMetrics = g.getFontMetrics();
        int lh = fontMetrics.getHeight();
        int a = fontMetrics.getAscent();
        int d = fontMetrics.getDescent();
        int rH = h = a + d;
        g.setColor(new Color(238, 238, 238));
        g.fillRect(0, d + lh * this.lastLine - 1, this.getWidth(), lh);
        super.paint(g);
    }
}

