/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.gui;

import java.awt.Component;
import java.net.URL;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class IconListRenderer
extends DefaultListCellRenderer {
    private Icon constIcon = this.loadIcon("com/jpexs/asdec/abc/gui/graphics/constant.png");
    private Icon functionIcon = this.loadIcon("com/jpexs/asdec/abc/gui/graphics/function.png");
    private Icon variableIcon = this.loadIcon("com/jpexs/asdec/abc/gui/graphics/variable.png");

    private Icon loadIcon(String path) {
        ClassLoader cldr = this.getClass().getClassLoader();
        URL imageURL = cldr.getResource(path);
        return new ImageIcon(imageURL);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String modifiersRegex = "(public |static |final |override |private |protected |package )*";
        if ((" " + value.toString()).contains(" const ")) {
            label.setIcon(this.constIcon);
        }
        if ((" " + value.toString()).contains(" var ")) {
            label.setIcon(this.variableIcon);
        }
        if ((" " + value.toString()).contains(" function ")) {
            label.setIcon(this.functionIcon);
        }
        if (value.toString().equals("class initializer")) {
            label.setIcon(this.functionIcon);
        }
        if (value.toString().equals("instance initializer")) {
            label.setIcon(this.functionIcon);
        }
        return label;
    }
}

