/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.gui;

import com.jpexs.asdec.Main;
import com.jpexs.asdec.abc.ABC;
import com.jpexs.asdec.abc.avm2.ConvertException;
import com.jpexs.asdec.abc.gui.LineMarkedEditorPane;
import com.jpexs.asdec.abc.types.ScriptInfo;
import com.jpexs.asdec.abc.types.traits.Trait;
import com.jpexs.asdec.abc.types.traits.TraitSlotConst;
import com.jpexs.asdec.helpers.Highlighting;
import com.jpexs.asdec.tags.DoABCTag;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class DecompiledEditorPane
extends LineMarkedEditorPane
implements MouseListener,
CaretListener {
    private List<Highlighting> highlights = new ArrayList<Highlighting>();
    private List<Highlighting> traitHighlights = new ArrayList<Highlighting>();
    private List<Highlighting> methodHighlights = new ArrayList<Highlighting>();
    private List<Highlighting> classHighlights = new ArrayList<Highlighting>();
    private ABC abc;
    private ScriptInfo script;
    public int lastTraitIndex = 0;
    private int classIndex = -1;
    private HashMap<ScriptInfo, BufferedClass> bufferedClasses = new HashMap();
    private List<DoABCTag> abcList;

    public void setNoTrait() {
        Main.mainFrame.abcPanel.detailPanel.showCard("-");
    }

    public void setClassIndex(int classIndex) {
        this.classIndex = classIndex;
    }

    private boolean displayMethod(int pos, int methodIndex) {
        int bi = this.abc.findBodyIndex(methodIndex);
        if (bi == -1) {
            return false;
        }
        Main.mainFrame.abcPanel.detailPanel.showCard("Method/Getter/Setter Trait");
        if (Main.mainFrame.abcPanel.detailPanel.methodTraitPanel.methodCodePanel.sourceTextArea.bodyIndex != bi) {
            Main.mainFrame.abcPanel.detailPanel.methodTraitPanel.methodCodePanel.sourceTextArea.setBodyIndex(bi, this.abc);
            Main.mainFrame.abcPanel.detailPanel.methodTraitPanel.methodBodyParamsPanel.loadFromBody(this.abc.bodies[bi]);
            Main.mainFrame.abcPanel.detailPanel.methodTraitPanel.methodInfoPanel.load(this.abc.bodies[bi].method_info, this.abc);
        }
        boolean success = false;
        for (Highlighting h : this.highlights) {
            if (pos < h.startPos || pos >= h.startPos + h.len) continue;
            try {
                Main.mainFrame.abcPanel.detailPanel.methodTraitPanel.methodCodePanel.sourceTextArea.selectInstruction(this.abc.bodies[bi].code.adr2pos(h.offset));
            }
            catch (ConvertException ex) {
                // empty catch block
            }
            success = true;
        }
        return success;
    }

    public void displayClass(int classIndex) {
        if (Main.mainFrame.abcPanel.navigator.getClassIndex() != classIndex) {
            Main.mainFrame.abcPanel.navigator.setClassIndex(classIndex);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.getCaret().setVisible(true);
        int pos = this.getCaretPosition();
        this.classIndex = -1;
        for (Highlighting cm : this.classHighlights) {
            if (pos < cm.startPos || pos >= cm.startPos + cm.len) continue;
            this.classIndex = (int)cm.offset;
            this.displayClass(this.classIndex);
            break;
        }
        if (this.classIndex == -1) {
            this.setNoTrait();
            return;
        }
        for (Highlighting tm : this.methodHighlights) {
            if (pos < tm.startPos || pos >= tm.startPos + tm.len) continue;
            this.displayMethod(pos, (int)tm.offset);
            return;
        }
        for (Highlighting th : this.traitHighlights) {
            if (pos < th.startPos || pos >= th.startPos + th.len) continue;
            this.lastTraitIndex = (int)th.offset;
            Trait tr = this.abc.findTraitByTraitId(this.classIndex, (int)th.offset);
            if (tr != null && tr instanceof TraitSlotConst) {
                Main.mainFrame.abcPanel.detailPanel.slotConstTraitPanel.load((TraitSlotConst)tr, this.abc);
                Main.mainFrame.abcPanel.detailPanel.showCard("Slot/Const Trait");
                return;
            }
            this.displayMethod(pos, this.abc.findMethodIdByTraitId(this.classIndex, (int)th.offset));
            return;
        }
        this.setNoTrait();
    }

    public void gotoLastTrait() {
        this.gotoTrait(this.lastTraitIndex);
    }

    public void gotoTrait(int traitId) {
        if (traitId == -1) {
            this.setCaretPosition(0);
            return;
        }
        for (Highlighting tc : this.classHighlights) {
            if (tc.offset != (long)this.classIndex) continue;
            for (Highlighting th : this.traitHighlights) {
                if (th.startPos <= tc.startPos || th.startPos + th.len >= tc.startPos + tc.len || th.offset != (long)traitId) continue;
                try {
                    this.setCaretPosition(th.startPos + th.len - 1);
                    this.setCaretPosition(th.startPos);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
                return;
            }
        }
        this.setCaretPosition(0);
    }

    public DecompiledEditorPane() {
        this.addMouseListener(this);
        this.setEditable(false);
        this.getCaret().setVisible(true);
        this.addCaretListener(this);
    }

    public void setScript(ScriptInfo script, ABC abc, List<DoABCTag> abcList) {
        String hilightedCode;
        this.setText("//Please wait...");
        if (script == null) {
            this.highlights = new ArrayList<Highlighting>();
            this.traitHighlights = new ArrayList<Highlighting>();
            this.methodHighlights = new ArrayList<Highlighting>();
            this.script = null;
            return;
        }
        if (!this.bufferedClasses.containsKey(script)) {
            hilightedCode = script.convert(abcList, abc, false, true);
            this.highlights = Highlighting.getInstrHighlights(hilightedCode);
            this.traitHighlights = Highlighting.getTraitHighlights(hilightedCode);
            this.methodHighlights = Highlighting.getMethodHighlights(hilightedCode);
            this.classHighlights = Highlighting.getClassHighlights(hilightedCode);
            hilightedCode = Highlighting.stripHilights(hilightedCode);
            this.bufferedClasses.put(script, new BufferedClass(hilightedCode, this.highlights, this.traitHighlights, this.methodHighlights, this.classHighlights));
        } else {
            BufferedClass bc = this.bufferedClasses.get(script);
            hilightedCode = bc.text;
            this.highlights = bc.highlights;
            this.traitHighlights = bc.traitHighlights;
            this.methodHighlights = bc.methodHighlights;
        }
        this.setText(hilightedCode);
        this.abc = abc;
        this.abcList = abcList;
        this.script = script;
    }

    public void reloadClass() {
        if (this.bufferedClasses.containsKey(this.script)) {
            this.bufferedClasses.remove(this.script);
        }
        this.setScript(this.script, this.abc, this.abcList);
        this.setNoTrait();
    }

    public void setABC(ABC abc) {
        this.abc = abc;
        this.bufferedClasses.clear();
        this.setText("");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class BufferedClass {
        public String text;
        public List<Highlighting> highlights;
        public List<Highlighting> traitHighlights;
        public List<Highlighting> methodHighlights;
        public List<Highlighting> classHighlights;

        public BufferedClass(String text, List<Highlighting> highlights, List<Highlighting> traitHighlights, List<Highlighting> methodHighlights, List<Highlighting> classHighlights) {
            this.text = text;
            this.highlights = highlights;
            this.traitHighlights = traitHighlights;
            this.methodHighlights = methodHighlights;
            this.classHighlights = classHighlights;
        }
    }
}

