/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.avm2.treemodel;

import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.asdec.abc.avm2.treemodel.LocalRegTreeItem;
import com.jpexs.asdec.abc.avm2.treemodel.TreeItem;
import com.jpexs.asdec.abc.types.Namespace;
import java.util.HashMap;
import java.util.List;

public class FullMultinameTreeItem
extends TreeItem {
    public int multinameIndex;
    public TreeItem name;
    public TreeItem namespace;

    public FullMultinameTreeItem(AVM2Instruction instruction, int multinameIndex, TreeItem name) {
        super(instruction, 0);
        this.multinameIndex = multinameIndex;
        this.name = name;
        this.namespace = null;
    }

    public FullMultinameTreeItem(AVM2Instruction instruction, int multinameIndex) {
        super(instruction, 0);
        this.multinameIndex = multinameIndex;
        this.name = null;
        this.namespace = null;
    }

    public FullMultinameTreeItem(AVM2Instruction instruction, int multinameIndex, TreeItem name, TreeItem namespace) {
        super(instruction, 0);
        this.multinameIndex = multinameIndex;
        this.name = name;
        this.namespace = namespace;
    }

    public boolean isRuntime() {
        return this.name != null || this.namespace != null;
    }

    public boolean isXML(ConstantPool constants, HashMap<Integer, String> localRegNames, List<String> fullyQualifiedNames) {
        String cname = this.name != null ? this.name.toString(constants, localRegNames, fullyQualifiedNames) : constants.constant_multiname[this.multinameIndex].getName(constants, fullyQualifiedNames);
        String cns = "";
        if (this.namespace != null) {
            cns = this.namespace.toString(constants, localRegNames, fullyQualifiedNames);
        } else {
            Namespace ns = constants.constant_multiname[this.multinameIndex].getNamespace(constants);
            if (ns != null && ns.name_index != 0) {
                cns = ns.getName(constants);
            }
        }
        return cname.equals("XML") && cns.equals("");
    }

    @Override
    public String toString(ConstantPool constants, HashMap<Integer, String> localRegNames, List<String> fullyQualifiedNames) {
        String ret = "";
        ret = this.name != null ? "[" + this.name.toString(constants, localRegNames, fullyQualifiedNames) + "]" : this.hilight(constants.constant_multiname[this.multinameIndex].getName(constants, fullyQualifiedNames));
        if (this.namespace != null) {
            ret = this.namespace.toString(constants, localRegNames, fullyQualifiedNames) + "::" + ret;
        }
        return ret;
    }

    public boolean compareSame(FullMultinameTreeItem other) {
        if (this.multinameIndex != other.multinameIndex) {
            return false;
        }
        TreeItem tiName = this.name;
        while (tiName instanceof LocalRegTreeItem) {
            tiName = ((LocalRegTreeItem)tiName).computedValue;
        }
        TreeItem tiName2 = other.name;
        while (tiName2 instanceof LocalRegTreeItem) {
            tiName2 = ((LocalRegTreeItem)tiName2).computedValue;
        }
        if (tiName != tiName2) {
            return false;
        }
        TreeItem tiNameSpace = this.namespace;
        while (tiNameSpace instanceof LocalRegTreeItem) {
            tiNameSpace = ((LocalRegTreeItem)tiNameSpace).computedValue;
        }
        TreeItem tiNameSpace2 = other.namespace;
        while (tiNameSpace2 instanceof LocalRegTreeItem) {
            tiNameSpace2 = ((LocalRegTreeItem)tiNameSpace2).computedValue;
        }
        return tiNameSpace == tiNameSpace2;
    }
}

