/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.avm2.treemodel;

import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.asdec.abc.avm2.treemodel.FullMultinameTreeItem;
import com.jpexs.asdec.abc.avm2.treemodel.TreeItem;
import com.jpexs.asdec.helpers.Highlighting;
import java.util.HashMap;
import java.util.List;

public class CallSuperTreeItem
extends TreeItem {
    public TreeItem receiver;
    public FullMultinameTreeItem multiname;
    public List<TreeItem> arguments;
    public boolean isVoid;

    public CallSuperTreeItem(AVM2Instruction instruction, boolean isVoid, TreeItem receiver, FullMultinameTreeItem multiname, List<TreeItem> arguments) {
        super(instruction, 0);
        this.receiver = receiver;
        this.multiname = multiname;
        this.arguments = arguments;
        this.isVoid = isVoid;
    }

    @Override
    public String toString(ConstantPool constants, HashMap<Integer, String> localRegNames, List<String> fullyQualifiedNames) {
        String args = "";
        for (int a = 0; a < this.arguments.size(); ++a) {
            if (a > 0) {
                args = args + ",";
            }
            args = args + this.arguments.get(a).toString(constants, localRegNames, fullyQualifiedNames);
        }
        String calee = this.receiver.toString(constants, localRegNames, fullyQualifiedNames) + ".";
        if (Highlighting.stripHilights(calee).equals("this.")) {
            calee = "";
        }
        return calee + this.hilight("super.") + this.multiname.toString(constants, localRegNames, fullyQualifiedNames) + this.hilight("(") + args + this.hilight(")");
    }
}

