/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc;

import com.jpexs.asdec.abc.types.Decimal;
import com.jpexs.asdec.abc.types.InstanceInfo;
import com.jpexs.asdec.abc.types.MethodInfo;
import com.jpexs.asdec.abc.types.Multiname;
import com.jpexs.asdec.abc.types.Namespace;
import com.jpexs.asdec.abc.types.traits.Trait;
import com.jpexs.asdec.abc.types.traits.TraitClass;
import com.jpexs.asdec.abc.types.traits.TraitFunction;
import com.jpexs.asdec.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.asdec.abc.types.traits.TraitSlotConst;
import com.jpexs.asdec.abc.types.traits.Traits;
import java.io.IOException;
import java.io.OutputStream;

public class ABCOutputStream
extends OutputStream {
    private OutputStream os;

    public ABCOutputStream(OutputStream os) {
        this.os = os;
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
    }

    public void writeU30(long value) throws IOException {
        this.writeS32(value);
    }

    public void writeU32(long value) throws IOException {
        boolean loop = true;
        value &= 0xFFFFFFFFFFFFFFFFL;
        do {
            int ret = (int)(value & 0x7FL);
            if (value < 128L) {
                loop = false;
            }
            if (value > 127L) {
                ret += 128;
            }
            this.write(ret);
            value >>= 7;
        } while (loop);
    }

    public void writeS24(long value) throws IOException {
        int ret = (int)(value & 0xFFL);
        this.write(ret);
        ret = (int)((value >>= 8) & 0xFFL);
        this.write(ret);
        ret = (int)((value >>= 8) & 0xFFL);
        this.write(ret);
    }

    public void writeS32(long value) throws IOException {
        boolean belowZero = value < 0L;
        int bitcount = 0;
        boolean loop = true;
        do {
            bitcount += 7;
            int ret = (int)(value & 0x7FL);
            if (value < 128L) {
                if (belowZero) {
                    ret += 128;
                } else {
                    loop = false;
                }
            } else {
                ret += 128;
            }
            if (bitcount == 35) {
                ret &= 0xF;
            }
            this.write(ret);
            if (bitcount == 35) break;
            value >>= 7;
        } while (loop);
    }

    public void writeLong(long value) throws IOException {
        byte[] writeBuffer = new byte[8];
        writeBuffer[7] = (byte)(value >>> 56);
        writeBuffer[6] = (byte)(value >>> 48);
        writeBuffer[5] = (byte)(value >>> 40);
        writeBuffer[4] = (byte)(value >>> 32);
        writeBuffer[3] = (byte)(value >>> 24);
        writeBuffer[2] = (byte)(value >>> 16);
        writeBuffer[1] = (byte)(value >>> 8);
        writeBuffer[0] = (byte)value;
        this.write(writeBuffer);
    }

    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeU8(int value) throws IOException {
        this.write(value);
    }

    public void writeU16(int value) throws IOException {
        this.write(value & 0xFF);
        this.write(value >> 8 & 0xFF);
    }

    public void writeString(String s) throws IOException {
        byte[] sbytes = s.getBytes("utf8");
        this.writeU30(sbytes.length);
        this.write(sbytes);
    }

    public void writeNamespace(Namespace ns) throws IOException {
        this.write(ns.kind);
        for (int k = 0; k < Namespace.nameSpaceKinds.length; ++k) {
            if (Namespace.nameSpaceKinds[k] != ns.kind) continue;
            this.writeU30(ns.name_index);
            break;
        }
    }

    public void writeMultiname(Multiname m) throws IOException {
        this.writeU8(m.kind);
        if (m.kind == 7 || m.kind == 13) {
            this.writeU30(m.namespace_index);
            this.writeU30(m.name_index);
        }
        if (m.kind == 9 || m.kind == 14) {
            this.writeU30(m.name_index);
            this.writeU30(m.namespace_set_index);
        }
        if (m.kind == 15 || m.kind == 16) {
            this.writeU30(m.name_index);
        }
        if (m.kind == 27 || m.kind == 28) {
            this.writeU30(m.namespace_set_index);
        }
        if (m.kind == 29) {
            this.writeU30(m.qname_index);
            this.writeU30(m.params.size());
            for (int i = 0; i < m.params.size(); ++i) {
                this.writeU30(m.params.get(i).intValue());
            }
        }
    }

    public void writeMethodInfo(MethodInfo mi) throws IOException {
        int i;
        this.writeU30(mi.param_types.length);
        this.writeU30(mi.ret_type);
        for (i = 0; i < mi.param_types.length; ++i) {
            this.writeU30(mi.param_types[i]);
        }
        this.writeU30(mi.name_index);
        this.write(mi.flags);
        if ((mi.flags & 8) == 8) {
            this.writeU30(mi.optional.length);
            for (i = 0; i < mi.optional.length; ++i) {
                this.writeU30(mi.optional[i].value_index);
                this.write(mi.optional[i].value_kind);
            }
        }
        if ((mi.flags & 0x80) == 128) {
            for (i = 0; i < mi.paramNames.length; ++i) {
                this.writeU30(mi.paramNames[i]);
            }
        }
    }

    public void writeTrait(Trait t) throws IOException {
        this.writeU30(t.name_index);
        this.write((t.kindFlags << 4) + t.kindType);
        if (t instanceof TraitSlotConst) {
            TraitSlotConst t1 = (TraitSlotConst)t;
            this.writeU30(t1.slot_id);
            this.writeU30(t1.type_index);
            this.writeU30(t1.value_index);
            if (t1.value_index != 0) {
                this.write(t1.value_kind);
            }
        }
        if (t instanceof TraitMethodGetterSetter) {
            TraitMethodGetterSetter t2 = (TraitMethodGetterSetter)t;
            this.writeU30(t2.disp_id);
            this.writeU30(t2.method_info);
        }
        if (t instanceof TraitClass) {
            TraitClass t3 = (TraitClass)t;
            this.writeU30(t3.slot_id);
            this.writeU30(t3.class_info);
        }
        if (t instanceof TraitFunction) {
            TraitFunction t4 = (TraitFunction)t;
            this.writeU30(t4.slot_index);
            this.writeU30(t4.method_info);
        }
        if ((t.kindFlags & 4) == 4) {
            this.writeU30(t.metadata.length);
            for (int i = 0; i < t.metadata.length; ++i) {
                this.writeU30(t.metadata[i]);
            }
        }
    }

    public void writeTraits(Traits t) throws IOException {
        this.writeU30(t.traits.length);
        for (int i = 0; i < t.traits.length; ++i) {
            this.writeTrait(t.traits[i]);
        }
    }

    public void writeInstanceInfo(InstanceInfo ii) throws IOException {
        this.writeU30(ii.name_index);
        this.writeU30(ii.super_index);
        this.write(ii.flags);
        if ((ii.flags & 8) == 8) {
            this.writeU30(ii.protectedNS);
        }
        this.writeU30(ii.interfaces.length);
        for (int i = 0; i < ii.interfaces.length; ++i) {
            this.writeU30(ii.interfaces[i]);
        }
        this.writeU30(ii.iinit_index);
        this.writeTraits(ii.instance_traits);
    }

    public void writeDecimal(Decimal value) throws IOException {
        this.write(value.data);
    }
}

