# FHTTP Kit by Xianur0
# Copyright (C) 2011 Oscar García López (http://hackingtelevision.blogspot.com) 
#  
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#   
#    xianur0.null@gmail.com
#    http://hackingtelevision.blogspot.com/

package proxymodulos;

use lib("tools");
use tools;
use threads;


use Switch;

my @uricallbacks = (
							uricall,
						);
my @reqlinecallbacks = (
							rlcall,
						);
my @headercallbacks = (
							headercall,
						);
my @postdatacallbacks = (
							postcall,
						);
my @rheadercallbacks = (
							rheadercall,
						);
my @rcontenidocallbacks = (
							rcontenidocall,
						);

my @todocallbacks = (
							todocall,
						);

push(@uricallbacks,@todocallbacks);
push(@rcontenidocallbacks,@todocallbacks);
push(@rheadercallbacks,@todocallbacks);
push(@postdatacallbacks,@todocallbacks);
push(@headercallbacks,@todocallbacks);
push(@reqlinecallbacks,@todocallbacks);

sub new {
	my ($class) = @_;
	my $self = {};
	bless $self, $class;
	return $self;
}

sub callbacks {
	my ($self,$tipo,$resto,$paqenvio) = @_;
	my @callbacks;
	my ($header,$valor);
	switch($tipo) {
		case 'url' {
			@callbacks = @uricallbacks;
		}
		case 'reqline' {
			@callbacks = @reqlinecallbacks;
		}
		case 'header' {
			@callbacks = @headercallbacks;
		}
		case 'postdata' {
			@callbacks = @postdatacallbacks;
		}
		case 'rheader' {
			@callbacks = @rheadercallbacks;
		}
		case 'rcontenido' {
			@callbacks = @rcontenidocallbacks;
		}
	}
	foreach $callback(@callbacks) {
			$resto = $callback->($resto,$paqenvio);
	}
	return $resto;
}

sub uricall {
	my $uri = $_[0];
	return $uri;
}

sub rlcall {
	my $todo = $_[0];
	return $todo;
}

sub headercall {
	my $header = $_[0];
	return $header;
}

sub postcall {
	my $post = $_[0];
	return $post;
}
sub rheadercall {
	my $rheader = $_[0];
	my $paqenvio = $_[1];
	my @lineas = split(/[\r\n]+/,$paqenvio);
	return $rheader;
}

sub rcontenidocall {
	my $rcontenido = $_[0];
	my $paqenvio = $_[1];
# Ejemplo de Imagen Spider :P
#	my $host = "";
#	my @lineas = split(/[\r\n]+/,$paqenvio); # $lineas[0] = req line
#	if($paqenvio =~ /[\r\n]+Accept: image\//i) {
#		open IMAGENES,">>imagenes.txt";
#		my ($url) = ($lineas[0] =~ /^\w+([\s\t]+)([^\s\t]+)/);
#		foreach $header (@lineas) {
#			if(($header =~ /Host:\s+([^\r\n]+)/)) {
#				$host = $1;
#				last;
#			}
#		}
#
#		if($url !~ /^http/) {
#			$url = "http://".$host.(($url !~ /^\//) ? "/" : "").$url;
#		}
#		print IMAGENES $url."\n";
#		close(IMAGENES);
#	}
# Ejemplo de Link Spider :P
#	my %links = tools::geturls($rcontenido);
#	while(my ($link,$veces) = each(%links)) {
#		open LOG, ">reportes.txt";
#		print LOG $links."\n";
#		close(LOG);
#	}
	return $rcontenido;
}

sub todocall {
	my $todo = $_[0];
	my $paqenvio = $_[1];
	my @lineas = split(/[\r\n]+/,$paqenvio); # $lineas[0] = req line
	return $todo;
}
1;
