// LICENSE : MIT
"use strict";

module.exports = function () {
    return {
        visitor: {
            CallExpression: function CallExpression(path) {
                var stripFunctionNameList = this.opts.strip || [];
                var isMatched = stripFunctionNameList.some(function (fnName) {
                    // method call
                    var calleePath = path.get("callee");
                    if (calleePath.matchesPattern(fnName)) {
                        // ignore computed style
                        // e.g.) console["log"]()
                        return !calleePath.node.computed;
                    }
                    // function call
                    return calleePath.node.name === fnName;
                });
                if (isMatched) {
                    path.remove();
                }
            }
        }
    };
};
//# sourceMappingURL=babel-plugin-strip-function-call.js.map