/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.OpenFile;
import gui.about;
import java.awt.EventQueue;
import java.awt.SystemColor;
import java.awt.Window;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;

public class MainDialog
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JTextField txtImage;
    private JTextField txtEXE;
    private String color = null;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        EventQueue.invokeLater(() -> {
            try {
                MainDialog frame = new MainDialog();
                frame.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public MainDialog() {
        this.setType(Window.Type.UTILITY);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setTitle("EXE to Image Converter v1.1");
        this.setDefaultCloseOperation(3);
        this.setSize(395, 333);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setBackground(SystemColor.control);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setBounds(30, 96, 337, 61);
        this.contentPane.add(textArea);
        this.txtImage = new JTextField();
        this.txtImage.setText("Input EXE or Image");
        this.txtImage.setEditable(false);
        this.txtImage.setBounds(14, 20, 256, 23);
        this.contentPane.add(this.txtImage);
        this.txtImage.setColumns(10);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setBounds(14, 108, 355, 125);
        this.contentPane.add(scrollPane);
        JProgressBar progressBar = new JProgressBar();
        progressBar.setBounds(14, 244, 355, 14);
        this.contentPane.add(progressBar);
        progressBar.setStringPainted(true);
        OpenFile of = new OpenFile(textArea);
        JButton btnBrowseInput = new JButton("Browse");
        btnBrowseInput.addActionListener(e -> {
            progressBar.setValue(0);
            try {
                of.pickFile();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.txtImage.setText(openFile.file.toString());
            textArea.setAutoscrolls(true);
            if (of.ext(openFile.file.toString()).contains("exe")) {
                textArea.setText("Loaded an EXE File\n");
            } else if (of.ext(openFile.file.toString()).contains("png")) {
                textArea.setText("Loaded an Image File\n");
            } else {
                textArea.setText("Invalid File\n");
            }
        });
        JButton btnBrowseOutput = new JButton("Browse");
        btnBrowseOutput.addActionListener(e -> {
            progressBar.setIndeterminate(true);
            progressBar.setValue(0);
            try {
                of.pickDir();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.txtEXE.setText(openFile.outFile.toString());
            textArea.append("Loaded the output path\n");
        });
        JButton btnConvert = new JButton("Convert");
        btnConvert.addActionListener(e -> {
            try {
                if (openFile.outFile == null) {
                    JOptionPane.showMessageDialog(null, "Please select output location", "Error", 0);
                } else if (this.color == null) {
                    JOptionPane.showMessageDialog(null, "Please select a color", "Error", 0);
                } else if (of.ext(openFile.file.toString()).contains("exe")) {
                    try {
                        of.EXEtoImage(progressBar, this.color);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else if (of.ext(openFile.file.toString()).contains("png")) {
                    try {
                        of.ImagetoEXE(progressBar, this.color);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
            catch (NullPointerException e2) {
                JOptionPane.showMessageDialog(null, "Please select an EXE or an Image File", "Error", 0);
            }
        });
        btnBrowseInput.setBounds(280, 20, 89, 23);
        this.contentPane.add(btnBrowseInput);
        this.txtEXE = new JTextField();
        this.txtEXE.setEditable(false);
        this.txtEXE.setText("Output Location");
        this.txtEXE.setBounds(14, 54, 256, 23);
        this.contentPane.add(this.txtEXE);
        this.txtEXE.setColumns(10);
        btnBrowseOutput.setBounds(280, 54, 89, 23);
        this.contentPane.add(btnBrowseOutput);
        btnConvert.setBounds(89, 268, 89, 23);
        this.contentPane.add(btnConvert);
        JButton btnAbout = new JButton("About");
        btnAbout.addActionListener(e -> {
            about abt = new about();
            abt.About();
        });
        btnAbout.setBounds(181, 268, 89, 23);
        this.contentPane.add(btnAbout);
        JRadioButton rbtnR = new JRadioButton("Red");
        rbtnR.setBounds(14, 85, 48, 20);
        this.contentPane.add(rbtnR);
        JRadioButton rbtnG = new JRadioButton("Green");
        rbtnG.setBounds(59, 84, 55, 23);
        this.contentPane.add(rbtnG);
        JRadioButton rbtnB = new JRadioButton("Blue");
        rbtnB.setBounds(115, 84, 45, 23);
        this.contentPane.add(rbtnB);
        ButtonGroup group = new ButtonGroup();
        group.add(rbtnR);
        group.add(rbtnG);
        group.add(rbtnB);
        rbtnR.addActionListener(e -> {
            String string = this.color = "red";
        });
        rbtnG.addActionListener(e -> {
            String string = this.color = "green";
        });
        rbtnB.addActionListener(e -> {
            String string = this.color = "blue";
        });
    }
}

